/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.generation.core;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.binis.codegen.annotation.CodePrototype;
import net.binis.codegen.enrich.Enricher;
import net.binis.codegen.enrich.PrototypeEnricher;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.generation.core.Generator;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.Structures;
import net.binis.codegen.tools.Holder;
import net.binis.codegen.tools.Reflection;
import net.binis.codegen.tools.Tools;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompiledPrototypesHandler {
    private static final Logger log = LoggerFactory.getLogger(CompiledPrototypesHandler.class);

    private CompiledPrototypesHandler() {
    }

    public static boolean handleCompiledPrototype(String compiledPrototype) {
        Holder<Boolean> result = Holder.of(false);
        Tools.notNull(Reflection.loadClass((String)compiledPrototype), c -> Tools.notNull(c.getAnnotation(CodePrototype.class), ann -> {
            ClassOrInterfaceDeclaration declaration = new CompilationUnit().setPackageDeclaration(c.getPackageName()).addClass(c.getSimpleName()).setInterface(true);
            CompiledPrototypesHandler.handleAnnotations(c, declaration);
            CompiledPrototypesHandler.handleFields(c, declaration);
            Structures.PrototypeDataHandler props = CompiledPrototypesHandler.handleProperties(declaration, c, ann);
            Structures.Parsed.ParsedBuilder parsed = Structures.Parsed.builder().compiled((Class<?>)c).properties(props).parser(Helpers.lookup.getParser()).declaration(declaration);
            Structures.Parsed<ClassOrInterfaceDeclaration> prsd = parsed.build();
            Helpers.lookup.registerParsed(compiledPrototype, prsd);
            Generator.generateCodeForClass((CompilationUnit)declaration.findCompilationUnit().get(), prsd);
            result.set(true);
        }));
        return result.get();
    }

    private static Structures.PrototypeDataHandler handleProperties(ClassOrInterfaceDeclaration type, Class<?> cls, CodePrototype ann) {
        Holder<String> iName = Holder.of(Helpers.defaultInterfaceName(type));
        Object cName = Helpers.defaultClassName(type);
        Structures.PrototypeDataHandler.PrototypeDataHandlerBuilder builder = Structures.builder(cls.getSimpleName()).classPackage(Helpers.defaultClassPackage(type)).interfacePackage(Helpers.defaultInterfacePackage(type));
        if (StringUtils.isNotBlank((CharSequence)ann.name())) {
            String intf = ann.name().replace("Entity", "");
            builder.name(ann.name()).className(ann.name()).interfaceName(intf).longModifierName(intf + ".Modify");
        }
        if (StringUtils.isNotBlank((CharSequence)ann.interfaceName())) {
            iName.set(ann.interfaceName());
        }
        if (StringUtils.isNotBlank((CharSequence)ann.implementationPackage())) {
            builder.classPackage(ann.implementationPackage());
        }
        if (StringUtils.isNotBlank((CharSequence)ann.basePath())) {
            builder.basePath(ann.basePath());
        }
        builder.base(ann.base()).classGetters(ann.classGetters()).classSetters(ann.classSetters()).interfaceSetters(ann.interfaceSetters()).generateConstructor(ann.generateConstructor()).generateInterface(ann.generateInterface()).generateImplementation(ann.generateImplementation()).mixInClass(Objects.nonNull(ann.mixInClass()) && !Void.TYPE.equals(ann.mixInClass()) ? ann.mixInClass().getCanonicalName() : null).baseModifierClass(Objects.nonNull(ann.baseModifierClass()) && !Void.TYPE.equals(ann.baseModifierClass()) ? ann.baseModifierClass().getCanonicalName() : null).enrichers(CompiledPrototypesHandler.checkEnrichers(ann.enrichers())).inheritedEnrichers(CompiledPrototypesHandler.checkEnrichers(ann.inheritedEnrichers()));
        if (((String)cName).equals(iName.get())) {
            cName = iName.get() + "Impl";
        }
        builder.className((String)cName).interfaceName(iName.get()).longModifierName(iName.get() + ".Modify");
        Structures.PrototypeDataHandler result = builder.build();
        if (Objects.isNull(result.getEnrichers())) {
            result.setEnrichers(new ArrayList<PrototypeEnricher>());
        }
        if (Objects.isNull(result.getInheritedEnrichers())) {
            result.setInheritedEnrichers(new ArrayList<PrototypeEnricher>());
        }
        return result;
    }

    private static List<PrototypeEnricher> checkEnrichers(Class<? extends Enricher>[] enrichers) {
        ArrayList<PrototypeEnricher> list = new ArrayList<PrototypeEnricher>();
        Arrays.stream(enrichers).map(CodeFactory::create).filter(Objects::nonNull).filter(i -> PrototypeEnricher.class.isAssignableFrom(i.getClass())).forEach(e -> Tools.with((PrototypeEnricher)e, enricher -> {
            enricher.init(Helpers.lookup);
            list.add((PrototypeEnricher)enricher);
        }));
        return list;
    }

    private static void handleFields(Class<?> c, ClassOrInterfaceDeclaration declaration) {
        CompilationUnit unit = (CompilationUnit)declaration.findCompilationUnit().get();
        for (Method method : c.getDeclaredMethods()) {
            if (method.isDefault() || method.getParameterCount() != 0 || Void.class.equals(method.getReturnType())) continue;
            MethodDeclaration mtd = ((MethodDeclaration)declaration.addMethod(method.getName(), new Modifier.Keyword[0]).setType(method.getReturnType().getSimpleName())).setBody(null);
            if (!method.getReturnType().isPrimitive()) {
                unit.addImport(method.getReturnType().getCanonicalName());
            }
            for (Annotation ann : method.getAnnotations()) {
                Helpers.lookup.getParser().parseAnnotation(ann.toString()).getResult().ifPresent(annotation -> {
                    unit.addImport(ann.annotationType().getCanonicalName());
                    annotation.setName(ann.annotationType().getSimpleName());
                    mtd.addAnnotation(annotation);
                });
            }
        }
    }

    private static void handleAnnotations(Class<?> cls, ClassOrInterfaceDeclaration declaration) {
        for (Annotation ann : cls.getAnnotations()) {
            Helpers.lookup.getParser().parseAnnotation(ann.toString()).getResult().ifPresent(annotation -> {
                ((CompilationUnit)declaration.findCompilationUnit().get()).addImport(ann.annotationType().getCanonicalName());
                annotation.setName(ann.annotationType().getSimpleName());
                declaration.addAnnotation(annotation);
            });
        }
    }
}

