/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.validation.validator;

import java.math.BigDecimal;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.validation.ValidatorWithMessages;
import net.binis.codegen.validation.flow.impl.ValidationResultImpl;

public class RangeValidator
implements ValidatorWithMessages {
    private static final RangeValidator instance = new RangeValidator();

    public RangeValidator() {
        CodeFactory.registerType(RangeValidator.class, () -> instance, null);
    }

    public ValidatorWithMessages.ValidationResult validate(Object value, Object ... params) {
        if (value instanceof Number) {
            Object object;
            Number n = (Number)value;
            if (params.length == 2 && (object = params[0]) instanceof Number) {
                Number p1 = (Number)object;
                object = params[1];
                if (object instanceof Number) {
                    BigDecimal max;
                    BigDecimal min;
                    Number p2 = (Number)object;
                    BigDecimal val = BigDecimal.valueOf(n.doubleValue());
                    Object object2 = params[0];
                    if (object2 instanceof String) {
                        String p = (String)object2;
                        v0 = BigDecimal.valueOf(Double.parseDouble(p));
                    } else {
                        v0 = min = BigDecimal.valueOf(p1.doubleValue());
                    }
                    if (val.compareTo(min) < 0) {
                        return ValidationResultImpl.of(false, 0);
                    }
                    Object object3 = params[1];
                    if (object3 instanceof String) {
                        String p = (String)object3;
                        v1 = BigDecimal.valueOf(Double.parseDouble(p));
                    } else {
                        v1 = max = BigDecimal.valueOf(p2.doubleValue());
                    }
                    if (val.compareTo(max) > 0) {
                        return ValidationResultImpl.of(false, 1);
                    }
                }
            }
        }
        return ValidationResultImpl.of(true);
    }
}

