/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.validation.flow.impl.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.binis.codegen.exception.ValidationException;
import net.binis.codegen.exception.ValidationFormException;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.objects.Pair;
import net.binis.codegen.tools.Holder;
import net.binis.codegen.tools.Reflection;
import net.binis.codegen.validation.Executor;
import net.binis.codegen.validation.Sanitizer;
import net.binis.codegen.validation.Validatable;
import net.binis.codegen.validation.Validator;
import net.binis.codegen.validation.ValidatorWithMessages;
import net.binis.codegen.validation.flow.Validation;
import net.binis.codegen.validation.flow.ValidationStart;
import net.binis.codegen.validation.message.ValidationMessageBuilder;

public abstract class BaseValidationFlow
implements Validation,
ValidationStart {
    protected Object value;
    protected String field;
    protected List<Pair<String, String>> errors;
    protected Class<?> cls;

    public Validation validate(Class intf, String message, Object ... params) {
        this.process(intf, obj -> {
            if (!(obj instanceof Validator)) {
                throw new ValidationException(this.cls, intf.getSimpleName(), intf.getCanonicalName() + " is not validator!");
            }
            Validator validator = (Validator)obj;
            this.internalValidate(validator, params, this.field, this.value, message);
        });
        return this;
    }

    public Validation validateCollection(Class intf, String message, Object ... params) {
        this.process(intf, obj -> {
            if (!(obj instanceof Validator)) {
                throw new ValidationException(this.cls, intf.getSimpleName(), intf.getCanonicalName() + " is not validator!");
            }
            Validator validator = (Validator)obj;
            this.processCollection((k, v) -> this.internalValidate(validator, params, this.field + k, v, message));
        });
        return this;
    }

    public Validation validateWithMessages(Class intf, String[] messages, Object ... params) {
        this.process(intf, obj -> {
            if (!(obj instanceof ValidatorWithMessages)) {
                throw new ValidationException(this.cls, intf.getSimpleName(), intf.getCanonicalName() + " is not validator!");
            }
            ValidatorWithMessages validator = (ValidatorWithMessages)obj;
            this.internalValidateWithMessages(messages, validator, params, this.field, this.value);
        });
        return this;
    }

    public Validation validateWithMessagesCollection(Class intf, String[] messages, Object ... params) {
        this.process(intf, obj -> {
            if (!(obj instanceof ValidatorWithMessages)) {
                throw new ValidationException(this.cls, intf.getSimpleName(), intf.getCanonicalName() + " is not validator!");
            }
            ValidatorWithMessages validator = (ValidatorWithMessages)obj;
            this.processCollection((k, v) -> this.internalValidateWithMessages(messages, validator, params, this.field + k, v));
        });
        return this;
    }

    public Validation sanitize(Class intf, Object ... params) {
        this.process(intf, obj -> {
            if (!(obj instanceof Sanitizer)) {
                throw new ValidationException(this.cls, intf.getSimpleName(), intf.getCanonicalName() + " is not sanitizer!");
            }
            Sanitizer s = (Sanitizer)obj;
            this.value = s.sanitize(this.value, params);
        });
        return this;
    }

    public Validation sanitizeCollection(Class intf, Object ... params) {
        this.process(intf, obj -> {
            if (!(obj instanceof Sanitizer)) {
                throw new ValidationException(this.cls, intf.getSimpleName(), intf.getCanonicalName() + " is not sanitizer!");
            }
            Sanitizer s = (Sanitizer)obj;
            this.value = s.sanitize(this.value, params);
        });
        return this;
    }

    public Validation execute(Class intf, String message, Object ... params) {
        this.process(intf, obj -> {
            if (!(obj instanceof Executor)) {
                throw new ValidationException(this.cls, intf.getSimpleName(), intf.getCanonicalName() + " is not executor!");
            }
            Executor executor = (Executor)obj;
            this.internalExecute(executor, params, this.field, this.value, message);
        });
        return this;
    }

    public Validation executeCollection(Class intf, String message, Object ... params) {
        this.process(intf, obj -> {
            if (!(obj instanceof Executor)) {
                throw new ValidationException(this.cls, intf.getSimpleName(), intf.getCanonicalName() + " is not executor!");
            }
            Executor executor = (Executor)obj;
            this.processCollection((k, v) -> this.internalExecute(executor, params, this.field + k, v, message));
        });
        return this;
    }

    public Validation errors(List list) {
        this.errors = list;
        return this;
    }

    public Validation cls(Class cls) {
        this.cls = cls;
        return this;
    }

    @Override
    public <T> Validation<T> start(String field, T value) {
        this.field = field;
        this.value = value;
        return this;
    }

    public void perform(Consumer operation) {
        operation.accept(this.value);
    }

    @Override
    public void perform() {
    }

    public void form(Class cls, Consumer ... operations) {
        HashMap<String, List<String>> all = new HashMap<String, List<String>>();
        for (Consumer op : operations) {
            ArrayList<Pair> err;
            block5: {
                err = new ArrayList<Pair>();
                try {
                    op.accept(err);
                }
                catch (ValidationException ex) {
                    this.append(all, ex.getField(), ex.getMessage());
                }
                catch (Exception e2) {
                    if (!err.isEmpty()) break block5;
                    this.append(all, "<unknown>", e2.getMessage());
                }
            }
            err.forEach(e -> this.append(all, (String)e.getKey(), (String)e.getValue()));
        }
        if (!all.isEmpty()) {
            throw new ValidationFormException(cls, all);
        }
    }

    public Validation child() {
        if (Objects.nonNull(this.value)) {
            if (this.value instanceof Validatable) {
                this.validateValue(this.value, () -> this.field + ".");
            } else {
                Object object = this.value;
                if (object instanceof Collection) {
                    Collection c = (Collection)object;
                    Holder idx = Holder.of((Object)0);
                    for (Object o : c) {
                        this.validateValue(o, () -> this.field + "[" + idx.get() + "].");
                        idx.set((Object)((Integer)idx.get() + 1));
                    }
                } else {
                    object = this.value;
                    if (object instanceof Map) {
                        Map map = (Map)object;
                        map.forEach((key, val) -> {
                            if (key instanceof Validatable) {
                                this.validateValue(key, () -> this.field + ".key(" + key + ").");
                            }
                            if (val instanceof Validatable) {
                                this.validateValue(val, () -> this.field + "[\"" + key + "\"].");
                            }
                        });
                    }
                }
            }
        }
        return this;
    }

    protected void internalValidateWithMessages(String[] messages, ValidatorWithMessages validator, Object[] params, String title, Object value) {
        ValidatorWithMessages.ValidationResult result = validator.validate(value, params);
        if (!result.result()) {
            this.internalHandleValidationError(title, value, messages[result.error()], params);
        }
    }

    protected void internalValidate(Validator validator, Object[] params, String title, Object value, String message) {
        if (!validator.validate(value, params)) {
            this.internalHandleValidationError(title, value, message, params);
        }
    }

    protected void internalExecute(Executor executor, Object[] params, String title, Object value, String message) {
        if (!executor.execute(value, params)) {
            this.internalHandleValidationError(title, value, message, params);
        }
    }

    protected void processCollection(BiConsumer<String, Object> consumer) {
        Object object = this.value;
        if (object instanceof Collection) {
            Collection c = (Collection)object;
            int idx = 0;
            for (Object item : c) {
                consumer.accept("[" + idx + "]", item);
                ++idx;
            }
        } else {
            object = this.value;
            if (object instanceof Map) {
                Map map = (Map)object;
                throw new UnsupportedOperationException("Not implemented!");
            }
        }
    }

    protected void validateValue(Object value, Supplier<String> prefix) {
        try {
            ((Validatable)value).validate();
        }
        catch (ValidationFormException ex) {
            ex.getErrors().forEach((key, val) -> val.forEach(arg_0 -> this.lambda$validateValue$17((Supplier)prefix, key, arg_0)));
        }
    }

    public void process(Class intf, Consumer consumer) {
        Class entry = CodeFactory.lookup((Class)intf);
        if (Objects.isNull(entry) && !intf.isInterface()) {
            Reflection.instantiate((Class)intf, (Object[])new Object[0]);
            entry = CodeFactory.lookup((Class)intf);
        }
        if (!Objects.nonNull(entry)) {
            throw new ValidationException(this.cls, intf.getSimpleName(), intf.getCanonicalName() + " is not registered!");
        }
        consumer.accept(CodeFactory.create((Class)intf, (Object[])new Object[0]));
    }

    protected void append(Map<String, List<String>> all, String field, String message) {
        List list = all.computeIfAbsent(field, k -> new ArrayList());
        list.add(message);
    }

    protected void internalHandleValidationError(String field, Object value, String message, Object ... params) {
        this.handleValidationError(field, value, ValidationMessageBuilder.message(this.cls, field, value, params, message), params);
    }

    protected abstract void handleValidationError(String var1, Object var2, String var3, Object ... var4);

    private /* synthetic */ void lambda$validateValue$17(Supplier prefix, String key, String v) {
        this.errors.add((Pair<String, String>)Pair.of((Object)((String)prefix.get() + key), (Object)v));
    }
}

