/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.validation.executor;

import java.util.function.Consumer;
import net.binis.codegen.annotation.validation.AsCode;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.validation.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AsCode(value="((java.util.function.Consumer<{type}>) %s)")
public class LambdaExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(LambdaExecutor.class);
    private static final LambdaExecutor instance = new LambdaExecutor();

    public boolean execute(Object value, Object ... params) {
        return params.length > 0 && params[0] instanceof Consumer && this.executeInternal(value, params[0]);
    }

    private boolean executeInternal(Object value, Object consumer) {
        try {
            ((Consumer)consumer).accept(value);
            return true;
        }
        catch (Exception e) {
            log.warn("Execution failed!", (Throwable)e);
            return false;
        }
    }

    static {
        CodeFactory.registerType(LambdaExecutor.class, () -> instance, null);
    }
}

