/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.validation.message;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.factory.ObjectFactory;
import net.binis.codegen.tools.BaseStringInterpolator;

public class ValidationMessageBuilder
extends BaseStringInterpolator<Message> {
    protected static final Map<String, Message> cache = new ConcurrentHashMap<String, Message>();

    public ValidationMessageBuilder() {
        CodeFactory.forceRegisterType(ValidationMessageBuilder.class, (ObjectFactory)CodeFactory.lazy(ValidationMessageBuilder::new), null);
    }

    public static String message(Class cls, String field, Object value, Object[] params, String message) {
        if (Objects.nonNull(message)) {
            return cache.computeIfAbsent(message, k -> (Message)((ValidationMessageBuilder)((Object)((Object)CodeFactory.create(ValidationMessageBuilder.class, (Object[])new Object[0])))).buildExpression((String)k)).interpolate(cls, field, value, params);
        }
        return null;
    }

    protected Message buildConstantExpression(String exp) {
        return (cls, field, value, params) -> exp;
    }

    protected Message buildComplexExpression(List<Message> list) {
        return (cls, field, value, params) -> {
            StringBuilder result = new StringBuilder();
            for (Message exp : list) {
                result.append(exp.interpolate(cls, field, value, params));
            }
            return result.toString();
        };
    }

    protected Message buildParamExpression(String exp) {
        if ("field".equals(exp)) {
            return (cls, field, value, params) -> field;
        }
        if ("value".equals(exp)) {
            return (cls, field, value, params) -> Objects.isNull(value) ? "null" : value.toString();
        }
        if (exp.startsWith("param[") && exp.endsWith("]")) {
            try {
                int idx = Integer.parseInt(exp.substring(6, exp.length() - 1));
                String e = "{" + exp + "}";
                return (cls, field, value, params) -> idx > -1 && idx < params.length ? params[idx].toString() : e;
            }
            catch (Exception exception) {}
        } else {
            if ("class".equals(exp)) {
                return (cls, field, value, params) -> cls.getSimpleName();
            }
            if ("Class".equals(exp)) {
                return (cls, field, value, params) -> cls.getCanonicalName();
            }
        }
        return this.buildConstantExpression("{" + exp + "}");
    }

    public void cleanUp() {
        cache.clear();
    }

    @FunctionalInterface
    protected static interface Message {
        public String interpolate(Class var1, String var2, Object var3, Object[] var4);
    }
}

