/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.validation.validator;

import java.math.BigDecimal;
import java.util.Objects;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.validation.Validator;

public class RangeValidator
implements Validator {
    private static final RangeValidator instance = new RangeValidator();

    public RangeValidator() {
        CodeFactory.registerType(RangeValidator.class, () -> instance, null);
    }

    public boolean validate(Object value, Object ... params) {
        if (Objects.nonNull(value) && value instanceof Number && params.length > 1) {
            BigDecimal val = BigDecimal.valueOf(((Number)value).doubleValue());
            BigDecimal min = params[0] instanceof String ? BigDecimal.valueOf(Double.parseDouble((String)params[0])) : BigDecimal.valueOf(((Number)params[0]).doubleValue());
            BigDecimal max = params[1] instanceof String ? BigDecimal.valueOf(Double.parseDouble((String)params[1])) : BigDecimal.valueOf(((Number)params[1]).doubleValue());
            return val.compareTo(min) >= 0 && val.compareTo(max) <= 0;
        }
        return false;
    }
}

