/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.validation.validator;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.validation.Validator;

public class RegExValidator
implements Validator {
    private static final RegExValidator instance = new RegExValidator();
    private static final Map<String, Pattern> cache = new ConcurrentHashMap<String, Pattern>();

    public RegExValidator() {
        CodeFactory.registerType(RegExValidator.class, () -> instance, null);
    }

    public boolean validate(Object value, Object ... params) {
        if (Objects.nonNull(value)) {
            String regex = (String)params[0];
            Pattern pattern = cache.get(regex);
            if (Objects.isNull(pattern)) {
                pattern = Pattern.compile(regex);
                cache.put(regex, pattern);
            }
            return pattern.matcher(value.toString()).matches();
        }
        return true;
    }
}

