/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.spring.query.executor;

import java.lang.reflect.Executable;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Tuple;
import net.binis.codegen.creator.EntityCreator;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.spring.async.AsyncDispatcher;
import net.binis.codegen.spring.async.executor.CodeGenCompletableFuture;
import net.binis.codegen.spring.collection.ObservableList;
import net.binis.codegen.spring.modifier.BasePersistenceOperations;
import net.binis.codegen.spring.query.EmbeddedFields;
import net.binis.codegen.spring.query.MockedQuery;
import net.binis.codegen.spring.query.PreparedQuery;
import net.binis.codegen.spring.query.QueryAccessor;
import net.binis.codegen.spring.query.QueryCondition;
import net.binis.codegen.spring.query.QueryEmbed;
import net.binis.codegen.spring.query.QueryExecute;
import net.binis.codegen.spring.query.QueryFilter;
import net.binis.codegen.spring.query.QueryFunctions;
import net.binis.codegen.spring.query.QueryJoinAggregateOperation;
import net.binis.codegen.spring.query.QueryJoinCollectionFunctions;
import net.binis.codegen.spring.query.QueryOrderOperation;
import net.binis.codegen.spring.query.QueryParam;
import net.binis.codegen.spring.query.QueryProcessor;
import net.binis.codegen.spring.query.QuerySelectOperation;
import net.binis.codegen.spring.query.QuerySelf;
import net.binis.codegen.spring.query.QueryStarter;
import net.binis.codegen.spring.query.Queryable;
import net.binis.codegen.spring.query.UpdatableQuery;
import net.binis.codegen.spring.query.exception.QueryBuilderException;
import net.binis.codegen.spring.query.executor.Filter;
import net.binis.codegen.spring.query.executor.QueryOrderer;
import net.binis.codegen.spring.query.executor.TupleBackedProjection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public abstract class QueryExecutor<T, S, O, R, A, F, U>
extends BasePersistenceOperations<T, R>
implements QueryAccessor,
QuerySelectOperation<S, O, R>,
QueryOrderOperation<O, R>,
QueryFilter<R>,
QueryFunctions<T, QuerySelectOperation<S, O, R>>,
QueryJoinCollectionFunctions<T, QuerySelectOperation<S, O, R>, Object>,
QueryParam<R>,
QueryStarter<R, S, A, F, U>,
QueryCondition<S, O, R>,
QueryJoinAggregateOperation,
PreparedQuery<R>,
MockedQuery,
QuerySelf,
QueryEmbed,
UpdatableQuery {
    private static final Logger log = LoggerFactory.getLogger(QueryExecutor.class);
    private static final String DEFAULT_ALIAS = "u";
    private static final Map<Class<?>, Map<Class<?>, List<String>>> projections = new ConcurrentHashMap();
    public static final String CODE_EXECUTOR = "net.binis.codegen.spring.async.executor.CodeExecutor";
    protected QueryExecutor parent;
    protected int fieldsCount = 0;
    private List<Object> params = new ArrayList<Object>();
    private QueryProcessor.ResultType resultType = QueryProcessor.ResultType.UNKNOWN;
    private Supplier<QueryEmbed> queryName;
    private final UnaryOperator<QueryExecutor> fieldsExecutor;
    private Class<?> returnClass;
    private Class<?> aggregateClass;
    private Class<?> mapClass;
    private Pageable pageable;
    private boolean isNative;
    private boolean isCustom;
    private boolean isModifying;
    private boolean prepared;
    private boolean altered;
    private O order;
    private A aggregate;
    private String enveloped = null;
    private Runnable onEnvelop = null;
    private boolean brackets;
    private boolean condition;
    private int lastIdStartPos;
    private boolean skipNext;
    protected boolean fields;
    protected boolean update;
    private boolean distinct;
    private boolean isGroup;
    private boolean selectOrAggregate;
    private boolean projection;
    private Function<Object, Object> mocked;
    private final StringBuilder query = new StringBuilder();
    private StringBuilder countQuery;
    protected String alias = "u";
    private StringBuilder select;
    private StringBuilder where;
    private StringBuilder orderPart;
    private StringBuilder group;
    private StringBuilder join;
    private StringBuilder current;
    private int joins;
    private IntSupplier joinSupplier = () -> this.joins++;
    protected boolean joinFetch;
    protected Class joinClass;
    protected String joinField;
    protected StringBuilder lastIdentifier;
    private FlushModeType flushMode;
    private LockModeType lockMode;
    private Map<String, Object> hints;
    private List<Filter> filters;
    private Filter filter;
    private int bracketCount;
    private boolean pagedLoop;

    protected QueryExecutor(Class<?> returnClass, Supplier<QueryEmbed> queryName, UnaryOperator<QueryExecutor> fieldsExecutor) {
        super(null);
        this.returnClass = returnClass;
        this.queryName = queryName;
        this.fieldsExecutor = fieldsExecutor;
        this.mapClass = returnClass;
    }

    public QueryExecutor<T, S, O, R, A, F, U> identifier(String id, Object value) {
        boolean idStart;
        if (this.update && Objects.isNull(this.where)) {
            return this.identifierUpdate(id, value);
        }
        if (Objects.isNull(this.where)) {
            this.whereStart();
        }
        boolean bl = idStart = this.where.length() == 0 || this.where.charAt(this.where.length() - 1) != '.';
        if (idStart) {
            this.lastIdStartPos = this.where.length();
            this.lastIdentifier = new StringBuilder(id);
        }
        if (Objects.isNull(this.enveloped) && idStart) {
            this.where.append(" (").append(this.alias).append(".");
            this.brackets = true;
        }
        if (Objects.nonNull(this.mocked)) {
            value = this.mocked.apply(value);
        }
        if (Objects.isNull(value)) {
            this.where.append(id).append(" is null)");
        } else {
            this.params.add(value);
            this.where.append(id);
            if (Objects.nonNull(this.enveloped)) {
                if (Objects.nonNull(this.onEnvelop)) {
                    this.onEnvelop.run();
                    this.onEnvelop = null;
                } else {
                    this.where.append(this.enveloped);
                }
                this.enveloped = null;
            }
            this.where.append(" = ?").append(this.params.size()).append(")");
        }
        return this;
    }

    public QueryExecutor<T, S, O, R, A, F, U> identifierUpdate(String id, Object value) {
        if (Objects.isNull(this.select)) {
            this.select = new StringBuilder();
        }
        if (Objects.nonNull(this.mocked)) {
            value = this.mocked.apply(value);
        }
        this.params.add(value);
        this.select.append(this.alias).append('.').append(id).append(" = ?").append(this.params.size()).append(',');
        return this;
    }

    public QueryExecutor<T, S, O, R, A, F, U> identifier(String id) {
        if (this.$fields()) {
            StringBuilder _sel = this.$select();
            if (_sel.length() == 0 || _sel.charAt(_sel.length() - 1) != '.') {
                this.$select().append(this.alias).append(".");
            }
            _sel.append(id).append(" as ").append(id).append(",");
            this.$fieldsInc();
        } else if (this.$current() == this.$orderPart()) {
            this.orderIdentifier(id);
        } else {
            boolean idStart;
            StringBuilder _where = this.$where();
            if (Objects.isNull(_where)) {
                _where = this.whereStart();
            }
            boolean bl = idStart = _where.length() == 0 || _where.charAt(_where.length() - 1) != '.';
            if (idStart) {
                this.lastIdStartPos = _where.length();
                this.lastIdentifier = new StringBuilder(id);
            }
            if (Objects.isNull(this.enveloped) && idStart) {
                _where.append(" (").append(this.alias).append(".");
                this.brackets = true;
            }
            _where.append(id);
            if (Objects.nonNull(this.enveloped)) {
                if (Objects.nonNull(this.onEnvelop)) {
                    this.onEnvelop.run();
                    this.onEnvelop = null;
                } else {
                    _where.append(this.enveloped);
                }
                this.enveloped = null;
            }
        }
        return this.$retParent();
    }

    public void embedded(String id) {
        StringBuilder _current = this.$current();
        if (_current.length() > 0 && _current.charAt(_current.length() - 1) == '.') {
            _current.append(id).append(".");
            if (Objects.nonNull(this.lastIdentifier)) {
                this.lastIdentifier.append(".").append(id);
            }
        } else {
            if (_current == this.where) {
                this.lastIdStartPos = this.where.length();
                this.lastIdentifier = new StringBuilder(id);
            }
            if (Objects.isNull(this.enveloped)) {
                _current.append(" (");
                if (!this.alias.equals(id)) {
                    _current.append(this.alias).append(".");
                }
            }
            _current.append(id).append(".");
        }
    }

    protected void doNot() {
        this.$current().append(" not ");
    }

    protected void doLower() {
        this.envelop("lower");
    }

    protected void doUpper() {
        this.envelop("upper");
    }

    protected void doTrim() {
        this.envelop("trim");
    }

    protected void doSubstring(int start) {
        this.envelop("substr", start);
    }

    public void doSubstring(int start, int len) {
        this.envelop("substr", start, len);
    }

    protected void doReplace(String what, String withWhat) {
        this.envelop("replace", what, withWhat);
    }

    private void backInsert(String func) {
        int idx = this.$current().lastIndexOf("(");
        this.$current().insert(idx + 1, func);
    }

    private void backEnvelop(String func) {
        this.backInsert(func + "(");
        this.$current().append(")");
    }

    private void envelop(String func) {
        this.enveloped = ")";
        this.$current().append(" (").append(func).append("(");
    }

    private void envelop(String func, Object ... params) {
        if (params.length == 0) {
            this.envelop(func);
        } else {
            StringBuilder s = new StringBuilder();
            for (Object param : params) {
                this.params.add(param);
                s.append(", ?").append(this.params.size());
            }
            this.enveloped = s.append(")").toString();
            this.$current().append(" (").append(func).append("(");
        }
    }

    private void envelop(String func, Runnable onEnvelop, Object ... params) {
        this.onEnvelop = onEnvelop;
        this.envelop(func, params);
    }

    public void operation(String op, Object value) {
        if (Objects.nonNull(this.mocked)) {
            value = this.mocked.apply(value);
        }
        this.params.add(value);
        if (Objects.nonNull(this.enveloped)) {
            if (Objects.nonNull(this.onEnvelop)) {
                this.onEnvelop.run();
                this.onEnvelop = null;
            } else {
                this.$current().append(this.enveloped);
            }
            this.enveloped = null;
        }
        this.$current().append(' ').append(op).append(" ?").append(this.params.size()).append(")");
        this.brackets = false;
    }

    protected QueryExecutor<T, S, O, R, A, F, U> orderIdentifier(String id) {
        StringBuilder _order = this.$orderPart();
        if (Objects.isNull(_order)) {
            _order = this.orderStart();
        }
        if (_order.length() == 0 || _order.charAt(_order.length() - 1) != '.') {
            _order.append(' ').append(this.alias).append(".");
        }
        _order.append(id);
        return this;
    }

    protected Object aggregateIdentifier(String id) {
        this.resultType = this.fieldsCount == 0 ? QueryProcessor.ResultType.SINGLE : QueryProcessor.ResultType.TUPLE;
        this.$fieldsInc();
        this.select.append(this.alias).append(".").append(id).append(this.distinct || this.isGroup ? " " : ")").append(",");
        if (this.isGroup) {
            if (Objects.isNull(this.group)) {
                this.group = new StringBuilder();
            }
            this.group.append(this.alias).append(".").append(id).append(",");
        }
        this.distinct = false;
        this.isGroup = false;
        return this.aggregate;
    }

    protected O orderStart(O order) {
        this.order = order;
        if (Objects.isNull(this.orderPart)) {
            this.orderPart = new StringBuilder();
        }
        this.current = this.orderPart;
        return order;
    }

    protected A aggregateStart(A aggregate) {
        this.aggregate = aggregate;
        this.current = this.select = new StringBuilder();
        this.selectOrAggregate = true;
        return aggregate;
    }

    @Override
    public QuerySelectOperation<S, O, R> script(String script) {
        this.stripLast(" ");
        this.stripLast(".");
        this.$current().append(' ').append(script);
        if (this.brackets) {
            this.$current().append(")");
            this.brackets = false;
        }
        this.$current().append(' ');
        return this;
    }

    @Override
    public QuerySelectOperation<S, O, R> script(String script, Object ... params) {
        this.script(script);
        Collections.addAll(this.params, params);
        return this;
    }

    @Override
    public S and() {
        if (!this.skipNext) {
            this.$current().append(" and ");
            this.brackets = false;
        } else {
            this.skipNext = false;
        }
        return (S)this;
    }

    @Override
    public S or() {
        if (!this.skipNext) {
            this.$current().append(" or ");
            this.brackets = false;
        } else {
            this.skipNext = false;
        }
        return (S)this;
    }

    @Override
    public QuerySelectOperation<S, O, R> _close() {
        if (this.bracketCount <= 0) {
            throw new QueryBuilderException("Closing bracket without opening one!");
        }
        --this.bracketCount;
        this.$current().append(") ");
        return this;
    }

    public Object _open() {
        ++this.bracketCount;
        this.$current().append(" (");
        return this;
    }

    @Override
    public QueryCondition<S, O, R> _if(boolean condition, Consumer query) {
        this.condition = condition;
        if (condition) {
            query.accept(this);
        }
        return this;
    }

    @Override
    public S by() {
        this.whereStart();
        this.resultType = QueryProcessor.ResultType.SINGLE;
        return (S)this;
    }

    @Override
    public S by(Class<?> projection) {
        this.buildProjection(projection);
        return this.by();
    }

    @Override
    public F select() {
        this.current = this.select = new StringBuilder();
        this.fields = true;
        this.selectOrAggregate = true;
        return (F)this.fieldsExecutor.apply(this);
    }

    @Override
    public U update() {
        this.update = true;
        this.current = this.select = new StringBuilder();
        return (U)this;
    }

    @Override
    public <Q> Q by(boolean condition, Function<S, Q> query) {
        this.whereStart();
        if (condition) {
            query.apply(this);
        }
        return (Q)this;
    }

    @Override
    public <Q> Q by(boolean condition, Function<S, Q> query, Function<S, Q> elseQuery) {
        this.whereStart();
        if (condition) {
            query.apply(this);
        } else {
            elseQuery.apply(this);
        }
        return (Q)this;
    }

    @Override
    public long count() {
        this.resultType = QueryProcessor.ResultType.COUNT;
        this.mapClass = Long.class;
        this.select = Objects.isNull(this.select) ? new StringBuilder("count(*)") : (this.select.toString().equals("distinct " + this.alias + ",") ? new StringBuilder("count(distinct " + this.alias + ")") : new StringBuilder("count(*)"));
        this.altered = true;
        if (Objects.isNull(this.countQuery)) {
            this.countQuery = new StringBuilder();
            this.buildQuery(this.countQuery, true);
        }
        return (Long)this.execute();
    }

    @Override
    public Optional<R> top() {
        this.resultType = QueryProcessor.ResultType.SINGLE;
        this.pageable = PageRequest.of((int)0, (int)1);
        return this.get();
    }

    @Override
    public <V> Optional<V> top(Class<V> cls) {
        this.mapClass = cls;
        return this.top();
    }

    @Override
    public QueryParam<R> nativeQuery(String query) {
        this.isNative = true;
        return this.query(query);
    }

    @Override
    public QueryParam<R> query(String query) {
        this.isCustom = true;
        this.query.setLength(0);
        this.query.append(query);
        return this;
    }

    @Override
    public void transaction(Consumer<QueryStarter<R, S, A, F, U>> consumer) {
        this.with(manager -> consumer.accept(this));
    }

    @Override
    public CompletableFuture<Void> asyncC(Consumer<QueryStarter<R, S, A, F, U>> consumer) {
        return CodeGenCompletableFuture.runAsync(((AsyncDispatcher)CodeFactory.create(AsyncDispatcher.class, (String)CODE_EXECUTOR))._default(), () -> this.transaction(consumer));
    }

    @Override
    public <J> CompletableFuture<J> async(Function<QueryStarter<R, S, A, F, U>, J> func) {
        return CodeGenCompletableFuture.newSupplyAsync(((AsyncDispatcher)CodeFactory.create(AsyncDispatcher.class, (String)CODE_EXECUTOR))._default(), () -> this.withRes(manager -> func.apply(this)));
    }

    @Override
    public CompletableFuture<Void> asyncC(String flow, Consumer<QueryStarter<R, S, A, F, U>> consumer) {
        return CodeGenCompletableFuture.runAsync(((AsyncDispatcher)CodeFactory.create(AsyncDispatcher.class, (String)CODE_EXECUTOR)).flow(flow), () -> this.transaction(consumer));
    }

    @Override
    public <J> CompletableFuture<J> async(String flow, Function<QueryStarter<R, S, A, F, U>, J> func) {
        return CodeGenCompletableFuture.newSupplyAsync(((AsyncDispatcher)CodeFactory.create(AsyncDispatcher.class, (String)CODE_EXECUTOR)).flow(flow), () -> this.withRes(manager -> func.apply(this)));
    }

    @Override
    public CompletableFuture<Void> asyncC(long delay, TimeUnit unit, Consumer<QueryStarter<R, S, A, F, U>> consumer) {
        return CodeGenCompletableFuture.runAsync(CompletableFuture.delayedExecutor(delay, unit, ((AsyncDispatcher)CodeFactory.create(AsyncDispatcher.class, (String)CODE_EXECUTOR))._default()), () -> this.transaction(consumer));
    }

    @Override
    public <J> CompletableFuture<J> async(long delay, TimeUnit unit, Function<QueryStarter<R, S, A, F, U>, J> func) {
        return CodeGenCompletableFuture.newSupplyAsync(CompletableFuture.delayedExecutor(delay, unit, ((AsyncDispatcher)CodeFactory.create(AsyncDispatcher.class, (String)CODE_EXECUTOR))._default()), () -> this.withRes(manager -> func.apply(this)));
    }

    @Override
    public CompletableFuture<Void> asyncC(String flow, long delay, TimeUnit unit, Consumer<QueryStarter<R, S, A, F, U>> consumer) {
        return CodeGenCompletableFuture.runAsync(CompletableFuture.delayedExecutor(delay, unit, ((AsyncDispatcher)CodeFactory.create(AsyncDispatcher.class, (String)CODE_EXECUTOR)).flow(flow)), () -> this.transaction(consumer));
    }

    @Override
    public <J> CompletableFuture<J> async(String flow, long delay, TimeUnit unit, Function<QueryStarter<R, S, A, F, U>, J> func) {
        return CodeGenCompletableFuture.newSupplyAsync(CompletableFuture.delayedExecutor(delay, unit, ((AsyncDispatcher)CodeFactory.create(AsyncDispatcher.class, (String)CODE_EXECUTOR)).flow(flow)), () -> this.withRes(manager -> func.apply(this)));
    }

    @Override
    public CompletableFuture<Void> asyncC(Duration duration, Consumer<QueryStarter<R, S, A, F, U>> consumer) {
        return this.asyncC(duration.toMillis(), TimeUnit.MILLISECONDS, consumer);
    }

    @Override
    public <J> CompletableFuture<J> async(Duration duration, Function<QueryStarter<R, S, A, F, U>, J> func) {
        return this.async(duration.toMillis(), TimeUnit.MILLISECONDS, func);
    }

    @Override
    public CompletableFuture<Void> asyncC(String flow, Duration duration, Consumer<QueryStarter<R, S, A, F, U>> consumer) {
        return this.asyncC(flow, duration.toMillis(), TimeUnit.MILLISECONDS, consumer);
    }

    @Override
    public <J> CompletableFuture<J> async(String flow, Duration duration, Function<QueryStarter<R, S, A, F, U>, J> func) {
        return this.async(flow, duration.toMillis(), TimeUnit.MILLISECONDS, func);
    }

    @Override
    public List<R> top(long records) {
        this.pageable = PageRequest.of((int)0, (int)((int)records));
        return this.list();
    }

    @Override
    public <V> List<V> top(long records, Class<V> cls) {
        this.mapClass = cls;
        return this.top(records);
    }

    @Override
    public Page<R> page(Pageable pageable) {
        this.resultType = QueryProcessor.ResultType.PAGE;
        this.pageable = pageable;
        return this.checkPage((Page)this.execute());
    }

    @Override
    public <V> Page<V> page(Pageable pageable, Class<V> cls) {
        this.mapClass = cls;
        return this.page(pageable);
    }

    @Override
    public Page<R> page(long pageSize) {
        return this.page((Pageable)PageRequest.of((int)0, (int)((int)pageSize)));
    }

    @Override
    public <V> Page<V> page(long pageSize, Class<V> cls) {
        this.mapClass = cls;
        return this.page((Pageable)PageRequest.of((int)0, (int)((int)pageSize)));
    }

    @Override
    public void paginated(long pageSize, Consumer<R> consumer) {
        this.paginated((Pageable)PageRequest.of((int)0, (int)((int)pageSize)), consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paginated(Pageable pageable, Consumer<R> consumer) {
        this.pagedLoop = true;
        try {
            Page<R> page = this.page(pageable);
            while (!page.isEmpty()) {
                page.getContent().forEach(consumer);
                if (page.getContent().size() < pageable.getPageSize()) {
                    break;
                }
                page = this.page(page.nextPageable());
            }
        }
        finally {
            this.pagedLoop = false;
        }
    }

    @Override
    public <V> void paginated(long pageSize, Class<V> cls, Consumer<V> consumer) {
        this.paginated((Pageable)PageRequest.of((int)0, (int)((int)pageSize)), cls, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> void paginated(Pageable pageable, Class<V> cls, Consumer<V> consumer) {
        this.pagedLoop = true;
        try {
            Page<V> page = this.page(pageable, cls);
            while (!page.isEmpty()) {
                page.getContent().forEach(consumer);
                if (page.getContent().size() < pageable.getPageSize()) {
                    break;
                }
                page = this.page(page.nextPageable(), cls);
            }
        }
        finally {
            this.pagedLoop = false;
        }
    }

    @Override
    public void paged(long pageSize, Consumer<Page<R>> consumer) {
        this.paged((Pageable)PageRequest.of((int)0, (int)((int)pageSize)), consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paged(Pageable pageable, Consumer<Page<R>> consumer) {
        this.pagedLoop = true;
        try {
            Page<R> page = this.page(pageable);
            while (!page.isEmpty()) {
                consumer.accept(page);
                if (page.getContent().size() < pageable.getPageSize()) {
                    break;
                }
                page = this.page(page.nextPageable());
            }
        }
        finally {
            this.pagedLoop = false;
        }
    }

    @Override
    public <V> void paged(long pageSize, Class<V> cls, Consumer<Page<V>> consumer) {
        this.paged((Pageable)PageRequest.of((int)0, (int)((int)pageSize)), cls, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> void paged(Pageable pageable, Class<V> cls, Consumer<Page<V>> consumer) {
        this.pagedLoop = true;
        try {
            Page<V> page = this.page(pageable, cls);
            while (!page.isEmpty()) {
                consumer.accept(page);
                if (page.getContent().size() < pageable.getPageSize()) {
                    break;
                }
                page = this.page(page.nextPageable(), cls);
            }
        }
        finally {
            this.pagedLoop = false;
        }
    }

    @Override
    public Optional<Tuple> tuple() {
        return this.tuple(this.fieldsCount == 1 ? this.mapClass : Tuple.class);
    }

    @Override
    public Optional tuple(Class cls) {
        this.mapClass = cls;
        this.resultType = QueryProcessor.ResultType.TUPLE;
        return (Optional)this.execute();
    }

    @Override
    public List<Tuple> tuples() {
        return this.tuples(this.fieldsCount == 1 ? this.mapClass : Tuple.class);
    }

    @Override
    public PreparedQuery<R> prepare() {
        if (!this.prepared) {
            this.buildQuery(this.query, false);
            this.prepared = true;
        }
        return this;
    }

    @Override
    public List tuples(Class cls) {
        this.resultType = QueryProcessor.ResultType.TUPLES;
        this.mapClass = cls;
        return (List)this.execute();
    }

    @Override
    public QueryExecute<R> flush(FlushModeType type) {
        this.flushMode = type;
        return this;
    }

    @Override
    public QueryExecute<R> lock(LockModeType type) {
        this.lockMode = type;
        return this;
    }

    @Override
    public QueryExecute<R> hint(String hint, Object value) {
        if (Objects.isNull(this.hints)) {
            this.hints = new LinkedHashMap<String, Object>();
        }
        this.hints.put(hint, value);
        return this;
    }

    @Override
    public QueryFilter<R> filter(String name) {
        if (Objects.isNull(this.filters)) {
            this.filters = new ArrayList<Filter>();
        }
        this.filter = Filter.builder().name(name).values(new LinkedHashMap<String, Object>()).build();
        this.filters.add(this.filter);
        return this;
    }

    @Override
    public <V> QueryExecute<V> projection(Class<V> projection) {
        this.buildProjection(projection);
        this.mapClass = projection;
        return this;
    }

    @Override
    public boolean exists() {
        try {
            this.pageable = PageRequest.of((int)0, (int)1);
            return this.reference().isPresent();
        }
        catch (QueryBuilderException queryBuilderException) {
            return this.top().isPresent();
        }
    }

    @Override
    public void delete() {
        this.remove();
    }

    @Override
    public int remove() {
        this.isModifying = true;
        this.resultType = QueryProcessor.ResultType.REMOVE;
        Object result = this.execute();
        return Objects.nonNull(result) ? (Integer)result : 0;
    }

    @Override
    public String print() {
        StringBuilder result = new StringBuilder();
        this.buildQuery(result, false);
        return result.toString();
    }

    @Override
    public O desc() {
        StringBuilder _orderPart = this.$orderPart();
        this.stripLast(_orderPart, ".");
        this.stripLast(_orderPart, ",");
        _orderPart.append(" desc,");
        return this.$order();
    }

    @Override
    public O asc() {
        StringBuilder _orderPart = this.$orderPart();
        this.stripLast(_orderPart, ".");
        this.stripLast(_orderPart, ",");
        _orderPart.append(" asc,");
        return this.$order();
    }

    public Object execute() {
        StringBuilder actualQuery;
        if (this.resultType.equals((Object)QueryProcessor.ResultType.COUNT) && Objects.nonNull(this.countQuery)) {
            actualQuery = this.countQuery;
        } else {
            this.prepare();
            actualQuery = this.query;
        }
        if (Objects.nonNull(this.aggregateClass) && this.fieldsCount == 1) {
            this.returnClass = this.aggregateClass;
        } else if (this.selectOrAggregate) {
            this.returnClass = Tuple.class;
        }
        return this.withRes(manager -> QueryProcessor.process(this, manager, actualQuery.toString(), this.params, this.resultType, this.returnClass, this.mapClass, this.isNative, this.isModifying, this.pageable, this.flushMode, this.lockMode, this.hints, this.filters));
    }

    private void buildQuery(StringBuilder query, boolean countQuery) {
        if (this.bracketCount != 0) {
            throw new QueryBuilderException("Missing closing bracket!");
        }
        if (Objects.nonNull(this.select)) {
            this.stripLast(this.select, ",");
            if (this.update) {
                query.append("update ");
            } else {
                query.append("select ").append((CharSequence)this.select).append(' ');
            }
        } else if (Objects.nonNull(this.join)) {
            query.append("select ").append(this.alias).append(' ');
        }
        if (query.length() == 0 && this.resultType == QueryProcessor.ResultType.REMOVE) {
            query.append("delete ");
        }
        if (!this.isCustom) {
            if (!this.update) {
                query.append("from ");
            }
            query.append(this.returnClass.getName()).append(' ').append(this.alias).append(' ');
        }
        if (this.update) {
            query.append("set ").append((CharSequence)this.select).append(' ');
        }
        if (Objects.nonNull(this.join) && this.join.length() > 0) {
            query.append((CharSequence)this.join);
        }
        if (Objects.nonNull(this.where) && this.where.length() > 1) {
            this.stripLast(this.where, ",");
            query.append("where").append((CharSequence)this.where);
        }
        if (Objects.nonNull(this.group)) {
            this.stripLast(this.group, ",");
            query.append(" group by ").append((CharSequence)this.group).append(' ');
        }
        if (Objects.nonNull(this.orderPart) && !countQuery) {
            this.stripLast(this.orderPart, ",");
            query.append(" order by ").append((CharSequence)this.orderPart);
        }
    }

    @Override
    public <V> List<V> list(Class<V> cls) {
        this.mapClass = cls;
        return this.list();
    }

    @Override
    public R reference(Object id) {
        Class impl = CodeFactory.lookup(this.returnClass);
        if (Objects.isNull(impl)) {
            throw new QueryBuilderException("Can't find implementation class for " + this.returnClass.getCanonicalName() + "!");
        }
        return (R)this.withRes(manager -> manager.getReference(impl, id));
    }

    @Override
    public Optional<R> reference() {
        this.checkReferenceConditions();
        this.resultType = QueryProcessor.ResultType.REFERENCE;
        return (Optional)this.execute();
    }

    @Override
    public List<R> references() {
        this.checkReferenceConditions();
        this.resultType = QueryProcessor.ResultType.REFERENCES;
        return (List)this.execute();
    }

    @Override
    public R ensure() {
        return (R)this.get().orElseGet(() -> EntityCreator.create(this.returnClass));
    }

    @Override
    public Optional<R> get() {
        if (QueryProcessor.ResultType.UNKNOWN.equals((Object)this.resultType)) {
            this.resultType = QueryProcessor.ResultType.SINGLE;
        }
        if (Objects.nonNull(this.select) && !Number.class.isAssignableFrom(this.mapClass) && !Void.TYPE.equals(this.mapClass)) {
            this.resultType = QueryProcessor.ResultType.TUPLE;
        }
        return (Optional)this.execute();
    }

    @Override
    public <V> Optional<V> get(Class<V> cls) {
        this.mapClass = cls;
        return this.get();
    }

    @Override
    public List<R> list() {
        this.resultType = this.projection || this.selectOrAggregate && this.fieldsCount > 1 ? QueryProcessor.ResultType.TUPLES : QueryProcessor.ResultType.LIST;
        return (List)this.execute();
    }

    private void stripLast(String what) {
        this.stripLast(this.$current(), what);
    }

    private void stripLast(StringBuilder builder, String what) {
        int qlen = builder.length();
        int wlen = what.length();
        int idx = builder.lastIndexOf(what);
        if (idx > -1 && idx == qlen - wlen) {
            builder.setLength(qlen - wlen);
        }
    }

    private void stripToLast(StringBuilder builder, String what) {
        int idx = builder.lastIndexOf(what);
        if (idx > -1) {
            builder.setLength(idx + what.length());
        }
    }

    private void stripToLastInclude(StringBuilder builder, String what) {
        int idx = builder.lastIndexOf(what);
        if (idx > -1) {
            builder.setLength(idx);
        }
    }

    private void stripLastOperator() {
        this.where.setLength(this.lastIdStartPos);
        this.stripLast(" ");
        this.stripLast(" not");
        this.stripLast(" ");
        this.stripToLastInclude(this.where, " ");
        this.skipNext = this.where.length() == 0;
    }

    @Override
    public QueryFunctions<Long, QuerySelectOperation<S, O, R>> length() {
        this.backEnvelop("length");
        return this;
    }

    @Override
    public QuerySelectOperation<S, O, R> equal(T value) {
        this.stripLast(".");
        this.operation("=", value);
        return this;
    }

    @Override
    public QuerySelectOperation<S, O, R> equal(Queryable query) {
        this.subQueryOperation("=", query);
        return this;
    }

    @Override
    public QuerySelectOperation<S, O, R> between(T from, T to) {
        this.stripLast(".");
        this.operation("between", from);
        this.stripLast(")");
        this.operation("and", to);
        return this;
    }

    @Override
    public QuerySelectOperation<S, O, R> in(Collection<T> values) {
        if (Objects.isNull(values) || values.isEmpty()) {
            this.stripToLast(this.current, "(");
            this.$current().append("0 <> 0) ");
        } else {
            this.stripLast(".");
            this.operation("in", values);
        }
        return this;
    }

    @Override
    public QuerySelectOperation<S, O, R> in(T ... values) {
        return this.in(Arrays.asList(values));
    }

    @Override
    public QuerySelectOperation<S, O, R> in(Queryable query) {
        this.subQueryOperation("in", query);
        return this;
    }

    private void subQueryOperation(String op, Queryable query) {
        this.stripLast(".");
        if (Objects.nonNull(this.enveloped)) {
            if (Objects.nonNull(this.onEnvelop)) {
                this.onEnvelop.run();
                this.onEnvelop = null;
            } else {
                this.$current().append(this.enveloped);
            }
            this.enveloped = null;
        }
        QueryAccessor access = (QueryAccessor)((Object)query);
        String s = query.print();
        String newAlias = "s" + this.joins++;
        Object sub = s.replaceAll("\\(" + access.getAccessorAlias() + "\\.", "(" + newAlias + ".").replaceAll(" " + access.getAccessorAlias() + "\\.", " " + newAlias + ".").replaceAll(" " + access.getAccessorAlias() + " ", " " + newAlias + " ");
        for (int i = access.getParams().size(); i > 0; --i) {
            sub = ((String)sub).replaceAll("\\?" + i, "?" + (i + this.params.size()));
        }
        if (Objects.isNull(access.getAccessorSelect())) {
            sub = "select " + newAlias + " " + (String)sub;
        }
        this.params.addAll(access.getParams());
        this.$current().append(" ").append(op).append(" (").append((String)sub).append(")) ");
    }

    @Override
    public QuerySelectOperation<S, O, R> isNull() {
        this.stripLast(".");
        this.where.append(" is null)");
        return this;
    }

    @Override
    public QuerySelectOperation<S, O, R> isNotNull() {
        this.stripLast(".");
        this.where.append(" is not null)");
        return this;
    }

    @Override
    public QuerySelectOperation<S, O, R> like(String value) {
        this.stripLast(".");
        this.operation("like", value);
        return this;
    }

    @Override
    public QuerySelectOperation<S, O, R> starts(String value) {
        this.stripLast(".");
        this.operation("like", value + "%");
        return this;
    }

    @Override
    public QuerySelectOperation<S, O, R> ends(String value) {
        this.stripLast(".");
        this.operation("like", "%" + value);
        return this;
    }

    @Override
    public QuerySelectOperation<S, O, R> contains(String value) {
        this.stripLast(".");
        this.operation("like", "%" + value + "%");
        return this;
    }

    @Override
    public QuerySelectOperation<S, O, R> greater(T value) {
        this.stripLast(".");
        this.operation(">", value);
        return this;
    }

    @Override
    public QuerySelectOperation<S, O, R> greater(Queryable query) {
        this.subQueryOperation(">", query);
        return this;
    }

    @Override
    public QuerySelectOperation<S, O, R> greaterEqual(T value) {
        this.stripLast(".");
        this.operation(">=", value);
        return this;
    }

    @Override
    public QuerySelectOperation<S, O, R> greaterEqual(Queryable query) {
        this.subQueryOperation(">=", query);
        return this;
    }

    @Override
    public QuerySelectOperation<S, O, R> less(T value) {
        this.stripLast(".");
        this.operation("<", value);
        return this;
    }

    @Override
    public QuerySelectOperation<S, O, R> less(Queryable query) {
        this.subQueryOperation("<", query);
        return this;
    }

    @Override
    public QuerySelectOperation<S, O, R> lessEqual(T value) {
        this.stripLast(".");
        this.operation("<=", value);
        return this;
    }

    @Override
    public QuerySelectOperation<S, O, R> lessEqual(Queryable query) {
        this.subQueryOperation("<=", query);
        return this;
    }

    public QueryExecutor<T, S, O, R, A, F, U> params(Collection<Object> params) {
        this.params = new ArrayList<Object>(params);
        return this;
    }

    @Override
    public PreparedQuery<R> param(int idx, Object param) {
        this.params.set(idx, param);
        return this;
    }

    @Override
    public QueryParam<R> param(Object param) {
        this.params.add(param);
        return this;
    }

    @Override
    public int run() {
        this.isModifying = true;
        this.resultType = QueryProcessor.ResultType.EXECUTE;
        return (Integer)this.execute();
    }

    @Override
    public QuerySelectOperation<S, O, R> _else(Consumer<QuerySelectOperation<S, O, R>> query) {
        if (!this.condition) {
            query.accept(this);
        }
        return this;
    }

    @Override
    public QueryFilter<R> parameter(String name, Object value) {
        if (Objects.nonNull(this.filter)) {
            this.filter.getValues().put(name, value);
        }
        return this;
    }

    @Override
    public QueryFilter<R> disable() {
        if (Objects.nonNull(this.filter)) {
            this.filter.setDisabled(true);
        }
        return this;
    }

    @Override
    public Object sum() {
        this.aggregateFunction("sum");
        return this.aggregate;
    }

    @Override
    public Object min() {
        this.aggregateFunction("min");
        return this.aggregate;
    }

    @Override
    public Object max() {
        this.aggregateFunction("max");
        return this.aggregate;
    }

    @Override
    public Object avg() {
        this.aggregateFunction("avg");
        if (this.fieldsCount == 0) {
            this.mapClass = Double.class;
        }
        return this.aggregate;
    }

    @Override
    public Object cnt() {
        this.aggregateFunction("count");
        if (this.fieldsCount == 0) {
            this.aggregateClass = Long.class;
            this.mapClass = Long.class;
        }
        return this.aggregate;
    }

    @Override
    public Object distinct() {
        this.select.append("distinct ");
        this.distinct = true;
        this.mapClass = Tuple.class;
        return this.aggregate;
    }

    @Override
    public Object group() {
        this.isGroup = true;
        return this.aggregate;
    }

    public void aggregateFunction(String sum) {
        this.select.append(sum).append("(");
        if (this.fieldsCount == 0) {
            this.aggregateClass = Double.class;
            this.mapClass = Void.TYPE;
        }
    }

    @Override
    public QueryFunctions<Long, QuerySelectOperation<S, O, R>> size() {
        this.backEnvelop("size");
        return this;
    }

    public void collection(String id, Object value) {
        throw new IllegalCallerException();
    }

    @Override
    public QuerySelectOperation<S, O, R> contains(T value) {
        this.params.add(value);
        this.backInsert("?" + this.params.size() + " member of ");
        this.where.append(")");
        return this;
    }

    @Override
    public QuerySelectOperation<S, O, R> notContains(T value) {
        this.params.add(value);
        this.backInsert("?" + this.params.size() + " not member of ");
        this.where.append(")");
        return this;
    }

    @Override
    public QuerySelectOperation<S, O, R> containsAll(Collection<T> list) {
        this.handleContainsCollection(list, " member of ", " and ");
        return this;
    }

    @Override
    public QuerySelectOperation<S, O, R> containsOne(Collection<T> list) {
        this.handleContainsCollection(list, " member of ", " or ");
        return this;
    }

    @Override
    public QuerySelectOperation<S, O, R> containsNone(Collection<T> list) {
        this.handleContainsCollection(list, " not member of ", " and ");
        return this;
    }

    private void handleContainsCollection(Collection<T> list, String member, String oper) {
        int idx = this.$current().lastIndexOf("(");
        String col = this.$current().substring(idx + 1);
        this.$current().setLength(idx + 1);
        if (Objects.isNull(list) || list.isEmpty()) {
            this.$current().append("0 = 0");
        } else {
            for (T val : list) {
                this.params.add(val);
                this.$current().append("?").append(this.params.size()).append(member).append(col).append(oper);
            }
            this.stripLast(oper);
        }
        this.$current().append(")");
    }

    @Override
    public QuerySelectOperation<S, O, R> isEmpty() {
        this.where.append(" is empty)");
        return this;
    }

    @Override
    public QuerySelectOperation<S, O, R> isNotEmpty() {
        this.where.append(" is not empty)");
        return this;
    }

    public StringBuilder whereStart() {
        if (Objects.nonNull(this.parent)) {
            return this.$parent().whereStart();
        }
        this.fields = false;
        this.current = this.where = new StringBuilder();
        return this.where;
    }

    public StringBuilder orderStart() {
        if (Objects.nonNull(this.parent)) {
            return this.$parent().orderStart();
        }
        this.current = this.orderPart = new StringBuilder();
        return this.orderPart;
    }

    public Object joinStart(String id, Class cls) {
        this.joinClass = cls;
        this.joinField = id;
        this.identifier(id);
        return this;
    }

    public Object where() {
        if (Objects.nonNull(this.parent)) {
            QueryExecutor p = this.$parent();
            p.whereStart();
            return p;
        }
        this.whereStart();
        return this;
    }

    public QuerySelectOperation<S, O, R> join() {
        return this.internalFetch("join");
    }

    public QuerySelectOperation<S, O, R> leftJoin() {
        return this.internalFetch("left join");
    }

    @Override
    public QuerySelectOperation<S, O, R> join(Function<Object, Queryable> joinQuery) {
        this.handleJoin(joinQuery, "join");
        return this;
    }

    @Override
    public QuerySelectOperation<S, O, R> leftJoin(Function<Object, Queryable> joinQuery) {
        this.handleJoin(joinQuery, "left join");
        return this;
    }

    private void handleJoin(Function<Object, Queryable> joinQuery, String joinOperation) {
        this.stripToLastInclude(this.where, " (");
        if (Objects.nonNull(joinQuery)) {
            QueryOrderer query = (QueryOrderer)CodeFactory.create((Class)this.joinClass);
            if (Objects.nonNull(query)) {
                QueryOrderer access = query;
                access.setJoinSupplier(this.joinSupplier);
                access.setParams(this.params);
                QueryAccessor q = (QueryAccessor)((Object)joinQuery.apply(query));
                if (Objects.nonNull(q.getAccessorSelect()) && q.getAccessorSelect().length() > 0) {
                    if (Objects.isNull(this.select)) {
                        this.select = new StringBuilder();
                        if (DEFAULT_ALIAS.equals(this.alias)) {
                            this.select.append(this.alias).append(", ");
                        }
                    }
                    this.select.append((CharSequence)q.getAccessorSelect());
                    if (Objects.isNull(this.group)) {
                        this.group = new StringBuilder(DEFAULT_ALIAS);
                    }
                    if (Objects.nonNull(q.getAccessorOrder())) {
                        if (Objects.isNull(this.orderPart)) {
                            this.orderPart = new StringBuilder();
                        }
                        this.orderPart.append((CharSequence)this.buildAggregatedOrder(q.getAccessorOrder(), q.getAccessorSelect()));
                    }
                } else if (Objects.nonNull(q.getAccessorOrder())) {
                    throw new QueryBuilderException("Unable to perform order on unselected column.");
                }
                if (Objects.nonNull(q.getAccessorWhere())) {
                    if (Objects.isNull(this.where)) {
                        this.where = new StringBuilder(" ");
                    }
                    if (q.getAccessorWhere().length() == 0) {
                        this.stripLastOperator();
                    } else {
                        this.where.append((CharSequence)q.getAccessorWhere()).append(' ');
                    }
                }
                if (Objects.isNull(this.select)) {
                    this.select = new StringBuilder();
                    if (DEFAULT_ALIAS.equals(this.alias)) {
                        this.select.append("distinct ").append(this.alias).append(",");
                    }
                }
                if (Objects.isNull(this.join)) {
                    this.join = new StringBuilder();
                }
                this.join.append(joinOperation).append(' ').append(this.alias).append(".").append(this.joinField).append(' ').append(q.getAccessorAlias()).append(' ');
            } else {
                log.warn("Can't find creator for {}", (Object)this.joinClass.getCanonicalName());
            }
        } else {
            if (Objects.isNull(this.join)) {
                this.join = new StringBuilder();
            }
            this.join.append(joinOperation).append(' ').append(this.alias).append(".").append(this.joinField).append(" j").append(this.joinSupplier.getAsInt()).append(' ');
        }
    }

    @Override
    public QuerySelectOperation<S, O, R> joinFetch(Function<Object, Queryable> joinQuery) {
        this.handleJoin(joinQuery, "join fetch");
        this.joinFetch = true;
        return this;
    }

    @Override
    public QuerySelectOperation<S, O, R> joinFetch() {
        return this.internalFetch("join fetch");
    }

    @Override
    public QuerySelectOperation<S, O, R> leftJoinFetch() {
        return this.internalFetch("left join fetch");
    }

    private QuerySelectOperation<S, O, R> internalFetch(String clause) {
        this.joinField = this.lastIdentifier.toString();
        this.joinFetch = true;
        this.handleJoin(null, clause);
        if (Objects.nonNull(this.where) && this.where.length() > 0) {
            this.stripLast(this.where, " ");
            this.stripToLast(this.where, " ");
        }
        return this;
    }

    private StringBuilder buildAggregatedOrder(StringBuilder order, StringBuilder select) {
        StringBuilder result = new StringBuilder();
        String[] o = order.toString().strip().split(", ");
        String[] s = select.toString().split(",");
        for (String ord : o) {
            String[] or = ord.split("\\s|,");
            result.append(Arrays.stream(s).filter((? super T sel) -> sel.strip().endsWith(or[0] + ")")).findFirst().orElseThrow(() -> new QueryBuilderException("Unable to perform order on unselected column.")));
            if (or.length > 1) {
                result.append(' ').append(or[1]);
            }
            result.append(",");
        }
        return result;
    }

    @Override
    public String getAccessorAlias() {
        return this.alias;
    }

    @Override
    public StringBuilder getAccessorSelect() {
        return this.select;
    }

    @Override
    public StringBuilder getAccessorWhere() {
        return this.where;
    }

    @Override
    public StringBuilder getAccessorOrder() {
        return this.orderPart;
    }

    @Override
    public List<Object> getParams() {
        return this.params;
    }

    @Override
    public boolean isAltered() {
        return this.altered;
    }

    @Override
    public void setJoinSupplier(IntSupplier supplier) {
        this.alias = "j" + supplier.getAsInt();
        this.joinSupplier = supplier;
    }

    @Override
    public void setParams(List<Object> params) {
        this.params = params;
    }

    @Override
    public void setMocked(UnaryOperator<Object> onValue, UnaryOperator<Object> onParamAdd) {
        this.mocked = onValue;
        this.params = new ObservableList<Object>(this.params, onParamAdd);
    }

    protected Object getQueryName() {
        QueryEmbed result = this.queryName.get();
        result.setParent(this.alias, this);
        return result;
    }

    public Object lower() {
        this.doLower();
        return this.getQueryName();
    }

    public Object not() {
        this.doNot();
        return this.getQueryName();
    }

    public Object replace(String what, String withWhat) {
        this.doReplace(what, withWhat);
        return this.getQueryName();
    }

    public Object substring(int start) {
        this.doSubstring(start);
        return this.getQueryName();
    }

    public Object substring(int start, int len) {
        this.doSubstring(start, len);
        return this.getQueryName();
    }

    public Object trim() {
        this.doTrim();
        return this.getQueryName();
    }

    public Object upper() {
        this.doUpper();
        return this.getQueryName();
    }

    public Object _self() {
        StringBuilder _current = this.$current();
        if (Objects.isNull(this.parent)) {
            _current.append(this.alias);
            this.lastIdentifier = new StringBuilder("self");
        }
        this.stripLast(".");
        if (this.$fields()) {
            _current.append(" as ").append((CharSequence)this.lastIdentifier);
            this.$fieldsInc();
        }
        _current.append(",");
        A _aggregate = this.$aggregate();
        if (Objects.nonNull(_aggregate)) {
            return _aggregate;
        }
        return this.$retParent();
    }

    public void buildProjection(Class<?> projection) {
        List list = projections.computeIfAbsent(this.returnClass, c -> new HashMap()).computeIfAbsent(projection, c -> this.calcProjection(projection));
        this.projection = true;
        if (!list.isEmpty()) {
            this.selectOrAggregate = true;
            this.fieldsCount = list.size();
            this.select = new StringBuilder(list.stream().collect(Collectors.joining("," + this.alias + ".", this.alias + ".", "")));
        } else {
            log.warn("Projection ({}) did not produce any fields!", (Object)projection.getCanonicalName());
        }
    }

    protected List<String> calcProjection(Class<?> projection) {
        if (!projection.isInterface()) {
            throw new QueryBuilderException("Projection must be interface!");
        }
        List<String> list = this.calcProjection(projection, new ArrayList<String>());
        list.sort(Comparator.naturalOrder());
        this.mapProperties(this.returnClass, list);
        return list.stream().filter((? super T s) -> s.contains(" as ")).collect(Collectors.toList());
    }

    protected List<String> calcProjection(Class<?> projection, List<String> list) {
        for (Class<?> clazz : projection.getInterfaces()) {
            this.calcProjection(clazz, list);
        }
        for (GenericDeclaration genericDeclaration : projection.getDeclaredMethods()) {
            if (((Executable)genericDeclaration).getParameters().length != 0 || Void.TYPE.equals(((Method)genericDeclaration).getReturnType()) || !this.isGetter((Method)genericDeclaration) || list.contains(((Method)genericDeclaration).getName())) continue;
            list.add(((Method)genericDeclaration).getName());
        }
        return list;
    }

    private boolean isGetter(Method method) {
        String name = method.getName();
        return name.startsWith("get") && name.length() > 3 || name.startsWith("is") && name.length() > 2;
    }

    private void mapProperties(Class<?> cls, List<String> list) {
        for (Class<?> inh : cls.getInterfaces()) {
            this.mapProperties(inh, list);
        }
        for (int i = 0; i < list.size(); ++i) {
            String field = this.getFieldName(cls, list.get(i), "");
            if (!Objects.nonNull(field)) continue;
            list.set(i, field + " as " + TupleBackedProjection.getFieldName(list.get(i)));
        }
    }

    private String getFieldName(Class<?> cls, String methodName, String prefix) {
        if (!methodName.contains(" as ")) {
            Map<String, Method> methods = this.getMethods(cls);
            Method method = methods.get(methodName);
            if (Objects.nonNull(method)) {
                return prefix + TupleBackedProjection.getFieldName(methodName);
            }
            method = methods.values().stream().filter((? super T m) -> m.getParameters().length == 0 && methodName.startsWith(m.getName())).findFirst().orElse(null);
            if (Objects.nonNull(method)) {
                String name = methodName.charAt(0) == 'i' ? "is" + methodName.substring(method.getName().length()) : "get" + methodName.substring(method.getName().length());
                return this.getFieldName(method.getReturnType(), name, prefix + TupleBackedProjection.getNativeFieldName(method.getName()) + ".");
            }
        }
        return null;
    }

    private Map<String, Method> getMethods(Class<?> cls) {
        HashMap<String, Method> result = new HashMap<String, Method>();
        this.getMethods(cls, result);
        return result;
    }

    private void getMethods(Class<?> cls, Map<String, Method> map) {
        for (Class<?> clazz : cls.getInterfaces()) {
            this.getMethods(clazz, map);
        }
        for (GenericDeclaration genericDeclaration : cls.getDeclaredMethods()) {
            map.put(((Method)genericDeclaration).getName(), (Method)genericDeclaration);
        }
    }

    private void checkReferenceConditions() {
        if (this.isCustom || this.isNative) {
            throw new QueryBuilderException("Can't get reference for custom queries!");
        }
        if (Objects.nonNull(this.select)) {
            throw new QueryBuilderException("Can't use combination of select and reference!");
        }
        CodeFactory.IdDescription entry = CodeFactory.lookupId(this.returnClass);
        if (Objects.isNull(entry)) {
            throw new QueryBuilderException("Class " + this.returnClass.getCanonicalName() + " have no declared identifier column!");
        }
        this.select = new StringBuilder(entry.getName());
        this.mapClass = entry.getType();
        this.altered = true;
    }

    private StringBuilder $current() {
        if (Objects.nonNull(this.parent)) {
            return this.$parent().current;
        }
        return this.current;
    }

    private StringBuilder $orderPart() {
        if (Objects.nonNull(this.parent)) {
            return this.$parent().orderPart;
        }
        return this.orderPart;
    }

    private StringBuilder $select() {
        if (Objects.nonNull(this.parent)) {
            return this.$parent().select;
        }
        return this.select;
    }

    private StringBuilder $where() {
        if (Objects.nonNull(this.parent)) {
            return this.$parent().where;
        }
        return this.where;
    }

    private O $order() {
        if (Objects.nonNull(this.parent)) {
            return this.$parent().order;
        }
        return this.order;
    }

    private boolean $fields() {
        if (Objects.nonNull(this.parent)) {
            return this.$parent().fields;
        }
        return this.fields;
    }

    private String $alias() {
        if (Objects.nonNull(this.parent)) {
            return this.$parent().alias;
        }
        return this.alias;
    }

    private A $aggregate() {
        if (Objects.nonNull(this.parent)) {
            return this.$parent().aggregate;
        }
        return this.aggregate;
    }

    private void $fieldsInc() {
        if (Objects.nonNull(this.parent)) {
            ++this.$parent().fieldsCount;
        } else {
            ++this.fieldsCount;
        }
    }

    private QueryExecutor $parent() {
        QueryExecutor p = this.parent;
        while (Objects.nonNull(p.parent)) {
            p = p.parent;
        }
        return p;
    }

    private QueryExecutor $retParent() {
        if (Objects.isNull(this.parent)) {
            return this;
        }
        QueryExecutor last = this;
        QueryExecutor p = this;
        while (Objects.nonNull(p.parent)) {
            p = p.parent;
            if (!(p instanceof EmbeddedFields)) continue;
            last = p;
        }
        return last;
    }

    @Override
    public void setParent(String name, Object executor) {
        this.parent = (QueryExecutor)executor;
        StringBuilder _current = this.$current();
        if (_current.length() == 0 || _current.charAt(_current.length() - 1) != '.') {
            _current.append(this.$alias()).append('.');
        }
        _current.append(name).append(".");
        if (this.$fields()) {
            this.lastIdentifier = new StringBuilder(name);
        }
    }

    private Page checkPage(Page org) {
        if (this.pagedLoop) {
            return org;
        }
        return new PageImpl(org.getContent(), org.getPageable(), this.count());
    }
}

