/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.spring.query;

import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.Tuple;
import net.binis.codegen.exception.GenericCodeGenException;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.spring.query.exception.QueryBuilderException;
import net.binis.codegen.spring.query.executor.Filter;
import net.binis.codegen.spring.query.executor.QueryExecutor;
import net.binis.codegen.spring.query.executor.TupleBackedProjection;
import net.binis.codegen.tools.Reflection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;

public class QueryProcessor {
    private static final Logger log = LoggerFactory.getLogger(QueryProcessor.class);
    private static Processor processor = QueryProcessor.defaultProcessor();
    private static final ProjectionFactory factory = new SpelAwareProxyProjectionFactory();
    private static Class<?> sessionClass;
    private static Method enableFilter;
    private static Method disableFilter;
    private static Method parameter;
    private static boolean logParams;
    private static boolean logQuery;

    private QueryProcessor() {
    }

    private static void initFilters() {
        sessionClass = Reflection.loadClass((String)"org.hibernate.Session");
        if (Objects.nonNull(sessionClass)) {
            try {
                enableFilter = sessionClass.getDeclaredMethod("enableFilter", String.class);
                disableFilter = sessionClass.getDeclaredMethod("disableFilter", String.class);
                parameter = enableFilter.getReturnType().getDeclaredMethod("setParameter", String.class, Object.class);
            }
            catch (Exception e) {
                sessionClass = null;
                log.info("org.hibernate.Session is not present!. Filtering disabled!");
            }
        }
    }

    public static void logParams() {
        logParams = true;
    }

    public static void logQuery() {
        logQuery = true;
    }

    public static Processor defaultProcessor() {
        QueryProcessor.initFilters();
        return QueryProcessor::defaultProcess;
    }

    public static Processor nullProcessor() {
        return QueryProcessor::nullProcess;
    }

    public static Processor logProcessor() {
        Processor p = processor;
        return (executor, manager, query, params, resultType, returnClass, mapClass, isNative, modifying, pageable, flush, lock, hints, filters) -> {
            log.info(query);
            return p.process(executor, manager, query, params, resultType, returnClass, mapClass, isNative, modifying, pageable, flush, lock, hints, filters);
        };
    }

    public static Processor getProcessor() {
        return processor;
    }

    public static void setProcessor(Processor processor) {
        QueryProcessor.processor = processor;
    }

    public static <R> R process(QueryExecutor executor, EntityManager manager, String query, List<Object> params, ResultType resultType, Class<?> returnClass, Class<?> mapClass, boolean isNative, boolean modifying, Pageable pageable, FlushModeType flush, LockModeType lock, Map<String, Object> hints, List<Filter> filters) {
        return (R)processor.process(executor, manager, query, params, resultType, returnClass, mapClass, isNative, modifying, pageable, flush, lock, hints, filters);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static Object defaultProcess(QueryExecutor executor, EntityManager manager, String query, List<Object> params, ResultType resultType, Class<?> returnClass, Class<?> mapClass, boolean isNative, boolean modifying, Pageable pageable, FlushModeType flush, LockModeType lock, Map<String, Object> hints, List<Filter> filters) {
        try {
            original = returnClass;
            if (Objects.isNull(manager)) {
                throw new GenericCodeGenException("No entity manager present!\nUse '@ExtendWith(CodeGenExtension.class)' if you are in running unit test!");
            }
            if (BeanUtils.isSimpleValueType(mapClass)) {
                returnClass = mapClass;
            }
            v0 /* !! */  = map = ResultType.TUPLE.equals((Object)resultType) != false || ResultType.TUPLES.equals((Object)resultType) != false || Void.TYPE.equals(mapClass) != false || Void.class.equals(mapClass) != false ? Tuple.class : returnClass;
            q /* !! */  = ResultType.REMOVE.equals((Object)resultType) != false || ResultType.EXECUTE.equals((Object)resultType) != false ? (isNative != false ? manager.createNativeQuery(query) : manager.createQuery(query)) : (isNative != false ? manager.createNativeQuery(query, QueryProcessor.nativeQueryClass(map)) : manager.createQuery(query, map));
            for (i = 0; i < params.size(); ++i) {
                q /* !! */ .setParameter(i + 1, params.get(i));
            }
            if (Objects.nonNull(flush)) {
                q /* !! */ .setFlushMode(flush);
            }
            if (Objects.nonNull(lock)) {
                q /* !! */ .setLockMode(lock);
            }
            if (Objects.nonNull(hints)) {
                hints.forEach((BiConsumer<String, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, setHint(java.lang.String java.lang.Object ), (Ljava/lang/String;Ljava/lang/Object;)V)((Query)q /* !! */ ));
            }
            if (Objects.nonNull(pageable) && !ResultType.COUNT.equals((Object)resultType)) {
                q /* !! */ .setFirstResult((int)pageable.getOffset());
                if (pageable.getPageSize() > -1) {
                    q /* !! */ .setMaxResults(pageable.getPageSize());
                }
            }
            if (Objects.nonNull(QueryProcessor.sessionClass) && Objects.nonNull(filters)) {
                session = manager.unwrap(QueryProcessor.sessionClass);
                for (Optional<Object> filter : filters) {
                    try {
                        if (filter.isDisabled()) {
                            QueryProcessor.disableFilter.invoke(session, new Object[]{filter.getName()});
                            continue;
                        }
                        f = QueryProcessor.enableFilter.invoke(session, new Object[]{filter.getName()});
                        for (Map.Entry<String, Object> param : filter.getValues().entrySet()) {
                            QueryProcessor.parameter.invoke(f, new Object[]{param.getKey(), param.getValue()});
                        }
                    }
                    catch (Exception e) {
                        QueryProcessor.log.error("Unable to set query filter ({})!", (Object)filter.getName(), (Object)e);
                    }
                }
            }
            switch (1.$SwitchMap$net$binis$codegen$spring$query$QueryProcessor$ResultType[resultType.ordinal()]) {
                case 1: {
                    try {
                        result = q /* !! */ .getSingleResult();
                        if (!Void.TYPE.equals(mapClass)) ** GOTO lbl57
                        var18_24 /* !! */  = Optional.ofNullable(((Tuple)result).get(0));
                        return var18_24 /* !! */ ;
                    }
                    catch (NoResultException ex) {
                        var18_24 /* !! */  = Optional.empty();
                        return var18_24 /* !! */ ;
                    }
lbl57:
                    // 1 sources

                    if (Objects.nonNull(result) && mapClass.equals(result.getClass())) {
                        var18_24 /* !! */  = Optional.of(result);
                        return var18_24 /* !! */ ;
                    }
                    var18_24 /* !! */  = Optional.ofNullable(QueryProcessor.map(mapClass, result));
                    return var18_24 /* !! */ ;
                }
                case 2: {
                    ex = q /* !! */ .getSingleResult();
                    return ex;
                }
                case 3: {
                    rslt = q /* !! */ .getResultList();
                    if (rslt.isEmpty()) {
                        var18_24 /* !! */  = rslt;
                        return var18_24 /* !! */ ;
                    }
                    if (Void.TYPE.equals(mapClass)) {
                        var18_24 /* !! */  = rslt.stream().map((Function<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$defaultProcess$1(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)()).collect(Collectors.toList());
                        return var18_24 /* !! */ ;
                    }
                    if (mapClass.equals(rslt.getClass())) {
                        var18_24 /* !! */  = rslt;
                        return var18_24 /* !! */ ;
                    }
                    if (Tuple.class.equals(returnClass)) {
                        var18_24 /* !! */  = rslt.stream().map((Function<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$defaultProcess$2(java.lang.Class net.binis.codegen.spring.query.executor.QueryExecutor java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)(mapClass, (QueryExecutor)executor)).collect(Collectors.toList());
                        return var18_24 /* !! */ ;
                    }
                    if (mapClass.isInterface()) {
                        var18_24 /* !! */  = rslt.stream().map((Function<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$defaultProcess$3(java.lang.Class java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)(mapClass)).collect(Collectors.toList());
                        return var18_24 /* !! */ ;
                    }
                    var18_24 /* !! */  = rslt;
                    return var18_24 /* !! */ ;
                }
                case 4: {
                    if (Tuple.class.equals(returnClass)) {
                        if (!Tuple.class.equals(mapClass) && mapClass.isInterface()) {
                            var18_24 /* !! */  = new PageImpl(q /* !! */ .getResultList().stream().map((Function<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$defaultProcess$4(java.lang.Class net.binis.codegen.spring.query.executor.QueryExecutor java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)(mapClass, (QueryExecutor)executor)).collect(Collectors.toList()), pageable, 0x7FFFFFFFL);
                            return var18_24 /* !! */ ;
                        }
                        var18_24 /* !! */  = new PageImpl(q /* !! */ .getResultList(), pageable, 0x7FFFFFFFL);
                        return var18_24 /* !! */ ;
                    }
                    if (mapClass.isInterface() && !returnClass.isAssignableFrom(mapClass)) {
                        var18_24 /* !! */  = new PageImpl(q /* !! */ .getResultList().stream().map((Function<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$defaultProcess$5(java.lang.Class java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)(mapClass)).collect(Collectors.toList()), pageable, 0x7FFFFFFFL);
                        return var18_24 /* !! */ ;
                    }
                    var18_24 /* !! */  = new PageImpl(q /* !! */ .getResultList(), pageable, 0x7FFFFFFFL);
                    return var18_24 /* !! */ ;
                }
                case 5: 
                case 6: {
                    var18_24 /* !! */  = Integer.valueOf(q /* !! */ .executeUpdate());
                    return var18_24 /* !! */ ;
                }
                case 7: {
                    result = q /* !! */ .getSingleResult();
                    if (Objects.isNull(result)) {
                        filter = Optional.empty();
                        return filter;
                    }
                    if (!Tuple.class.equals(mapClass) && mapClass.isInterface()) {
                        filter = Optional.of(QueryProcessor.createProxy((Tuple)result, mapClass, executor));
                        return filter;
                    }
                    filter = Optional.of(result);
                    return filter;
                }
                case 8: {
                    if (!Tuple.class.equals(mapClass) && mapClass.isInterface()) {
                        ex = q /* !! */ .getResultList().stream().map((Function<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$defaultProcess$6(java.lang.Class net.binis.codegen.spring.query.executor.QueryExecutor java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)(mapClass, (QueryExecutor)executor)).collect(Collectors.toList());
                        return ex;
                    }
                    ex = q /* !! */ .getResultList();
                    return ex;
                }
                case 9: {
                    impl = CodeFactory.lookup(original);
                    if (Objects.isNull(impl)) {
                        throw new QueryBuilderException("Can't find implementation class for " + original.getCanonicalName() + "!");
                    }
                    try {
                        result = q /* !! */ .getSingleResult();
                        var20_28 = Optional.of(manager.getReference(impl, result));
                        return var20_28;
                    }
                    catch (NoResultException ex) {
                        var20_28 = Optional.empty();
                        if (!QueryProcessor.logQuery) ** GOTO lbl128
                        QueryProcessor.log.info(QueryProcessor.logQuery(query, params));
lbl128:
                        // 2 sources

                        return var20_28;
                    }
                }
                case 10: {
                    imp = CodeFactory.lookup(original);
                    if (Objects.isNull(imp)) {
                        throw new QueryBuilderException("Can't find implementation class for " + original.getCanonicalName() + "!");
                    }
                    var20_28 = q /* !! */ .getResultList().stream().map((Function<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$defaultProcess$7(javax.persistence.EntityManager java.lang.Class java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((EntityManager)manager, (Class)imp)).collect(Collectors.toList());
                    return var20_28;
                }
            }
            throw new GenericCodeGenException("Unknown query return type!");
            {
                catch (Exception e) {
                    QueryProcessor.log.error("Failed to execute query\n{}", (Object)QueryProcessor.logQuery(query, params), (Object)e);
                    throw e;
                }
                catch (Throwable var23_32) {
                    throw var23_32;
                }
            }
        }
        finally {
            if (QueryProcessor.logQuery) {
                QueryProcessor.log.info(QueryProcessor.logQuery(query, params));
            }
        }
    }

    private static Class<?> nativeQueryClass(Class<?> map) {
        Class impl;
        Class result = map;
        if (map.isInterface() && Objects.nonNull(impl = CodeFactory.lookup(map))) {
            result = impl;
        }
        return result;
    }

    private static Object map(Class<?> mapClass, Object result) {
        if (Objects.nonNull(result) && mapClass.isInterface()) {
            return factory.createProjection(mapClass, result);
        }
        return result;
    }

    private static Object nullProcess(QueryExecutor executor, EntityManager manager, String query, List<Object> params, ResultType resultType, Class<?> returnClass, Class<?> mapClass, boolean isNative, boolean modifying, Pageable pageable, FlushModeType flush, LockModeType lock, Map<String, Object> hints, List<Filter> filters) {
        return null;
    }

    private static Object createProxy(Tuple tuple, Class<?> mapClass, QueryExecutor<?, ?, ?, ?, ?, ?, ?> executor) {
        List elements = tuple.getElements();
        if (elements.size() == 1 && Objects.nonNull(tuple.get(0)) && mapClass.isInstance(tuple.get(0))) {
            return tuple.get(0);
        }
        return Proxy.newProxyInstance(mapClass.getClassLoader(), new Class[]{mapClass}, (InvocationHandler)new TupleBackedProjection(tuple, executor));
    }

    private static String logQuery(String query, List<Object> params) {
        if (logParams && Objects.nonNull(params)) {
            return "Query '" + query + "' with params [" + params.stream().map(Objects::toString).map(s -> "(" + s + ")").collect(Collectors.joining(", ")) + "]";
        }
        return "Query '" + query + "'";
    }

    private static /* synthetic */ Object lambda$defaultProcess$7(EntityManager manager, Class imp, Object r) {
        return manager.getReference(imp, r);
    }

    private static /* synthetic */ Object lambda$defaultProcess$6(Class mapClass, QueryExecutor executor, Object r) {
        return QueryProcessor.createProxy((Tuple)r, mapClass, executor);
    }

    private static /* synthetic */ Object lambda$defaultProcess$5(Class mapClass, Object r) {
        return QueryProcessor.map(mapClass, r);
    }

    private static /* synthetic */ Object lambda$defaultProcess$4(Class mapClass, QueryExecutor executor, Object r) {
        return QueryProcessor.createProxy((Tuple)r, mapClass, executor);
    }

    private static /* synthetic */ Object lambda$defaultProcess$3(Class mapClass, Object r) {
        return QueryProcessor.map(mapClass, r);
    }

    private static /* synthetic */ Object lambda$defaultProcess$2(Class mapClass, QueryExecutor executor, Object r) {
        return QueryProcessor.createProxy((Tuple)r, mapClass, executor);
    }

    private static /* synthetic */ Object lambda$defaultProcess$1(Object r) {
        return ((Tuple)r).get(0);
    }

    static {
        logParams = false;
        logQuery = false;
    }

    @FunctionalInterface
    public static interface Processor {
        public Object process(QueryExecutor var1, EntityManager var2, String var3, List<Object> var4, ResultType var5, Class<?> var6, Class<?> var7, boolean var8, boolean var9, Pageable var10, FlushModeType var11, LockModeType var12, Map<String, Object> var13, List<Filter> var14);
    }

    public static enum ResultType {
        UNKNOWN,
        SINGLE,
        LIST,
        PAGE,
        COUNT,
        REMOVE,
        EXECUTE,
        TUPLE,
        TUPLES,
        REFERENCE,
        REFERENCES;

    }
}

