/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.spring.modifier;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import net.binis.codegen.exception.GenericCodeGenException;
import net.binis.codegen.modifier.impl.BaseModifierImpl;
import net.binis.codegen.spring.component.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class BasePersistenceOperations<T, R>
extends BaseModifierImpl<T, R> {
    private static final Logger log = LoggerFactory.getLogger(BasePersistenceOperations.class);
    public static final String NO_TRANSACTION_DEBUG_WARNING = "Attempt to do action outside of open transaction!";
    private static EntityManagerFactory factory;
    private static TransactionTemplate template;
    private static Function<EntityManagerFactory, EntityManager> entityManagerProvider;

    protected BasePersistenceOperations(R parent) {
        super(parent);
    }

    public static void setEntityManagerProvider(Function<EntityManagerFactory, EntityManager> provider) {
        entityManagerProvider = provider;
    }

    public static EntityManager getEntityManager() {
        return entityManagerProvider.apply(factory);
    }

    private static void init() {
        if (Objects.isNull(factory)) {
            ApplicationContext context = ApplicationContextProvider.getApplicationContext();
            if (Objects.isNull(context)) {
                throw new GenericCodeGenException("Not in spring context!\nUse '@ExtendWith(CodeGenExtension.class)' if you are in running unit test!");
            }
            JpaTransactionManager tm = (JpaTransactionManager)context.getBean(JpaTransactionManager.class);
            factory = tm.getEntityManagerFactory();
            template = (TransactionTemplate)context.getBean(TransactionTemplate.class);
        }
    }

    protected void with(Consumer<EntityManager> func) {
        BasePersistenceOperations.init();
        EntityManager em = BasePersistenceOperations.getEntityManager();
        if (Objects.isNull(em) || !TransactionSynchronizationManager.isActualTransactionActive()) {
            log.debug(NO_TRANSACTION_DEBUG_WARNING);
            template.execute(s -> {
                this.checkMerge(m -> {
                    func.accept((EntityManager)m);
                    return null;
                });
                return null;
            });
        } else {
            func.accept(em);
        }
    }

    protected R withRes(Function<EntityManager, R> func) {
        BasePersistenceOperations.init();
        EntityManager em = BasePersistenceOperations.getEntityManager();
        if (Objects.isNull(em) || !TransactionSynchronizationManager.isActualTransactionActive()) {
            log.debug(NO_TRANSACTION_DEBUG_WARNING);
            return (R)template.execute(s -> this.checkMerge(func));
        }
        return func.apply(em);
    }

    protected R checkMerge(Function<EntityManager, R> func) {
        EntityManager manager = BasePersistenceOperations.getEntityManager();
        if (Objects.nonNull(this.parent)) {
            this.parent = manager.merge(this.parent);
        }
        return func.apply(manager);
    }

    protected R withNewTransactionRes(Function<EntityManager, R> func) {
        BasePersistenceOperations.init();
        EntityManager em = BasePersistenceOperations.getEntityManager();
        if (Objects.isNull(em) || !TransactionSynchronizationManager.isActualTransactionActive()) {
            log.debug(NO_TRANSACTION_DEBUG_WARNING);
            return (R)template.execute(s -> this.checkMerge(func));
        }
        TransactionTemplate transactionTemplate = new TransactionTemplate(template.getTransactionManager());
        transactionTemplate.setPropagationBehavior(3);
        return (R)transactionTemplate.execute(s -> func.apply(em));
    }

    public static Function<EntityManagerFactory, EntityManager> defaultEntityManagerProvider() {
        return EntityManagerFactoryUtils::getTransactionalEntityManager;
    }

    static {
        entityManagerProvider = BasePersistenceOperations.defaultEntityManagerProvider();
    }
}

