/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.spring.async.executor;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.binis.codegen.spring.async.AsyncDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeExecutor {
    private static final Logger log = LoggerFactory.getLogger(CodeExecutor.class);
    public static final String DEFAULT = "default";
    private static final Dispatcher dispatcher = new Dispatcher();
    private static final RejectedExecutionHandler defaultHandler = new ThreadPoolExecutor.AbortPolicy();

    private CodeExecutor() {
    }

    public static void registerDefaultExecutor(Executor executor) {
        CodeExecutor.registerExecutor(DEFAULT, executor);
    }

    public static void registerExecutor(String flow, Executor executor) {
        dispatcher.register(flow, executor);
    }

    public static AsyncDispatcher defaultDispatcher() {
        return dispatcher;
    }

    public static Executor defaultExecutor(String flow) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, Runtime.getRuntime().availableProcessors(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DefaultThreadFactory(flow), defaultHandler);
        return task -> executor.execute(() -> {
            try {
                task.run();
            }
            catch (Exception e) {
                log.warn("Failed to execute task!", (Throwable)e);
            }
        });
    }

    public static Executor silentExecutor(String flow) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, Runtime.getRuntime().availableProcessors(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DefaultThreadFactory(flow), defaultHandler);
        return task -> executor.execute(() -> {
            try {
                task.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public static Executor syncExecutor() {
        return Runnable::run;
    }

    public static Executor syncSilentExecutor() {
        return task -> {
            try {
                task.run();
            }
            catch (Exception e) {
                log.warn("Failed to execute task!", (Throwable)e);
            }
        };
    }

    static {
        CodeExecutor.registerDefaultExecutor(CodeExecutor.defaultExecutor(DEFAULT));
    }

    private static final class Dispatcher
    implements AsyncDispatcher {
        private final Map<String, Executor> flows = new ConcurrentHashMap<String, Executor>();

        private Dispatcher() {
        }

        @Override
        public Executor flow(String flow) {
            return this.flows.computeIfAbsent(flow, CodeExecutor::defaultExecutor);
        }

        @Override
        public Executor _default() {
            return this.flow(CodeExecutor.DEFAULT);
        }

        private void register(String flow, Executor executor) {
            this.flows.put(flow, executor);
        }
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        DefaultThreadFactory(String flow) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = flow + "-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

