/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.spring.async.executor;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.binis.codegen.spring.async.AsyncExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeExecutor {
    private static final Logger log = LoggerFactory.getLogger(CodeExecutor.class);

    private CodeExecutor() {
    }

    public static AsyncExecutor defaultExecutor() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(0, Runtime.getRuntime().availableProcessors(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        return task -> executor.execute(() -> {
            try {
                task.run();
            }
            catch (Exception e) {
                log.warn("Failed to execute task!", (Throwable)e);
            }
        });
    }

    public static AsyncExecutor silentExecutor() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(0, Runtime.getRuntime().availableProcessors(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        return task -> executor.execute(() -> {
            try {
                task.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public static AsyncExecutor syncExecutor() {
        return Runnable::run;
    }

    public static AsyncExecutor syncSilentExecutor() {
        return task -> {
            try {
                task.run();
            }
            catch (Exception e) {
                log.warn("Failed to execute task!", (Throwable)e);
            }
        };
    }
}

