/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.spring.query;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.Tuple;
import net.binis.codegen.exception.GenericCodeGenException;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.spring.query.executor.Filter;
import net.binis.codegen.spring.query.executor.QueryExecutor;
import net.binis.codegen.spring.query.executor.TupleBackedProjection;
import net.binis.codegen.tools.Reflection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;

public class QueryProcessor {
    private static final Logger log = LoggerFactory.getLogger(QueryProcessor.class);
    private static Processor processor = QueryProcessor.defaultProcessor();
    private static final ProjectionFactory factory = new SpelAwareProxyProjectionFactory();
    private static Class<?> sessionClass;
    private static Method enableFilter;
    private static Method disableFilter;
    private static Method parameter;

    private QueryProcessor() {
    }

    private static void initFilters() {
        sessionClass = Reflection.loadClass((String)"org.hibernate.Session");
        if (Objects.nonNull(sessionClass)) {
            try {
                enableFilter = sessionClass.getDeclaredMethod("enableFilter", String.class);
                disableFilter = sessionClass.getDeclaredMethod("disableFilter", String.class);
                parameter = enableFilter.getReturnType().getDeclaredMethod("setParameter", String.class, Object.class);
            }
            catch (Exception e) {
                sessionClass = null;
                log.info("org.hibernate.Session is not present!. Filtering disabled!");
            }
        }
    }

    public static Processor defaultProcessor() {
        QueryProcessor.initFilters();
        return QueryProcessor::defaultProcess;
    }

    public static Processor nullProcessor() {
        return QueryProcessor::nullProcess;
    }

    public static Processor logProcessor() {
        Processor p = processor;
        return (executor, manager, query, params, resultType, returnClass, mapClass, isNative, modifying, pageable, flush, lock, hints, filters) -> {
            log.info(query);
            return p.process(executor, manager, query, params, resultType, returnClass, mapClass, isNative, modifying, pageable, flush, lock, hints, filters);
        };
    }

    public static Processor getProcessor() {
        return processor;
    }

    public static void setProcessor(Processor processor) {
        QueryProcessor.processor = processor;
    }

    public static <R> R process(QueryExecutor executor, EntityManager manager, String query, List<Object> params, ResultType resultType, Class<?> returnClass, Class<?> mapClass, boolean isNative, boolean modifying, Pageable pageable, FlushModeType flush, LockModeType lock, Map<String, Object> hints, List<Filter> filters) {
        return (R)processor.process(executor, manager, query, params, resultType, returnClass, mapClass, isNative, modifying, pageable, flush, lock, hints, filters);
    }

    private static Object defaultProcess(QueryExecutor executor, EntityManager manager, String query, List<Object> params, ResultType resultType, Class<?> returnClass, Class<?> mapClass, boolean isNative, boolean modifying, Pageable pageable, FlushModeType flush, LockModeType lock, Map<String, Object> hints, List<Filter> filters) {
        Class<Tuple> map;
        if (Objects.isNull(manager)) {
            throw new GenericCodeGenException("No entity manager present!\nUse '@ExtendWith(CodeGenExtension.class)' if you are in running unit test!");
        }
        if (BeanUtils.isSimpleValueType(mapClass)) {
            returnClass = mapClass;
        }
        Class clazz = map = ResultType.TUPLE.equals((Object)resultType) || ResultType.TUPLES.equals((Object)resultType) || Void.TYPE.equals(mapClass) || Void.class.equals(mapClass) ? Tuple.class : returnClass;
        Object q = ResultType.REMOVE.equals((Object)resultType) || ResultType.EXECUTE.equals((Object)resultType) ? (isNative ? manager.createNativeQuery(query) : manager.createQuery(query)) : (isNative ? manager.createNativeQuery(query, QueryProcessor.nativeQueryClass(map)) : manager.createQuery(query, map));
        for (int i = 0; i < params.size(); ++i) {
            q.setParameter(i + 1, params.get(i));
        }
        if (Objects.nonNull(flush)) {
            q.setFlushMode(flush);
        }
        if (Objects.nonNull(lock)) {
            q.setLockMode(lock);
        }
        if (Objects.nonNull(hints)) {
            hints.forEach((arg_0, arg_1) -> ((Query)q).setHint(arg_0, arg_1));
        }
        if (Objects.nonNull(pageable)) {
            q.setFirstResult((int)pageable.getOffset());
            if (pageable.getPageSize() > -1) {
                q.setMaxResults(pageable.getPageSize());
            }
        }
        if (Objects.nonNull(sessionClass) && Objects.nonNull(filters)) {
            Object session = manager.unwrap(sessionClass);
            for (Filter filter : filters) {
                try {
                    if (filter.isDisabled()) {
                        disableFilter.invoke(session, filter.getName());
                        continue;
                    }
                    Object f = enableFilter.invoke(session, filter.getName());
                    for (Map.Entry<String, Object> param : filter.getValues().entrySet()) {
                        parameter.invoke(f, param.getKey(), param.getValue());
                    }
                }
                catch (Exception e) {
                    log.error("Unable to set query filter ({})!", (Object)filter.getName(), (Object)e);
                }
            }
        }
        switch (resultType) {
            case SINGLE: {
                try {
                    Object result = q.getSingleResult();
                    if (Void.TYPE.equals(mapClass)) {
                        return Optional.ofNullable(((Tuple)result).get(0));
                    }
                    return Optional.ofNullable(QueryProcessor.map(mapClass, result));
                }
                catch (NoResultException ex) {
                    return Optional.empty();
                }
            }
            case COUNT: {
                return q.getSingleResult();
            }
            case LIST: {
                if (Objects.nonNull(mapClass) && mapClass.isInterface()) {
                    return q.getResultList().stream().map(r -> QueryProcessor.map(mapClass, r)).collect(Collectors.toList());
                }
                return q.getResultList();
            }
            case PAGE: {
                if (Tuple.class.equals(returnClass)) {
                    if (Objects.nonNull(mapClass) && !Tuple.class.equals(mapClass) && mapClass.isInterface()) {
                        return new PageImpl(q.getResultList().stream().map(r -> QueryProcessor.createProxy((Tuple)r, mapClass, executor)).collect(Collectors.toList()), pageable, Integer.MAX_VALUE);
                    }
                    return new PageImpl(q.getResultList(), pageable, Integer.MAX_VALUE);
                }
                if (Objects.nonNull(mapClass) && mapClass.isInterface() && !returnClass.isAssignableFrom(mapClass)) {
                    return new PageImpl(q.getResultList().stream().map(r -> QueryProcessor.map(mapClass, r)).collect(Collectors.toList()), pageable, Integer.MAX_VALUE);
                }
                return new PageImpl(q.getResultList(), pageable, Integer.MAX_VALUE);
            }
            case REMOVE: 
            case EXECUTE: {
                return q.executeUpdate();
            }
            case TUPLE: {
                try {
                    Object result = q.getSingleResult();
                    if (Objects.isNull(result)) {
                        return Optional.empty();
                    }
                    if (Objects.nonNull(mapClass) && !Tuple.class.equals(mapClass) && mapClass.isInterface()) {
                        return Optional.of(QueryProcessor.createProxy((Tuple)result, mapClass, executor));
                    }
                    return Optional.of(result);
                }
                catch (NoResultException ex) {
                    return Optional.empty();
                }
            }
            case TUPLES: {
                if (Objects.nonNull(mapClass) && !Tuple.class.equals(mapClass) && mapClass.isInterface()) {
                    return q.getResultList().stream().map(r -> QueryProcessor.createProxy((Tuple)r, mapClass, executor)).collect(Collectors.toList());
                }
                return q.getResultList();
            }
        }
        throw new GenericCodeGenException("Unknown query return type!");
    }

    private static Class<?> nativeQueryClass(Class<?> map) {
        Class impl;
        Class result = map;
        if (map.isInterface() && Objects.nonNull(impl = CodeFactory.lookup(map))) {
            result = impl;
        }
        return result;
    }

    private static Object map(Class<?> mapClass, Object result) {
        if (Objects.nonNull(result) && mapClass.isInterface()) {
            return factory.createProjection(mapClass, result);
        }
        return result;
    }

    private static Object nullProcess(QueryExecutor executor, EntityManager manager, String query, List<Object> params, ResultType resultType, Class<?> returnClass, Class<?> mapClass, boolean isNative, boolean modifying, Pageable pageable, FlushModeType flush, LockModeType lock, Map<String, Object> hints, List<Filter> filters) {
        return null;
    }

    private static Object createProxy(Tuple tuple, Class mapClass, QueryExecutor executor) {
        List elements = tuple.getElements();
        if (elements.size() == 1 && Objects.nonNull(tuple.get(0)) && mapClass.isInstance(tuple.get(0))) {
            return tuple.get(0);
        }
        return Proxy.newProxyInstance(mapClass.getClassLoader(), new Class[]{mapClass}, (InvocationHandler)new TupleBackedProjection(tuple, executor));
    }

    @FunctionalInterface
    public static interface Processor {
        public Object process(QueryExecutor var1, EntityManager var2, String var3, List<Object> var4, ResultType var5, Class<?> var6, Class<?> var7, boolean var8, boolean var9, Pageable var10, FlushModeType var11, LockModeType var12, Map<String, Object> var13, List<Filter> var14);
    }

    public static enum ResultType {
        UNKNOWN,
        SINGLE,
        LIST,
        PAGE,
        COUNT,
        REMOVE,
        EXECUTE,
        TUPLE,
        TUPLES;

    }
}

