/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.spring.query.executor;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.persistence.EntityManager;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.spring.BasePersistenceOperations;
import net.binis.codegen.spring.query.executor.QueryExecutor;
import org.springframework.jmx.access.InvalidInvocationException;

public class TupleBackedProjection
implements InvocationHandler {
    private final Tuple tuple;
    private final QueryExecutor executor;
    private static Method withRes;

    public TupleBackedProjection(Tuple tuple, QueryExecutor executor) {
        try {
            withRes = BasePersistenceOperations.class.getDeclaredMethod("withRes", Function.class);
            withRes.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Invalid executor class!");
        }
        this.tuple = tuple;
        this.executor = executor;
    }

    static String getNativeFieldName(String name) {
        StringBuilder n = new StringBuilder(name);
        StringBuilder res = new StringBuilder();
        int start = 3;
        if (name.charAt(0) == 'i') {
            start = 2;
        }
        res.append(Character.toLowerCase(n.charAt(start)));
        for (int i = start + 1; i < n.length(); ++i) {
            char ch = n.charAt(i);
            if (Character.isUpperCase(ch)) {
                res.append('_').append(Character.toLowerCase(ch));
                continue;
            }
            res.append(ch);
        }
        return res.toString();
    }

    static String getFieldName(String name) {
        int start = 3;
        if (name.charAt(0) == 'i') {
            start = 2;
        }
        StringBuilder result = new StringBuilder(name.substring(start));
        result.setCharAt(0, Character.toLowerCase(result.charAt(0)));
        return result.toString();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        if (method.getName().startsWith("get") || method.getName().startsWith("is")) {
            String field = TupleBackedProjection.getFieldName(method.getName());
            try {
                return this.convert(this.tuple.get(field), method.getReturnType());
            }
            catch (IllegalArgumentException e) {
                field = TupleBackedProjection.getNativeFieldName(method.getName());
                try {
                    return this.convert(this.tuple.get(field), method.getReturnType());
                }
                catch (IllegalArgumentException exc) {
                    try {
                        return this.processSubEntity(this.tuple.get(field + "_id"), method.getReturnType());
                    }
                    catch (IllegalArgumentException ex) {
                        throw exc;
                    }
                }
            }
        }
        if ("toString".equals(method.getName())) {
            return this.tupleToString();
        }
        throw new InvalidInvocationException("Can't invoke method: " + method.getName());
    }

    private Object processSubEntity(Object id, Class<?> returnType) {
        if (Objects.nonNull(id)) {
            Class obj = CodeFactory.lookup(returnType);
            if (Objects.nonNull(obj)) {
                try {
                    Function<EntityManager, Object> func = m -> m.find(obj, this.convert(id, m.getMetamodel().entity(obj).getIdType().getJavaType()));
                    return withRes.invoke((Object)this.executor, func);
                }
                catch (Exception e) {
                    return new IllegalArgumentException();
                }
            }
            throw new IllegalArgumentException();
        }
        return null;
    }

    private Object convert(Object val, Class cls) {
        if (Objects.nonNull(val)) {
            if (val instanceof BigInteger) {
                if (Integer.TYPE.equals(cls) || Integer.class.equals((Object)cls)) {
                    return ((BigInteger)val).intValue();
                }
                if (Long.TYPE.equals(cls) || Long.class.equals((Object)cls)) {
                    return ((BigInteger)val).longValue();
                }
            }
            if (val instanceof BigDecimal) {
                if (Double.TYPE.equals(cls) || Double.class.equals((Object)cls)) {
                    return ((BigDecimal)val).doubleValue();
                }
                if (Float.TYPE.equals(cls) || Float.class.equals((Object)cls)) {
                    return Float.valueOf(((BigDecimal)val).floatValue());
                }
            }
            if (val instanceof Timestamp) {
                if (LocalDateTime.class.equals((Object)cls)) {
                    return ((Timestamp)val).toLocalDateTime();
                }
                if (LocalDate.class.equals((Object)cls)) {
                    return ((Timestamp)val).toLocalDateTime().toLocalDate();
                }
                if (LocalTime.class.equals((Object)cls)) {
                    return ((Timestamp)val).toLocalDateTime().toLocalTime();
                }
                if (OffsetDateTime.class.equals((Object)cls)) {
                    return ((Timestamp)val).toLocalDateTime().atOffset(ZoneOffset.UTC);
                }
            }
        }
        return val;
    }

    private String tupleToString() {
        StringBuilder result = new StringBuilder("(");
        List elements = this.tuple.getElements();
        for (int i = 0; i < this.tuple.getElements().size(); ++i) {
            TupleElement element = (TupleElement)elements.get(i);
            if (Objects.nonNull(element.getAlias())) {
                result.append("[\"").append(element.getAlias()).append("\"]");
            } else {
                result.append(i);
            }
            result.append("=").append(this.tuple.get(i)).append("; ");
        }
        if (!elements.isEmpty()) {
            result.setLength(result.length() - 2);
        }
        return result.append(")").toString();
    }
}

