/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.spring;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.factory.ObjectFactory;
import net.binis.codegen.spring.BaseEntityModifier;
import net.binis.codegen.spring.async.AsyncDispatcher;
import net.binis.codegen.spring.async.AsyncModifier;
import net.binis.codegen.spring.async.executor.CodeExecutor;
import net.binis.codegen.spring.async.executor.CodeGenCompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncEntityModifier<T, R>
extends BaseEntityModifier<T, R> {
    private static final Logger log = LoggerFactory.getLogger(AsyncEntityModifier.class);

    public AsyncModifier<T, R> async() {
        return new AsyncImpl();
    }

    static {
        CodeFactory.registerType(AsyncDispatcher.class, (ObjectFactory)CodeFactory.singleton((Object)CodeExecutor.defaultDispatcher()), null);
    }

    protected class AsyncImpl
    implements AsyncModifier<T, R> {
        private String flow = "default";
        private long delay;
        private TimeUnit unit;

        protected AsyncImpl() {
        }

        @Override
        public AsyncModifier<T, R> flow(String flow) {
            this.flow = flow;
            return this;
        }

        @Override
        public AsyncModifier<T, R> delay(long delay, TimeUnit unit) {
            this.delay = delay;
            this.unit = unit;
            return this;
        }

        @Override
        public AsyncModifier<T, R> delay(Duration duration) {
            this.delay = duration.toMillis();
            this.unit = TimeUnit.MILLISECONDS;
            return this;
        }

        @Override
        public CompletableFuture<R> save() {
            return this.execute(AsyncEntityModifier.this::save);
        }

        @Override
        public CompletableFuture<R> delete() {
            return this.execute(AsyncEntityModifier.this::delete);
        }

        @Override
        public CompletableFuture<R> execute(Consumer<T> task) {
            return this.execute(() -> AsyncEntityModifier.this.transaction(m -> {
                task.accept(m);
                return null;
            }));
        }

        @Override
        private CompletableFuture<R> execute(Supplier<R> supplier) {
            Executor executor = ((AsyncDispatcher)CodeFactory.create(AsyncDispatcher.class)).flow(this.flow);
            if (this.delay > 0L && Objects.nonNull((Object)this.unit)) {
                executor = CompletableFuture.delayedExecutor(this.delay, this.unit, executor);
            }
            return CodeGenCompletableFuture.newSupplyAsync(executor, supplier);
        }
    }
}

