/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.spring;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import net.binis.codegen.exception.GenericCodeGenException;
import net.binis.codegen.spring.component.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

public class BasePersistenceOperations<R> {
    private static final Logger log = LoggerFactory.getLogger(BasePersistenceOperations.class);
    private static EntityManagerFactory factory;
    private static TransactionTemplate template;
    private static Function<EntityManagerFactory, EntityManager> entityManagerProvider;

    public static void setEntityManagerProvider(Function<EntityManagerFactory, EntityManager> provider) {
        entityManagerProvider = provider;
    }

    private static void init() {
        if (Objects.isNull(factory)) {
            ApplicationContext context = ApplicationContextProvider.getApplicationContext();
            if (Objects.isNull(context)) {
                throw new GenericCodeGenException("Not in spring context!");
            }
            JpaTransactionManager tm = (JpaTransactionManager)context.getBean(JpaTransactionManager.class);
            factory = tm.getEntityManagerFactory();
            template = (TransactionTemplate)context.getBean(TransactionTemplate.class);
        }
    }

    protected void with(Consumer<EntityManager> func) {
        BasePersistenceOperations.init();
        EntityManager em = entityManagerProvider.apply(factory);
        if (Objects.isNull(em) || !TransactionSynchronizationManager.isActualTransactionActive()) {
            log.debug("Attempt to do action outside of open transaction!");
            template.execute(s -> {
                EntityManager manager = entityManagerProvider.apply(factory);
                func.accept(manager);
                return null;
            });
        } else {
            func.accept(em);
        }
    }

    protected R withRes(Function<EntityManager, R> func) {
        BasePersistenceOperations.init();
        EntityManager em = entityManagerProvider.apply(factory);
        if (Objects.isNull(em) || !TransactionSynchronizationManager.isActualTransactionActive()) {
            log.debug("Attempt to do action outside of open transaction!");
            return (R)template.execute(s -> func.apply(entityManagerProvider.apply(factory)));
        }
        return func.apply(em);
    }

    protected R withNewTransactionRes(Function<EntityManager, R> func) {
        BasePersistenceOperations.init();
        EntityManager em = entityManagerProvider.apply(factory);
        if (Objects.isNull(em) || !TransactionSynchronizationManager.isActualTransactionActive()) {
            log.debug("Attempt to do action outside of open transaction!");
            return (R)template.execute(s -> func.apply(entityManagerProvider.apply(factory)));
        }
        TransactionTemplate transactionTemplate = new TransactionTemplate(template.getTransactionManager());
        transactionTemplate.setPropagationBehavior(3);
        return (R)transactionTemplate.execute(s -> func.apply(em));
    }

    private static Function<EntityManagerFactory, EntityManager> defaultEntityManagerProvider() {
        return EntityManagerFactoryUtils::getTransactionalEntityManager;
    }

    static {
        entityManagerProvider = BasePersistenceOperations.defaultEntityManagerProvider();
    }
}

