/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.spring;

import java.util.function.Function;
import javax.persistence.EntityManager;
import net.binis.codegen.annotation.Final;
import net.binis.codegen.modifier.Modifiable;
import net.binis.codegen.modifier.Modifier;
import net.binis.codegen.spring.BasePersistenceOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseEntityModifier<T, R>
extends BasePersistenceOperations<R>
implements Modifier<R> {
    private static final Logger log = LoggerFactory.getLogger(BaseEntityModifier.class);
    protected R parent;

    @Final
    public R save() {
        this.with(manager -> manager.persist(this.parent));
        return this.parent;
    }

    @Final
    public R saveAndFlush() {
        this.save();
        this.with(EntityManager::flush);
        return this.parent;
    }

    @Final
    public R merge() {
        return (R)this.withRes(manager -> manager.merge(this.parent));
    }

    @Final
    public R delete() {
        this.with(manager -> manager.remove(this.parent));
        return this.parent;
    }

    @Final
    public R refresh() {
        this.with(manager -> manager.refresh(this.parent));
        return this.parent;
    }

    @Final
    public R detach() {
        this.with(manager -> manager.detach(this.parent));
        return this.parent;
    }

    @Final(imports={"java.util.function.Function"}, description="Function<{R}, {T}> function")
    public R transaction(Function<T, R> function) {
        return (R)this.withRes(manager -> function.apply(((Modifiable)manager.merge(this.parent)).with()));
    }

    public void setObject(R parent) {
        this.parent = parent;
    }
}

