/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.spring.configuration;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.Objects;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.jackson.CodeBeanDeserializerModifier;
import net.binis.codegen.jackson.CodeProxyTypeFactory;
import net.binis.codegen.spring.configuration.properties.CodeGenProperties;
import net.binis.codegen.spring.query.QueryProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;

@Configuration
public class CodeGenSpringConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CodeGenSpringConfiguration.class);

    public CodeGenSpringConfiguration(CodeGenProperties properties, ApplicationContext context) {
        if (properties.isShow_hql()) {
            log.info("Query logging enabled!");
            QueryProcessor.logQuery();
            if (properties.isShow_hql_params()) {
                log.info("Query params logging enabled!");
                QueryProcessor.logParams();
            }
        }
        if (Objects.isNull(CodeFactory.getProjectionProvider())) {
            SpelAwareProxyProjectionFactory factory = new SpelAwareProxyProjectionFactory();
            CodeFactory.setProjectionProvider((cls, projections) -> obj -> factory.createProjection(projections[0], obj));
        }
        CodeFactory.registerForeignFactory((arg_0, arg_1) -> ((ApplicationContext)context).getBean(arg_0, arg_1));
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer jsonCustomizer() {
        SimpleModule module = new SimpleModule();
        module.setDeserializerModifier((BeanDeserializerModifier)new CodeBeanDeserializerModifier());
        return builder -> builder.postConfigurer(c -> c.setTypeFactory((TypeFactory)new CodeProxyTypeFactory(c.getTypeFactory()))).modulesToInstall(new Module[]{module});
    }
}

