/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.spring.actuator;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import net.binis.codegen.async.AsyncDispatcher;
import net.binis.codegen.async.monitoring.DispatcherMonitor;
import net.binis.codegen.async.monitoring.ExecutorMonitor;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.spring.actuator.CodeGenActuatorModel;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.stereotype.Component;

@Component
@Endpoint(id="codegen-async")
public class CodeGenActuatorEndpoint {
    @ReadOperation
    public CodeGenActuatorModel health() {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        AsyncDispatcher dispatcher = (AsyncDispatcher)CodeFactory.create(AsyncDispatcher.class, (Object[])new Object[0]);
        if (dispatcher instanceof DispatcherMonitor) {
            DispatcherMonitor monitor = (DispatcherMonitor)dispatcher;
            details.put("flows", monitor.flows());
        }
        return this.build(details);
    }

    private CodeGenActuatorModel build(Map<String, Object> details) {
        CodeGenActuatorModel health = new CodeGenActuatorModel();
        health.setHealthDetails(details);
        return health;
    }

    @ReadOperation
    public CodeGenActuatorModel flow(@Selector String flow) {
        Map<String, Object> details;
        if ("all".equals(flow)) {
            return this.all();
        }
        AsyncDispatcher dispatcher = (AsyncDispatcher)CodeFactory.create(AsyncDispatcher.class, (Object[])new Object[0]);
        if (dispatcher instanceof DispatcherMonitor) {
            DispatcherMonitor monitor = (DispatcherMonitor)dispatcher;
            details = this.buildFlowStats(flow, monitor);
        } else {
            details = Collections.emptyMap();
        }
        return this.build(details);
    }

    private CodeGenActuatorModel all() {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        AsyncDispatcher dispatcher = (AsyncDispatcher)CodeFactory.create(AsyncDispatcher.class, (Object[])new Object[0]);
        if (dispatcher instanceof DispatcherMonitor) {
            DispatcherMonitor monitor = (DispatcherMonitor)dispatcher;
            for (String flow : monitor.flows()) {
                details.put(flow, this.buildFlowStats(flow, monitor));
            }
        }
        return this.build(details);
    }

    private Map<String, Object> buildFlowStats(String name, DispatcherMonitor monitor) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        Executor executor = monitor.getExecutor(name);
        if (executor instanceof ExecutorMonitor) {
            ExecutorMonitor m = (ExecutorMonitor)executor;
            details.put("pool-size", m.getPoolSize());
            details.put("core-pool-size", m.getCorePoolSize());
            details.put("largest-pool-size", m.getLargestPoolSize());
            details.put("maximum-pool-size", m.getMaximumPoolSize());
            details.put("active-count", m.getActiveCount());
            details.put("task-count", m.getTaskCount());
            details.put("completed-task-count", m.getCompletedTaskCount());
            details.put("keep-alive-time", m.getKeepAliveTime(TimeUnit.MILLISECONDS));
            details.put("queue-size", m.getQueueSize());
        }
        return details;
    }
}

