/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.redis;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import java.util.Objects;
import net.binis.codegen.annotation.CodeConfiguration;
import net.binis.codegen.exception.MapperException;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.map.Mapper;
import net.binis.codegen.redis.encoding.ValueEncoding;

@CodeConfiguration
public class Redis {
    protected static final RedisClient client = RedisClient.create();
    protected static StatefulRedisConnection<String, Object> connection;
    protected static ValueEncoding encoding;
    protected static String connectionString;

    public static RedisClient client() {
        return client;
    }

    public static StatefulRedisConnection<String, Object> connection() {
        return connection;
    }

    public static StatefulConnection<String, Object> setup(String connection) {
        return Redis.setup(connection, ValueEncoding.STRING);
    }

    public static StatefulConnection<String, Object> setup(String connection, ValueEncoding encoding) {
        connectionString = connection;
        Redis.encoding = encoding;
        switch (encoding) {
            case STRING: {
                Redis.connection = client.connect((RedisCodec)StringCodec.UTF8, RedisURI.create((String)connection));
                break;
            }
            case BYTE_ARRAY: {
                Redis.connection = client.connect(RedisCodec.of((RedisCodec)StringCodec.UTF8, (RedisCodec)ByteArrayCodec.INSTANCE), RedisURI.create((String)connection));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return Redis.connection;
    }

    public static <T> T load(String key, Class<T> cls) {
        Class impl = CodeFactory.lookup(cls);
        if (Objects.nonNull(impl)) {
            Object result = connection.sync().get((Object)(Redis.getPrefix(impl) + key));
            if (Objects.nonNull(result)) {
                return (T)Mapper.convert((Object)result, (Class)impl, (Object[])new Object[]{key});
            }
            return null;
        }
        return null;
    }

    public static <T> T load(Class<T> cls) {
        return Redis.load("", cls);
    }

    public static Object serialize(Object obj) {
        return switch (encoding) {
            case ValueEncoding.STRING -> {
                String var1_1;
                try {
                    var1_1 = ((ObjectMapper)CodeFactory.create(ObjectMapper.class, (Object[])new Object[0])).writeValueAsString(obj);
                }
                catch (Exception e) {
                    throw new MapperException(e);
                }
                yield (Object)var1_1;
            }
            case ValueEncoding.BYTE_ARRAY -> {
                byte[] var1_2;
                yield var1_2 = (byte[])Mapper.convert((Object)obj, byte[].class);
            }
            default -> throw new UnsupportedOperationException();
        };
    }

    private static String getPrefix(Class<?> impl) {
        try {
            return (String)impl.getDeclaredField("PREFIX").get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Redis() {
    }
}

