/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.redis.modifier.impl;

import java.lang.reflect.Method;
import java.util.function.Consumer;
import net.binis.codegen.exception.MapperException;
import net.binis.codegen.modifier.impl.BaseModifierImpl;
import net.binis.codegen.redis.Redis;
import net.binis.codegen.redis.modifier.RedisModifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RedisModifierImpl<T, R>
extends BaseModifierImpl<T, R>
implements RedisModifier<T, R> {
    private static final Logger log = LoggerFactory.getLogger(RedisModifierImpl.class);
    protected Method keyMethod;

    protected RedisModifierImpl(R parent) {
        super(parent);
        try {
            this.keyMethod = parent.getClass().getDeclaredMethod("key", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public R save() {
        return this.withKey(key -> Redis.connection().sync().set(key, Redis.serialize(this.parent)));
    }

    @Override
    public R delete() {
        return this.withKey(key -> {
            try {
                Redis.connection().sync().del((Object[])new String[]{key});
            }
            catch (Exception e) {
                throw new MapperException(e);
            }
        });
    }

    protected R withKey(Consumer<String> consumer) {
        try {
            String k = (String)this.keyMethod.invoke(this.parent, new Object[0]);
            consumer.accept(k);
            return (R)this.parent;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

