/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.projection.provider;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.factory.ProjectionInstantiation;
import net.binis.codegen.factory.ProjectionProvider;
import net.binis.codegen.factory.ProxyProvider;
import net.binis.codegen.objects.Pair;
import net.binis.codegen.projection.exception.ProjectionCreationException;
import net.binis.codegen.projection.objects.CodeMethodImplementation;
import net.binis.codegen.projection.objects.CodeProjectionProxyList;
import net.binis.codegen.projection.objects.CodeProjectionProxySet;
import net.binis.codegen.projection.objects.CodeProxyBase;
import net.binis.codegen.tools.Reflection;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.Label;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeGenProjectionProvider
implements ProjectionProvider,
ProxyProvider {
    private static final Logger log = LoggerFactory.getLogger(CodeGenProjectionProvider.class);
    protected static final String PROXY_BASE = "net/binis/codegen/projection/objects/CodeProxyBase";
    public static final String OBJECT_DESC = "Ljava/lang/Object;";
    public static final String FIELD_NAME = "value";
    protected static final Map<Class, Class> proxies = new ConcurrentHashMap<Class, Class>();

    public ProjectionInstantiation create(Class<?> cls, Class<?> ... projections) {
        Constructor<?> c = this.createObject(cls, projections);
        return o -> {
            try {
                return c.newInstance(o);
            }
            catch (Exception e) {
                throw new ProjectionCreationException("Unable to create projection for class: " + cls.getCanonicalName(), e);
            }
        };
    }

    protected Constructor<?> createObject(Class<?> cls, Class<?>[] projections) {
        try {
            return this.createProjectionClass(cls, projections).getDeclaredConstructor(cls);
        }
        catch (NoSuchMethodException e) {
            throw new ProjectionCreationException("Unable to find constructor for proxy class: " + cls.getCanonicalName(), e);
        }
    }

    protected Class<?> createProjectionClass(Class<?> cls, Class<?>[] projections) {
        String desc = TypeDefinition.Sort.describe(cls).getActualName().replace('.', '/');
        String objectName = "net.binis.projection." + cls.getSimpleName();
        for (Class<?> p : projections) {
            objectName = objectName + "$" + p.getSimpleName();
        }
        DynamicType.Builder<?> type = new ByteBuddy().subclass(CodeProxyBase.class).visit((AsmVisitorWrapper)new EnableFramesComputing()).name(objectName).implement((Type[])projections).defineConstructor(1).withParameter(cls).intercept((Implementation)new CodeMethodImplementation(){

            @Override
            public ByteCodeAppender.Size code(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitMethodInsn(183, CodeGenProjectionProvider.PROXY_BASE, "<init>", "()V", false);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitFieldInsn(181, CodeGenProjectionProvider.PROXY_BASE, CodeGenProjectionProvider.FIELD_NAME, CodeGenProjectionProvider.OBJECT_DESC);
                methodVisitor.visitInsn(177);
                return new ByteCodeAppender.Size(2, 2);
            }
        });
        HashMap<String, List<Class<?>[]>> methods = new HashMap<String, List<Class<?>[]>>();
        for (Class<?> p : projections) {
            type = type.annotateType(p.getDeclaredAnnotations());
            type = this.handleInterface(type, cls, p, desc, methods);
        }
        return type.make().load(cls.getClassLoader()).getLoaded();
    }

    protected DynamicType.Builder<?> handleInterface(DynamicType.Builder<?> type, Class<?> cls, Class<?> intf, String desc, Map<String, List<Class<?>[]>> methods) {
        for (Method method : intf.getDeclaredMethods()) {
            if ((method.getModifiers() & 8) != 0) continue;
            type = this.handleMethod(type, cls, method, desc, methods);
        }
        for (GenericDeclaration genericDeclaration : intf.getInterfaces()) {
            type = this.handleInterface(type, cls, (Class<?>)genericDeclaration, desc, methods);
        }
        return type;
    }

    protected DynamicType.Builder<?> handleMethod(DynamicType.Builder<?> type, Class<?> cls, Method mtd, String desc, Map<String, List<Class<?>[]>> methods) {
        Class<?>[] types = mtd.getParameterTypes();
        Class<?> ret = mtd.getReturnType();
        if (!this.methodExists(methods, mtd, types)) {
            boolean isVoid = Void.TYPE.equals(ret);
            try {
                Method m = this.findMethod(cls, mtd.getName(), types);
                type = this.handleDeclaredMethod(type, mtd, m, desc, types, ret);
            }
            catch (NoSuchMethodException e) {
                DynamicType.Builder<?> t = this.checkPath(type, cls, mtd, desc, types, ret, isVoid);
                if (Objects.isNull(t)) {
                    if (!mtd.isDefault()) {
                        type = this.handleUndeclaredMethod(type, mtd, types, ret, isVoid);
                    }
                }
                type = t;
            }
        }
        return type;
    }

    protected DynamicType.Builder<?> handleUndeclaredMethod(DynamicType.Builder<?> type, Method mtd, final Class<?>[] types, final Class<?> ret, final boolean isVoid) {
        log.info("Handle undeclared method: {}", (Object)mtd.toString());
        return type.defineMethod(mtd.getName(), ret, 1).withParameters((Type[])types).intercept((Implementation)new CodeMethodImplementation(){

            @Override
            public ByteCodeAppender.Size code(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                if (isVoid) {
                    methodVisitor.visitInsn(177);
                    return new ByteCodeAppender.Size(0, types.length + 1);
                }
                CodeGenProjectionProvider.defaultReturn(methodVisitor, ret);
                return new ByteCodeAppender.Size(1 + (ret.isPrimitive() ? 1 : 0), types.length + 1);
            }
        }).annotateMethod(mtd.getDeclaredAnnotations());
    }

    protected DynamicType.Builder<?> handleDeclaredMethod(DynamicType.Builder<?> type, final Method mtd, final Method m, final String desc, final Class<?>[] types, final Class<?> ret) {
        Type[] generics;
        if (CodeFactory.isCustomProxyClass(mtd.getReturnType()) && this.needProjection(generics = ((ParameterizedType)mtd.getGenericReturnType()).getActualTypeArguments(), ((ParameterizedType)m.getGenericReturnType()).getActualTypeArguments())) {
            return this.handleCustomClassProjection(type, mtd, m, desc, types, ret, generics);
        }
        if (ret.isInterface() && !mtd.getReturnType().equals(m.getReturnType())) {
            return this.handleProjection(type, mtd, m, desc, types, ret);
        }
        return type.defineMethod(mtd.getName(), ret, 1).withParameters((Type[])types).intercept((Implementation)new CodeMethodImplementation(){

            @Override
            public ByteCodeAppender.Size code(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, CodeGenProjectionProvider.PROXY_BASE, CodeGenProjectionProvider.FIELD_NAME, CodeGenProjectionProvider.OBJECT_DESC);
                methodVisitor.visitTypeInsn(192, desc);
                int offset = CodeGenProjectionProvider.this.loadParams(methodVisitor, types);
                if (ret.isAssignableFrom(m.getReturnType())) {
                    methodVisitor.visitMethodInsn(182, desc, mtd.getName(), CodeGenProjectionProvider.this.calcDescriptor(types, ret), false);
                } else {
                    methodVisitor.visitMethodInsn(182, desc, mtd.getName(), CodeGenProjectionProvider.this.calcDescriptor(types, m.getReturnType()), false);
                    methodVisitor.visitVarInsn(58, 1);
                    methodVisitor.visitVarInsn(25, 1);
                    net.bytebuddy.jar.asm.Type restDesc = net.bytebuddy.jar.asm.Type.getType((Class)ret);
                    methodVisitor.visitLdcInsn((Object)restDesc);
                    methodVisitor.visitMethodInsn(184, "net/binis/codegen/map/Mapper", "convert", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;", false);
                    methodVisitor.visitTypeInsn(192, restDesc.getInternalName());
                }
                int locals = offset;
                Pair<Integer, Integer> retOp = CodeGenProjectionProvider.this.getReturnOpcode(ret);
                methodVisitor.visitInsn(((Integer)retOp.getKey()).intValue());
                return new ByteCodeAppender.Size(offset += ((Integer)retOp.getValue()).intValue(), locals);
            }
        }).annotateMethod(mtd.getDeclaredAnnotations());
    }

    protected DynamicType.Builder<?> handlePath(DynamicType.Builder<?> type, Class<?> cls, Method mtd, final String desc, final Class<?>[] types, final Class<?> ret, boolean isVoid, final Deque<Method> path) {
        assert (path.size() > 1);
        return type.defineMethod(mtd.getName(), ret, 1).withParameters((Type[])types).intercept((Implementation)new CodeMethodImplementation(){

            @Override
            public ByteCodeAppender.Size code(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                Method pm;
                int loadOffset = CodeGenProjectionProvider.this.loadOffset(types);
                Label label = new Label();
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, CodeGenProjectionProvider.PROXY_BASE, CodeGenProjectionProvider.FIELD_NAME, CodeGenProjectionProvider.OBJECT_DESC);
                methodVisitor.visitTypeInsn(192, desc);
                int size = path.size();
                Method m = (Method)path.pop();
                if (m.getDeclaringClass().isInterface()) {
                    methodVisitor.visitMethodInsn(185, desc, m.getName(), CodeGenProjectionProvider.this.calcDescriptor(m.getParameterTypes(), m.getReturnType()), true);
                } else {
                    methodVisitor.visitMethodInsn(182, desc, m.getName(), CodeGenProjectionProvider.this.calcDescriptor(m.getParameterTypes(), m.getReturnType()), false);
                }
                for (int i = 1; i < size - 1; ++i) {
                    pm = m;
                    m = (Method)path.pop();
                    int o = loadOffset + i;
                    methodVisitor.visitVarInsn(58, o);
                    methodVisitor.visitVarInsn(25, o);
                    methodVisitor.visitJumpInsn(198, label);
                    methodVisitor.visitVarInsn(25, o);
                    if (m.getDeclaringClass().isInterface()) {
                        methodVisitor.visitMethodInsn(185, TypeDefinition.Sort.describe(pm.getReturnType()).getActualName().replace('.', '/'), m.getName(), CodeGenProjectionProvider.this.calcDescriptor(m.getParameterTypes(), m.getReturnType()), true);
                        continue;
                    }
                    methodVisitor.visitMethodInsn(182, TypeDefinition.Sort.describe(pm.getReturnType()).getActualName().replace('.', '/'), m.getName(), CodeGenProjectionProvider.this.calcDescriptor(m.getParameterTypes(), m.getReturnType()), false);
                }
                pm = m;
                m = (Method)path.pop();
                int o = loadOffset + size - 1;
                methodVisitor.visitVarInsn(58, o);
                methodVisitor.visitVarInsn(25, o);
                methodVisitor.visitJumpInsn(198, label);
                methodVisitor.visitVarInsn(25, o);
                CodeGenProjectionProvider.this.loadParams(methodVisitor, types);
                if (m.getDeclaringClass().isInterface()) {
                    methodVisitor.visitMethodInsn(185, TypeDefinition.Sort.describe(pm.getReturnType()).getActualName().replace('.', '/'), m.getName(), CodeGenProjectionProvider.this.calcDescriptor(m.getParameterTypes(), m.getReturnType()), true);
                } else {
                    methodVisitor.visitMethodInsn(182, TypeDefinition.Sort.describe(pm.getReturnType()).getActualName().replace('.', '/'), m.getName(), CodeGenProjectionProvider.this.calcDescriptor(m.getParameterTypes(), m.getReturnType()), false);
                }
                if (ret.isInterface() && !ret.equals(m.getReturnType())) {
                    net.bytebuddy.jar.asm.Type retDesc = net.bytebuddy.jar.asm.Type.getType((Class)ret);
                    methodVisitor.visitLdcInsn((Object)retDesc);
                    methodVisitor.visitMethodInsn(184, "net/binis/codegen/factory/CodeFactory", "projection", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;", false);
                    methodVisitor.visitTypeInsn(192, retDesc.getInternalName());
                }
                Pair<Integer, Integer> retOp = CodeGenProjectionProvider.this.getReturnOpcode(ret);
                methodVisitor.visitInsn(((Integer)retOp.getKey()).intValue());
                methodVisitor.visitLabel(label);
                CodeGenProjectionProvider.defaultReturn(methodVisitor, ret);
                return new ByteCodeAppender.Size(1, 1);
            }
        }).annotateMethod(mtd.getDeclaredAnnotations());
    }

    protected DynamicType.Builder<?> handleProjection(DynamicType.Builder<?> type, final Method mtd, final Method m, final String desc, final Class<?>[] types, Class<?> ret) {
        return type.defineMethod(mtd.getName(), ret, 1).withParameters((Type[])types).intercept((Implementation)new CodeMethodImplementation(){

            @Override
            public ByteCodeAppender.Size code(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, CodeGenProjectionProvider.PROXY_BASE, CodeGenProjectionProvider.FIELD_NAME, CodeGenProjectionProvider.OBJECT_DESC);
                methodVisitor.visitTypeInsn(192, desc);
                int offset = CodeGenProjectionProvider.this.loadParams(methodVisitor, types);
                methodVisitor.visitMethodInsn(182, desc, mtd.getName(), CodeGenProjectionProvider.this.calcDescriptor(types, m.getReturnType()), false);
                methodVisitor.visitLdcInsn((Object)net.bytebuddy.jar.asm.Type.getType(mtd.getReturnType()));
                methodVisitor.visitMethodInsn(184, "net/binis/codegen/factory/CodeFactory", "projection", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;", false);
                methodVisitor.visitTypeInsn(192, TypeDefinition.Sort.describe(mtd.getReturnType()).getActualName().replace('.', '/'));
                methodVisitor.visitInsn(176);
                int size = offset == 1 ? 2 : offset;
                return new ByteCodeAppender.Size(size, offset);
            }
        }).annotateMethod(mtd.getDeclaredAnnotations());
    }

    protected DynamicType.Builder<?> handleCustomClassProjection(DynamicType.Builder<?> type, final Method mtd, final Method m, final String desc, final Class<?>[] types, Class<?> ret, final Type[] generics) {
        return type.defineMethod(mtd.getName(), ret, 1).withParameters((Type[])types).intercept((Implementation)new CodeMethodImplementation(){

            @Override
            public ByteCodeAppender.Size code(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, CodeGenProjectionProvider.PROXY_BASE, CodeGenProjectionProvider.FIELD_NAME, CodeGenProjectionProvider.OBJECT_DESC);
                methodVisitor.visitTypeInsn(192, desc);
                CodeGenProjectionProvider.this.loadParams(methodVisitor, types);
                methodVisitor.visitMethodInsn(182, desc, mtd.getName(), CodeGenProjectionProvider.this.calcDescriptor(types, m.getReturnType()), false);
                methodVisitor.visitInsn(3 + generics.length);
                methodVisitor.visitTypeInsn(189, "java/lang/Class");
                for (Type c : generics) {
                    methodVisitor.visitInsn(89);
                    methodVisitor.visitInsn(3);
                    methodVisitor.visitLdcInsn((Object)net.bytebuddy.jar.asm.Type.getType((Class)((Class)c)));
                    methodVisitor.visitInsn(83);
                }
                methodVisitor.visitMethodInsn(184, "net/binis/codegen/factory/CodeFactory", "projections", "(Ljava/lang/Object;[Ljava/lang/Class;)Ljava/lang/Object;", false);
                methodVisitor.visitTypeInsn(192, TypeDefinition.Sort.describe(mtd.getReturnType()).getActualName().replace('.', '/'));
                methodVisitor.visitInsn(176);
                return new ByteCodeAppender.Size(1, 1);
            }
        }).annotateMethod(mtd.getDeclaredAnnotations());
    }

    protected boolean needProjection(Type[] generics, Type[] original) {
        if (generics.length == original.length) {
            for (int i = 0; i < generics.length; ++i) {
                if (!(generics[i] instanceof Class) || !(original[i] instanceof Class) || !((Class)generics[i]).isInterface() || generics[i].equals(original[i])) continue;
                return true;
            }
        }
        return false;
    }

    protected String calcDescriptor(Class<?>[] types, Class<?> returnType) {
        StringBuilder sb = new StringBuilder("(");
        for (Class<?> t : types) {
            if (t.isPrimitive()) {
                sb.append(this.getPrimitiveDescriptor(t));
                continue;
            }
            sb.append('L').append(TypeDefinition.Sort.describe(t).getActualName().replace('.', '/')).append(';');
        }
        sb.append(')');
        if (Void.TYPE.equals(returnType)) {
            sb.append('V');
        } else if (returnType.isPrimitive()) {
            sb.append(this.getPrimitiveDescriptor(returnType));
        } else {
            sb.append('L').append(TypeDefinition.Sort.describe(returnType).getActualName().replace('.', '/')).append(';');
        }
        return sb.toString();
    }

    protected char getPrimitiveDescriptor(Class<?> type) {
        if (Boolean.TYPE.equals(type)) {
            return 'Z';
        }
        if (Byte.TYPE.equals(type)) {
            return 'B';
        }
        if (Short.TYPE.equals(type)) {
            return 'S';
        }
        if (Character.TYPE.equals(type)) {
            return 'C';
        }
        if (Integer.TYPE.equals(type)) {
            return 'I';
        }
        if (Long.TYPE.equals(type)) {
            return 'J';
        }
        if (Float.TYPE.equals(type)) {
            return 'F';
        }
        if (Double.TYPE.equals(type)) {
            return 'D';
        }
        if (Void.TYPE.equals(type)) {
            return 'V';
        }
        throw new ProjectionCreationException("Unknown primitive type: " + type.getCanonicalName());
    }

    protected int getLoadOpcode(Class<?> type) {
        if (type.isPrimitive()) {
            if (Long.TYPE.equals(type)) {
                return 22;
            }
            if (Double.TYPE.equals(type)) {
                return 24;
            }
            if (Float.TYPE.equals(type)) {
                return 23;
            }
            return 21;
        }
        return 25;
    }

    protected Pair<Integer, Integer> getReturnOpcode(Class<?> type) {
        if (Void.TYPE.equals(type)) {
            return Pair.of((Object)177, (Object)0);
        }
        if (Long.TYPE.equals(type)) {
            return Pair.of((Object)173, (Object)1);
        }
        if (Double.TYPE.equals(type)) {
            return Pair.of((Object)175, (Object)1);
        }
        if (Float.TYPE.equals(type)) {
            return Pair.of((Object)174, (Object)0);
        }
        if (type.isPrimitive()) {
            return Pair.of((Object)172, (Object)0);
        }
        return Pair.of((Object)176, (Object)0);
    }

    protected int getLoadOffset(Class<?> type) {
        if (type.isPrimitive() && (Long.TYPE.equals(type) || Double.TYPE.equals(type))) {
            return 2;
        }
        return 1;
    }

    protected int loadParams(MethodVisitor methodVisitor, Class<?>[] types) {
        int offset = 1;
        for (Class<?> type : types) {
            methodVisitor.visitVarInsn(this.getLoadOpcode(type), offset);
            offset += this.getLoadOffset(type);
        }
        return offset;
    }

    protected int loadOffset(Class<?>[] types) {
        int offset = 0;
        for (Class<?> type : types) {
            offset += this.getLoadOffset(type);
        }
        return offset;
    }

    protected boolean methodExists(Map<String, List<Class<?>[]>> methods, Method mtd, Class<?>[] types) {
        List list = methods.computeIfAbsent(mtd.getName(), k -> new ArrayList());
        for (Class[] t : list) {
            if (!this.paramsMatch(types, t)) continue;
            return true;
        }
        list.add(types);
        return false;
    }

    protected boolean paramsMatch(Class<?>[] types, Class<?>[] t) {
        if (t.length == types.length) {
            boolean match = true;
            for (int i = 0; i < t.length; ++i) {
                if (t[i].equals(types[i])) continue;
                match = false;
                break;
            }
            return match;
        }
        return false;
    }

    protected DynamicType.Builder<?> checkPath(DynamicType.Builder<?> type, Class<?> cls, Method mtd, String desc, Class<?>[] types, Class<?> ret, boolean isVoid) {
        ArrayDeque<Method> path = new ArrayDeque<Method>();
        this.findStartMethod(cls, mtd.getName(), types, path);
        if (!path.isEmpty()) {
            return this.handlePath(type, cls, mtd, desc, types, ret, isVoid, path);
        }
        return null;
    }

    protected Method findMethod(Class<?> cls, String name, Class<?>[] types) throws NoSuchMethodException {
        try {
            return cls.getDeclaredMethod(name, types);
        }
        catch (NoSuchMethodException ex) {
            if (Objects.nonNull(cls.getSuperclass())) {
                return this.findMethod(cls.getSuperclass(), name, types);
            }
            throw ex;
        }
    }

    protected boolean findStartMethod(Class<?> cls, String name, Class<?>[] types, Deque<Method> path) {
        boolean result = false;
        for (Method m : cls.getDeclaredMethods()) {
            if (!name.startsWith(m.getName())) continue;
            String left = name.substring(m.getName().length());
            if (left.isEmpty()) {
                if (!this.paramsMatch(m.getParameterTypes(), types)) continue;
                path.push(m);
                return true;
            }
            if (m.getParameterCount() != 0 || m.getReturnType().isPrimitive()) continue;
            result = this.findStartMethod(m.getReturnType(), this.calcGetterName(left), types, path);
            if (!path.isEmpty()) {
                path.push(m);
            }
            if (!result) continue;
            return result;
        }
        if (Objects.nonNull(cls.getSuperclass())) {
            result = this.findStartMethod(cls.getSuperclass(), name, types, path);
        }
        if (!result) {
            GenericDeclaration i;
            GenericDeclaration[] genericDeclarationArray = cls.getInterfaces();
            int n = genericDeclarationArray.length;
            for (int j = 0; j < n && !(result = this.findStartMethod((Class<?>)(i = genericDeclarationArray[j]), name, types, path)); ++j) {
            }
        }
        return result;
    }

    protected String calcGetterName(String value) {
        return "get" + Character.toUpperCase(value.charAt(0)) + value.substring(1);
    }

    protected static void defaultReturn(MethodVisitor methodVisitor, Class<?> ret) {
        if (ret.isPrimitive()) {
            if (ret.equals(Long.TYPE)) {
                methodVisitor.visitInsn(9);
                methodVisitor.visitInsn(173);
            } else if (ret.equals(Double.TYPE)) {
                methodVisitor.visitInsn(14);
                methodVisitor.visitInsn(175);
            } else if (ret.equals(Float.TYPE)) {
                methodVisitor.visitInsn(11);
                methodVisitor.visitInsn(174);
            } else {
                methodVisitor.visitInsn(3);
                methodVisitor.visitInsn(172);
            }
        } else {
            methodVisitor.visitInsn(1);
            methodVisitor.visitInsn(176);
        }
    }

    public Object proxy(Class cls, InvocationHandler handler) {
        if (cls.isInterface()) {
            return Proxy.newProxyInstance(cls.getClassLoader(), new Class[]{cls}, handler);
        }
        Object inst = CodeFactory.create((Class)proxies.computeIfAbsent(cls, k -> new ByteBuddy().subclass(k).defineField("handler", InvocationHandler.class, new ModifierContributor.ForField[]{Visibility.PUBLIC}).method((ElementMatcher)ElementMatchers.any()).intercept((Implementation)InvocationHandlerAdapter.toField((String)"handler")).make().load(k.getClassLoader()).getLoaded()), (Object[])new Object[0]);
        return Reflection.setFieldValue((Object)inst, (String)"handler", (Object)handler);
    }

    static {
        CodeFactory.registerCustomProxyClass(List.class, (cls, projections) -> obj -> new CodeProjectionProxyList((List)obj, projections));
        CodeFactory.registerCustomProxyClass(Set.class, (cls, projections) -> obj -> new CodeProjectionProxySet((Set)obj, projections));
    }

    protected static class EnableFramesComputing
    implements AsmVisitorWrapper {
        protected EnableFramesComputing() {
        }

        public final int mergeWriter(int flags) {
            return flags | 2;
        }

        public final int mergeReader(int flags) {
            return flags | 2;
        }

        public final ClassVisitor wrap(TypeDescription td, ClassVisitor cv, Implementation.Context ctx, TypePool tp, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int wflags, int rflags) {
            return cv;
        }
    }
}

