/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.compiler.plugin;

import com.sun.source.util.JavacTask;
import com.sun.source.util.Plugin;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import javax.annotation.processing.ProcessingEnvironment;
import net.binis.codegen.compiler.plugin.Lookup;
import net.binis.codegen.compiler.plugin.parser.CodeGenAttr;
import net.binis.codegen.compiler.plugin.parser.CodeGenParserFactory;
import net.binis.codegen.compiler.plugin.parser.CodeGenResolve;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.factory.ObjectFactory;
import net.binis.codegen.tools.Reflection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeGenCompilerPlugin
implements Plugin,
TaskListener {
    private static final Logger log = LoggerFactory.getLogger(CodeGenCompilerPlugin.class);
    private BasicJavacTask task;

    @Override
    public String getName() {
        return "BinisCodeGen";
    }

    @Override
    public void init(JavacTask task, String ... args) {
        this.task = (BasicJavacTask)task;
        task.addTaskListener(this);
        CodeFactory.forceRegisterType(Context.class, (ObjectFactory)CodeFactory.singleton((Object)this.task.getContext()), null);
        CodeFactory.forceRegisterType(JavacTask.class, (ObjectFactory)CodeFactory.singleton((Object)task), null);
        CodeFactory.unregisterType(ProcessingEnvironment.class);
        this.patchCompilerClasses(this.task.getContext());
    }

    private void patchCompilerClasses(Context context) {
        CodeGenAttr.instance(context);
        CodeGenResolve.instance(context);
    }

    @Override
    public void started(TaskEvent e) {
        switch (e.getKind()) {
            case PARSE: {
                CodeGenParserFactory factory = CodeGenParserFactory.instance(this.task.getContext());
                Reflection.setFieldValue((Object)JavaCompiler.instance(this.task.getContext()), (String)"parserFactory", (Object)factory);
                break;
            }
            case ANNOTATION_PROCESSING_ROUND: {
                if (Lookup._round.getAndIncrement() != 0) break;
                Lookup.analyzeAnnotations();
            }
        }
    }

    @Override
    public void finished(TaskEvent e) {
        switch (e.getKind()) {
            case PARSE: {
                e.getCompilationUnit().getTypeDecls().stream().filter(JCTree.JCClassDecl.class::isInstance).map(JCTree.JCClassDecl.class::cast).findFirst().ifPresent(type -> Lookup._parsed.put(e.getCompilationUnit().getPackage().getPackageName().toString() + "." + type.name.toString(), e.getCompilationUnit()));
                break;
            }
            case COMPILATION: {
                Lookup.clean();
            }
        }
    }
}

