/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.AccessPattern;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.binis.codegen.exception.ValidationFormException;
import net.binis.codegen.objects.Pair;
import net.binis.codegen.validation.Validatable;

public class CodeProxyBeanDeserializer<T>
extends JsonDeserializer<T>
implements ResolvableDeserializer,
ContextualDeserializer {
    private final JsonDeserializer<T> parent;
    private static final ThreadLocal<Pair<Integer, Pair<Integer, List<Validatable>>>> stack = ThreadLocal.withInitial(() -> Pair.of((Object)0, (Object)Pair.of((Object)Integer.MAX_VALUE, null)));

    public CodeProxyBeanDeserializer(JsonDeserializer<T> parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Pair<Integer, Pair<Integer, List<Validatable>>> pair = stack.get();
        try {
            LinkedList<Validatable> list;
            int level = (Integer)pair.getKey() + 1;
            pair.key((Object)level);
            Object result = this.parent.deserialize(p, ctxt);
            if (result instanceof Validatable && (Integer)((Pair)pair.getValue()).getKey() >= level) {
                list = (LinkedList<Validatable>)((Pair)pair.getValue()).getValue();
                if (Objects.isNull(list)) {
                    list = new LinkedList<Validatable>();
                    ((Pair)pair.getValue()).value(list);
                }
                if ((Integer)((Pair)pair.getValue()).getKey() > level) {
                    list.clear();
                    ((Pair)pair.getValue()).key((Object)level);
                }
                list.add((Validatable)result);
            }
            pair.key((Object)(--level));
            if (level == 0) {
                list = (List)((Pair)pair.getValue()).getValue();
                try {
                    if (Objects.nonNull(list) && !list.isEmpty() && (Integer)((Pair)pair.getValue()).getKey() == 1) {
                        if (list.size() == 1) {
                            ((Validatable)list.get(0)).validate();
                        } else {
                            LinkedHashMap<CallSite, List> errors = null;
                            for (int i = 0; i < list.size(); ++i) {
                                try {
                                    ((Validatable)list.get(i)).validate();
                                    continue;
                                }
                                catch (ValidationFormException ex) {
                                    if (Objects.isNull(errors)) {
                                        errors = new LinkedHashMap<CallSite, List>();
                                    }
                                    String prefix = "[" + i + "].";
                                    for (Map.Entry e : ex.getErrors().entrySet()) {
                                        List eList = (List)e.getValue();
                                        errors.put((CallSite)((Object)(prefix + (String)e.getKey())), eList);
                                        eList.replaceAll(s -> prefix + s);
                                    }
                                }
                            }
                            if (Objects.nonNull(errors)) {
                                throw new ValidationFormException(null, errors);
                            }
                        }
                    }
                }
                finally {
                    stack.remove();
                }
            }
            return (T)result;
        }
        catch (Exception ex) {
            stack.remove();
            throw ex;
        }
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt, T intoValue) throws IOException {
        return (T)this.parent.deserialize(p, ctxt, intoValue);
    }

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return this.parent.deserializeWithType(p, ctxt, typeDeserializer);
    }

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer, T intoValue) throws IOException {
        return this.parent.deserializeWithType(p, ctxt, typeDeserializer, intoValue);
    }

    public JsonDeserializer<T> unwrappingDeserializer(NameTransformer unwrapper) {
        return this.parent.unwrappingDeserializer(unwrapper);
    }

    public JsonDeserializer<?> replaceDelegatee(JsonDeserializer<?> delegatee) {
        return this.parent.replaceDelegatee(delegatee);
    }

    public Class<?> handledType() {
        return this.parent.handledType();
    }

    public LogicalType logicalType() {
        return this.parent.logicalType();
    }

    public boolean isCachable() {
        return this.parent.isCachable();
    }

    public JsonDeserializer<?> getDelegatee() {
        return this.parent.getDelegatee();
    }

    public Collection<Object> getKnownPropertyNames() {
        return this.parent.getKnownPropertyNames();
    }

    public T getNullValue(DeserializationContext ctxt) throws JsonMappingException {
        return (T)this.parent.getNullValue(ctxt);
    }

    public AccessPattern getNullAccessPattern() {
        return this.parent.getNullAccessPattern();
    }

    public Object getAbsentValue(DeserializationContext ctxt) throws JsonMappingException {
        return this.parent.getAbsentValue(ctxt);
    }

    public Object getEmptyValue(DeserializationContext ctxt) throws JsonMappingException {
        return this.parent.getEmptyValue(ctxt);
    }

    public AccessPattern getEmptyAccessPattern() {
        return this.parent.getEmptyAccessPattern();
    }

    public ObjectIdReader getObjectIdReader() {
        return this.parent.getObjectIdReader();
    }

    public SettableBeanProperty findBackReference(String refName) {
        return this.parent.findBackReference(refName);
    }

    public Boolean supportsUpdate(DeserializationConfig config) {
        return this.parent.supportsUpdate(config);
    }

    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        ((ResolvableDeserializer)this.parent).resolve(ctxt);
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        ((ContextualDeserializer)this.parent).createContextual(ctxt, property);
        return this;
    }
}

