/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.hibernate;

import jakarta.persistence.EnumType;
import java.util.Objects;
import java.util.UUID;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.objects.base.enumeration.CodeEnum;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;

public class CodeEnumJavaType<T extends CodeEnum>
extends AbstractClassJavaType<T> {
    public CodeEnumJavaType(Class<T> type) {
        super(type, (MutabilityPlan)ImmutableMutabilityPlan.instance());
    }

    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators context) {
        JdbcTypeRegistry registry = context.getTypeConfiguration().getJdbcTypeRegistry();
        if (context.getEnumeratedType() != null && context.getEnumeratedType() == EnumType.STRING) {
            if (context.getColumnLength() == 1L) {
                return context.isNationalized() ? registry.getDescriptor(-15) : registry.getDescriptor(1);
            }
            return context.isNationalized() ? registry.getDescriptor(-9) : registry.getDescriptor(12);
        }
        return registry.getDescriptor(4);
    }

    public String toString(T value) {
        return value == null ? "<null>" : value.name();
    }

    public T fromString(CharSequence string) {
        return (T)(string == null ? null : CodeFactory.enumValueOf((Class)this.getJavaTypeClass(), (String)string.toString()));
    }

    public <X> X unwrap(T value, Class<X> type, WrapperOptions options) {
        if (String.class.equals(type)) {
            return (X)this.toName(value);
        }
        if (Long.class.equals(type)) {
            return (X)this.toLong(value);
        }
        if (Integer.class.equals(type)) {
            return (X)this.toInteger(value);
        }
        if (Short.class.equals(type)) {
            return (X)this.toShort(value);
        }
        if (Byte.class.equals(type)) {
            return (X)this.toByte(value);
        }
        return (X)value;
    }

    public <X> T wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String v = (String)value;
            return this.fromName(v);
        }
        if (value instanceof Long) {
            Long v = (Long)value;
            return this.fromLong(v);
        }
        if (value instanceof Integer) {
            Integer v = (Integer)value;
            return this.fromInteger(v);
        }
        if (value instanceof Short) {
            Short v = (Short)value;
            return this.fromShort(v);
        }
        if (value instanceof Byte) {
            Byte v = (Byte)value;
            return this.fromByte(v);
        }
        return (T)((CodeEnum)value);
    }

    public Byte toByte(T domainForm) {
        if (domainForm == null) {
            return null;
        }
        return (byte)domainForm.ordinal();
    }

    public Short toShort(T domainForm) {
        if (domainForm == null) {
            return null;
        }
        return (short)domainForm.ordinal();
    }

    public Integer toInteger(T domainForm) {
        if (domainForm == null) {
            return null;
        }
        return domainForm.ordinal();
    }

    public Long toLong(T domainForm) {
        if (domainForm == null) {
            return null;
        }
        return domainForm.ordinal();
    }

    public Integer toOrdinal(T domainForm) {
        return this.toInteger(domainForm);
    }

    public T fromByte(Byte relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        return (T)((CodeEnum)CodeFactory.enumValuesMap((Class)this.getJavaTypeClass()).get(relationalForm.intValue()));
    }

    public T fromShort(Short relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        return (T)((CodeEnum)CodeFactory.enumValuesMap((Class)this.getJavaTypeClass()).get(relationalForm.intValue()));
    }

    public T fromInteger(Integer relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        CodeEnum result = CodeFactory.enumValueOf((Class)this.getJavaType(), (int)relationalForm);
        if (Objects.isNull(result)) {
            result = CodeFactory.initializeUnknownEnumValue((Class)this.getJavaType(), (String)UUID.randomUUID().toString(), (int)relationalForm, (Object[])new Object[0]);
        }
        return (T)result;
    }

    public T fromLong(Long relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        return (T)((CodeEnum)CodeFactory.enumValuesMap((Class)this.getJavaTypeClass()).get(relationalForm.intValue()));
    }

    public T fromOrdinal(Integer relationalForm) {
        return this.fromInteger(relationalForm);
    }

    public String toName(T domainForm) {
        if (domainForm == null) {
            return null;
        }
        return domainForm.name();
    }

    public T fromName(String relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        CodeEnum result = CodeFactory.enumValueOf((Class)this.getJavaType(), (String)relationalForm);
        if (Objects.isNull(result)) {
            result = CodeFactory.initializeUnknownEnumValue((Class)this.getJavaType(), (String)relationalForm, (int)Integer.MIN_VALUE, (Object[])new Object[0]);
        }
        return (T)result;
    }
}

