/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.hibernate;

import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.MapKeyEnumerated;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import net.binis.codegen.hibernate.CodeEnumJavaType;
import net.binis.codegen.objects.base.enumeration.CodeEnum;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.annotations.Nationalized;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.type.spi.TypeConfigurationAware;
import org.hibernate.usertype.DynamicParameterizedType;
import org.hibernate.usertype.EnhancedUserType;
import org.hibernate.usertype.LoggableUserType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeEnumType
implements EnhancedUserType<CodeEnum>,
DynamicParameterizedType,
LoggableUserType,
TypeConfigurationAware,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(CodeEnumType.class);
    public static final String ENUM = "enumClass";
    public static final String NAMED = "useNamed";
    public static final String TYPE = "type";
    private Class enumClass;
    private JdbcType jdbcType;
    private CodeEnumJavaType<CodeEnum> enumJavaType;
    private TypeConfiguration typeConfiguration;

    public Class getEnumClass() {
        return this.enumClass;
    }

    public JdbcType getJdbcType(TypeConfiguration typeConfiguration) {
        return this.jdbcType;
    }

    public void setParameterValues(Properties parameters) {
        DynamicParameterizedType.ParameterType reader = (DynamicParameterizedType.ParameterType)parameters.get("org.hibernate.type.ParameterType");
        if (parameters.containsKey(ENUM)) {
            String enumClassName = (String)parameters.get(ENUM);
            try {
                this.enumClass = ReflectHelper.classForName((String)enumClassName, this.getClass()).asSubclass(Enum.class);
            }
            catch (ClassNotFoundException exception) {
                throw new HibernateException("Enum class not found: " + enumClassName, (Throwable)exception);
            }
        } else if (reader != null) {
            this.enumClass = reader.getReturnedClass().asSubclass(CodeEnum.class);
        }
        this.enumJavaType = new CodeEnumJavaType(this.enumClass);
        if (parameters.containsKey(TYPE)) {
            int jdbcTypeCode = Integer.parseInt((String)parameters.get(TYPE));
            this.jdbcType = this.typeConfiguration.getJdbcTypeRegistry().getDescriptor(jdbcTypeCode);
        } else {
            Long columnLength;
            Long l = columnLength = reader == null ? null : reader.getColumnLengths()[0];
            LocalJdbcTypeIndicators indicators = parameters.containsKey(NAMED) ? new LocalJdbcTypeIndicators(ConfigurationHelper.getBoolean((String)NAMED, (Map)parameters) ? EnumType.STRING : EnumType.ORDINAL, false, columnLength) : new LocalJdbcTypeIndicators(this.getEnumType(reader), this.isNationalized(reader), columnLength);
            this.jdbcType = this.enumJavaType.getRecommendedJdbcType(indicators);
        }
        if (log.isDebugEnabled()) {
            log.debug("Using {}-based conversion for Enum {}", (Object)(this.isOrdinal() ? "ORDINAL" : "NAMED"), (Object)this.enumClass.getName());
        }
    }

    private EnumType getEnumType(DynamicParameterizedType.ParameterType reader) {
        if (reader != null) {
            MapKeyEnumerated enumAnn;
            if (reader.isPrimaryKey() && (enumAnn = this.getAnnotation(reader.getAnnotationsMethod(), MapKeyEnumerated.class)) != null) {
                return enumAnn.value();
            }
            enumAnn = this.getAnnotation(reader.getAnnotationsMethod(), Enumerated.class);
            if (enumAnn != null) {
                return enumAnn.value();
            }
        }
        return EnumType.ORDINAL;
    }

    private boolean isNationalized(DynamicParameterizedType.ParameterType reader) {
        return this.typeConfiguration.getCurrentBaseSqlTypeIndicators().isNationalized() || reader != null && this.getAnnotation(reader.getAnnotationsMethod(), Nationalized.class) != null;
    }

    private <A extends Annotation> A getAnnotation(Annotation[] annotations, Class<A> annotationType) {
        for (Annotation annotation : annotations) {
            if (!annotationType.isInstance(annotation)) continue;
            return (A)annotation;
        }
        return null;
    }

    public int getSqlType() {
        this.verifyConfigured();
        return this.jdbcType.getJdbcTypeCode();
    }

    public Class returnedClass() {
        return this.enumClass;
    }

    public boolean equals(CodeEnum x, CodeEnum y) throws HibernateException {
        return x == y;
    }

    public int hashCode(CodeEnum x) throws HibernateException {
        return x == null ? 0 : x.hashCode();
    }

    public CodeEnum nullSafeGet(ResultSet rs, int position, SharedSessionContractImplementor session, Object owner) throws SQLException {
        this.verifyConfigured();
        return (CodeEnum)this.jdbcType.getExtractor(this.enumJavaType).extract(rs, position, (WrapperOptions)session);
    }

    private void verifyConfigured() {
        if (this.enumJavaType == null) {
            throw new AssertionFailure("EnumType (" + this.enumClass.getName() + ") not properly, fully configured");
        }
    }

    public void nullSafeSet(PreparedStatement st, CodeEnum value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        this.verifyConfigured();
        this.jdbcType.getBinder(this.enumJavaType).bind(st, (Object)value, index, (WrapperOptions)session);
    }

    public CodeEnum deepCopy(CodeEnum value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(CodeEnum value) throws HibernateException {
        return null;
    }

    public CodeEnum assemble(Serializable cached, Object owner) throws HibernateException {
        return (CodeEnum)cached;
    }

    public CodeEnum replace(CodeEnum original, CodeEnum target, Object owner) throws HibernateException {
        return original;
    }

    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    public void setTypeConfiguration(TypeConfiguration typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
    }

    public String toSqlLiteral(CodeEnum value) {
        this.verifyConfigured();
        return this.isOrdinal() ? Integer.toString(value.ordinal()) : "'" + value.name() + "'";
    }

    public String toString(CodeEnum value) {
        this.verifyConfigured();
        return this.enumJavaType.toName(value);
    }

    public CodeEnum fromStringValue(CharSequence sequence) {
        this.verifyConfigured();
        return this.enumJavaType.fromName(sequence.toString());
    }

    public String toLoggableString(Object value, SessionFactoryImplementor factory) {
        this.verifyConfigured();
        return this.enumJavaType.toString((CodeEnum)value);
    }

    public boolean isOrdinal() {
        this.verifyConfigured();
        return this.jdbcType.isInteger();
    }

    private class LocalJdbcTypeIndicators
    implements JdbcTypeIndicators {
        private final EnumType enumType;
        private final boolean nationalized;
        private final Long columnLength;

        private LocalJdbcTypeIndicators(EnumType enumType, boolean nationalized, Long columnLength) {
            this.enumType = enumType;
            this.nationalized = nationalized;
            this.columnLength = columnLength;
        }

        public TypeConfiguration getTypeConfiguration() {
            return CodeEnumType.this.typeConfiguration;
        }

        public EnumType getEnumeratedType() {
            return this.enumType != null ? this.enumType : CodeEnumType.this.typeConfiguration.getCurrentBaseSqlTypeIndicators().getEnumeratedType();
        }

        public boolean isNationalized() {
            return this.nationalized;
        }

        public long getColumnLength() {
            return this.columnLength == null ? -1L : this.columnLength;
        }

        public Dialect getDialect() {
            return CodeEnumType.this.typeConfiguration.getCurrentBaseSqlTypeIndicators().getDialect();
        }
    }
}

