/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.hibernate;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Locale;
import net.binis.codegen.hibernate.CodeEnumJavaType;
import net.binis.codegen.hibernate.CodeEnumValueConverter;
import net.binis.codegen.objects.base.enumeration.CodeEnum;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class NamedCodeEnumValueConverter<E extends CodeEnum>
implements CodeEnumValueConverter<E, String>,
Serializable {
    private final CodeEnumJavaType<E> domainTypeDescriptor;
    private final JdbcType jdbcType;
    private final JavaType<String> relationalTypeDescriptor;
    private transient ValueExtractor<String> valueExtractor;
    private transient ValueBinder<String> valueBinder;

    public NamedCodeEnumValueConverter(CodeEnumJavaType<E> domainTypeDescriptor, JdbcType jdbcType, JavaType<String> relationalTypeDescriptor) {
        this.domainTypeDescriptor = domainTypeDescriptor;
        this.jdbcType = jdbcType;
        this.relationalTypeDescriptor = relationalTypeDescriptor;
        this.valueExtractor = jdbcType.getExtractor(relationalTypeDescriptor);
        this.valueBinder = jdbcType.getBinder(relationalTypeDescriptor);
    }

    @Override
    public CodeEnumJavaType<E> getDomainJavaType() {
        return this.domainTypeDescriptor;
    }

    public JavaType<String> getRelationalJavaType() {
        return this.relationalTypeDescriptor;
    }

    public E toDomainValue(String relationalForm) {
        return this.domainTypeDescriptor.fromName(relationalForm);
    }

    public String toRelationalValue(E domainForm) {
        return this.domainTypeDescriptor.toName(domainForm);
    }

    @Override
    public int getJdbcTypeCode() {
        return this.jdbcType.getJdbcTypeCode();
    }

    public int getDefaultSqlTypeCode() {
        return this.jdbcType.getDefaultSqlTypeCode();
    }

    @Override
    public String toSqlLiteral(Object value) {
        return String.format(Locale.ROOT, "'%s'", ((CodeEnum)value).name());
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        stream.defaultReadObject();
        this.valueExtractor = this.jdbcType.getExtractor(this.relationalTypeDescriptor);
        this.valueBinder = this.jdbcType.getBinder(this.relationalTypeDescriptor);
    }

    @Override
    public void writeValue(PreparedStatement statement, E value, int position, SharedSessionContractImplementor session) throws SQLException {
        String jdbcValue = value == null ? null : value.name();
        this.valueBinder.bind(statement, (Object)jdbcValue, position, (WrapperOptions)session);
    }
}

