/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.hibernate;

import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.MapKeyEnumerated;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import net.binis.codegen.hibernate.CodeEnumJavaType;
import net.binis.codegen.hibernate.CodeEnumValueConverter;
import net.binis.codegen.hibernate.NamedCodeEnumValueConverter;
import net.binis.codegen.hibernate.OrdinalCodeEnumValueConverter;
import net.binis.codegen.objects.base.enumeration.CodeEnum;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.annotations.Nationalized;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.converter.internal.OrdinalEnumValueConverter;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.type.spi.TypeConfigurationAware;
import org.hibernate.usertype.DynamicParameterizedType;
import org.hibernate.usertype.EnhancedUserType;
import org.hibernate.usertype.LoggableUserType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeEnumType
implements EnhancedUserType<CodeEnum>,
DynamicParameterizedType,
LoggableUserType,
TypeConfigurationAware,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(CodeEnumType.class);
    public static final String ENUM = "enumClass";
    public static final String NAMED = "useNamed";
    public static final String TYPE = "type";
    private Class enumClass;
    private CodeEnumValueConverter enumValueConverter;
    private JdbcType jdbcType;
    private ValueExtractor<Object> jdbcValueExtractor;
    private ValueBinder<Object> jdbcValueBinder;
    private TypeConfiguration typeConfiguration;

    public CodeEnumType() {
    }

    public CodeEnumType(Class<CodeEnum> enumClass, CodeEnumValueConverter enumValueConverter, TypeConfiguration typeConfiguration) {
        this.enumClass = enumClass;
        this.typeConfiguration = typeConfiguration;
        this.enumValueConverter = enumValueConverter;
        this.jdbcType = typeConfiguration.getJdbcTypeRegistry().getDescriptor(enumValueConverter.getJdbcTypeCode());
        this.jdbcValueExtractor = this.jdbcType.getExtractor(enumValueConverter.getRelationalJavaType());
        this.jdbcValueBinder = this.jdbcType.getBinder(enumValueConverter.getRelationalJavaType());
    }

    public CodeEnumValueConverter getEnumValueConverter() {
        return this.enumValueConverter;
    }

    public JdbcType getJdbcType(TypeConfiguration typeConfiguration) {
        return this.jdbcType;
    }

    public BasicValueConverter<CodeEnum, Object> getValueConverter() {
        return this.enumValueConverter;
    }

    public void setParameterValues(Properties parameters) {
        DynamicParameterizedType.ParameterType reader = (DynamicParameterizedType.ParameterType)parameters.get("org.hibernate.type.ParameterType");
        if (reader != null) {
            boolean isOrdinal;
            this.enumClass = reader.getReturnedClass().asSubclass(CodeEnum.class);
            Long columnLength = reader.getColumnLengths()[0];
            EnumType enumType = this.getEnumType(reader);
            if (enumType == null) {
                isOrdinal = true;
            } else if (EnumType.ORDINAL.equals((Object)enumType)) {
                isOrdinal = true;
            } else if (EnumType.STRING.equals((Object)enumType)) {
                isOrdinal = false;
            } else {
                throw new AssertionFailure("Unknown EnumType: " + enumType);
            }
            JavaType type = this.typeConfiguration.getJavaTypeRegistry().getDescriptor((Type)this.enumClass);
            if (!(type instanceof CodeEnumJavaType)) {
                this.typeConfiguration.getJavaTypeRegistry().addDescriptor(new CodeEnumJavaType(this.enumClass));
            }
            CodeEnumJavaType enumJavaType = (CodeEnumJavaType)this.typeConfiguration.getJavaTypeRegistry().getDescriptor((Type)this.enumClass);
            LocalJdbcTypeIndicators indicators = new LocalJdbcTypeIndicators(enumType, columnLength, reader);
            JavaType<? extends Number> relationalJavaType = this.resolveRelationalJavaType(indicators, enumJavaType);
            this.jdbcType = relationalJavaType.getRecommendedJdbcType((JdbcTypeIndicators)indicators);
            this.enumValueConverter = isOrdinal ? new OrdinalCodeEnumValueConverter(enumJavaType, this.jdbcType, relationalJavaType) : new NamedCodeEnumValueConverter(enumJavaType, this.jdbcType, relationalJavaType);
        } else {
            String enumClassName = (String)parameters.get(ENUM);
            try {
                this.enumClass = ReflectHelper.classForName((String)enumClassName, this.getClass()).asSubclass(Enum.class);
            }
            catch (ClassNotFoundException exception) {
                throw new HibernateException("Enum class not found: " + enumClassName, (Throwable)exception);
            }
            this.enumValueConverter = this.interpretParameters(parameters);
            this.jdbcType = this.typeConfiguration.getJdbcTypeRegistry().getDescriptor(this.enumValueConverter.getJdbcTypeCode());
        }
        this.jdbcValueExtractor = this.jdbcType.getExtractor(this.enumValueConverter.getRelationalJavaType());
        this.jdbcValueBinder = this.jdbcType.getBinder(this.enumValueConverter.getRelationalJavaType());
        log.debug("Using {}-based conversion for Enum {}", (Object)(this.isOrdinal() ? "ORDINAL" : "NAMED"), (Object)this.enumClass.getName());
    }

    private JavaType<? extends Number> resolveRelationalJavaType(LocalJdbcTypeIndicators indicators, CodeEnumJavaType<?> enumJavaType) {
        return enumJavaType.getRecommendedJdbcType(indicators).getJdbcRecommendedJavaTypeMapping(null, null, this.typeConfiguration);
    }

    private EnumType getEnumType(DynamicParameterizedType.ParameterType reader) {
        MapKeyEnumerated enumAnn;
        if (reader == null) {
            return null;
        }
        if (reader.isPrimaryKey() && (enumAnn = this.getAnnotation(reader.getAnnotationsMethod(), MapKeyEnumerated.class)) != null) {
            return enumAnn.value();
        }
        enumAnn = this.getAnnotation(reader.getAnnotationsMethod(), Enumerated.class);
        if (enumAnn != null) {
            return enumAnn.value();
        }
        return null;
    }

    private <A extends Annotation> A getAnnotation(Annotation[] annotations, Class<A> anClass) {
        for (Annotation annotation : annotations) {
            if (!anClass.isInstance(annotation)) continue;
            return (A)annotation;
        }
        return null;
    }

    private CodeEnumValueConverter interpretParameters(Properties parameters) {
        CodeEnumJavaType enumJavaType = (CodeEnumJavaType)this.typeConfiguration.getJavaTypeRegistry().getDescriptor((Type)this.enumClass);
        assert (parameters.get("org.hibernate.type.ParameterType") == null);
        LocalJdbcTypeIndicators localIndicators = new LocalJdbcTypeIndicators(EnumType.ORDINAL, -1L, null);
        BasicJavaType stringJavaType = (BasicJavaType)this.typeConfiguration.getJavaTypeRegistry().getDescriptor(String.class);
        BasicJavaType integerJavaType = (BasicJavaType)this.typeConfiguration.getJavaTypeRegistry().getDescriptor(Integer.class);
        if (parameters.containsKey(NAMED)) {
            boolean useNamed = ConfigurationHelper.getBoolean((String)NAMED, (Map)parameters);
            if (useNamed) {
                return new NamedCodeEnumValueConverter(enumJavaType, stringJavaType.getRecommendedJdbcType((JdbcTypeIndicators)localIndicators), (JavaType<String>)stringJavaType);
            }
            return new OrdinalCodeEnumValueConverter(enumJavaType, integerJavaType.getRecommendedJdbcType((JdbcTypeIndicators)localIndicators), (JavaType<Number>)this.typeConfiguration.getJavaTypeRegistry().getDescriptor(Integer.class));
        }
        if (parameters.containsKey(TYPE)) {
            int type = Integer.decode((String)parameters.get(TYPE));
            if (this.isNumericType(type)) {
                return new OrdinalCodeEnumValueConverter(enumJavaType, integerJavaType.getRecommendedJdbcType((JdbcTypeIndicators)localIndicators), (JavaType<Number>)this.typeConfiguration.getJavaTypeRegistry().getDescriptor(Integer.class));
            }
            if (this.isCharacterType(type)) {
                return new NamedCodeEnumValueConverter(enumJavaType, stringJavaType.getRecommendedJdbcType((JdbcTypeIndicators)localIndicators), (JavaType<String>)stringJavaType);
            }
            throw new HibernateException(String.format(Locale.ENGLISH, "Passed JDBC type code [%s] not recognized as numeric nor character", type));
        }
        return new OrdinalCodeEnumValueConverter(enumJavaType, integerJavaType.getRecommendedJdbcType((JdbcTypeIndicators)localIndicators), (JavaType<Number>)this.typeConfiguration.getJavaTypeRegistry().getDescriptor(Integer.class));
    }

    private boolean isCharacterType(int jdbcTypeCode) {
        switch (jdbcTypeCode) {
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private boolean isNumericType(int jdbcTypeCode) {
        switch (jdbcTypeCode) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public int getSqlType() {
        this.verifyConfigured();
        return this.enumValueConverter.getJdbcTypeCode();
    }

    public Class<CodeEnum> returnedClass() {
        return this.enumClass;
    }

    public boolean equals(CodeEnum x, CodeEnum y) throws HibernateException {
        return x == y;
    }

    public int hashCode(CodeEnum x) throws HibernateException {
        return x == null ? 0 : x.hashCode();
    }

    public CodeEnum nullSafeGet(ResultSet rs, int position, SharedSessionContractImplementor session, Object owner) throws SQLException {
        this.verifyConfigured();
        Object relational = this.jdbcValueExtractor.extract(rs, position, (WrapperOptions)session);
        return (CodeEnum)this.enumValueConverter.toDomainValue(relational);
    }

    private void verifyConfigured() {
        if (this.enumValueConverter == null || this.jdbcValueBinder == null || this.jdbcValueExtractor == null) {
            throw new AssertionFailure("EnumType (" + this.enumClass.getName() + ") not properly, fully configured");
        }
    }

    public void nullSafeSet(PreparedStatement st, CodeEnum value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        this.verifyConfigured();
        this.jdbcValueBinder.bind(st, this.enumValueConverter.toRelationalValue(value), index, (WrapperOptions)session);
    }

    public CodeEnum deepCopy(CodeEnum value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(CodeEnum value) throws HibernateException {
        return (Serializable)this.enumValueConverter.toRelationalValue(value);
    }

    public CodeEnum assemble(Serializable cached, Object owner) throws HibernateException {
        return (CodeEnum)this.enumValueConverter.toDomainValue(cached);
    }

    public CodeEnum replace(CodeEnum original, CodeEnum target, Object owner) throws HibernateException {
        return original;
    }

    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    public void setTypeConfiguration(TypeConfiguration typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
    }

    public String toSqlLiteral(CodeEnum value) {
        this.verifyConfigured();
        return this.enumValueConverter.toSqlLiteral(value);
    }

    public String toString(CodeEnum value) {
        this.verifyConfigured();
        return this.enumValueConverter.getRelationalJavaType().toString(this.enumValueConverter.toRelationalValue(value));
    }

    public CodeEnum fromStringValue(CharSequence sequence) {
        this.verifyConfigured();
        return (CodeEnum)this.enumValueConverter.toDomainValue(this.enumValueConverter.getRelationalJavaType().fromString(sequence));
    }

    public String toLoggableString(Object value, SessionFactoryImplementor factory) {
        this.verifyConfigured();
        return this.enumValueConverter.getDomainJavaType().toString((CodeEnum)value);
    }

    public boolean isOrdinal() {
        this.verifyConfigured();
        return this.enumValueConverter instanceof OrdinalEnumValueConverter;
    }

    private class LocalJdbcTypeIndicators
    implements JdbcTypeIndicators {
        private final EnumType enumType;
        private final Long columnLength;
        private final DynamicParameterizedType.ParameterType reader;

        public LocalJdbcTypeIndicators(EnumType enumType, Long columnLength, DynamicParameterizedType.ParameterType reader) {
            this.enumType = enumType;
            this.columnLength = columnLength;
            this.reader = reader;
        }

        public TypeConfiguration getTypeConfiguration() {
            return CodeEnumType.this.typeConfiguration;
        }

        public Dialect getDialect() {
            return CodeEnumType.this.typeConfiguration.getCurrentBaseSqlTypeIndicators().getDialect();
        }

        public EnumType getEnumeratedType() {
            if (this.enumType != null) {
                return this.enumType;
            }
            return CodeEnumType.this.typeConfiguration.getCurrentBaseSqlTypeIndicators().getEnumeratedType();
        }

        public boolean isNationalized() {
            return this.isNationalized(this.reader);
        }

        private boolean isNationalized(DynamicParameterizedType.ParameterType reader) {
            if (CodeEnumType.this.typeConfiguration.getCurrentBaseSqlTypeIndicators().isNationalized()) {
                return true;
            }
            if (reader != null) {
                for (Annotation annotation : reader.getAnnotationsMethod()) {
                    if (!(annotation instanceof Nationalized)) continue;
                    return true;
                }
            }
            return false;
        }

        public long getColumnLength() {
            return this.columnLength == null ? -1L : this.columnLength;
        }
    }
}

