/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.hibernate;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.binis.codegen.hibernate.CodeEnumJavaType;
import net.binis.codegen.hibernate.CodeEnumValueConverter;
import net.binis.codegen.objects.base.enumeration.CodeEnum;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class OrdinalCodeEnumValueConverter<E extends CodeEnum>
implements CodeEnumValueConverter<E, Number>,
Serializable {
    private final CodeEnumJavaType<E> enumJavaType;
    private final JdbcType jdbcType;
    private final JavaType<Number> relationalJavaType;
    private transient ValueExtractor<Number> valueExtractor;
    private transient ValueBinder<Number> valueBinder;

    public OrdinalCodeEnumValueConverter(CodeEnumJavaType<E> enumJavaType, JdbcType jdbcType, JavaType<Number> relationalJavaType) {
        this.enumJavaType = enumJavaType;
        this.jdbcType = jdbcType;
        this.relationalJavaType = relationalJavaType;
        this.valueExtractor = jdbcType.getExtractor(relationalJavaType);
        this.valueBinder = jdbcType.getBinder(relationalJavaType);
    }

    public E toDomainValue(Number relationalForm) {
        return this.enumJavaType.fromOrdinal(relationalForm == null ? null : Integer.valueOf(relationalForm.intValue()));
    }

    public Number toRelationalValue(E domainForm) {
        return this.enumJavaType.toOrdinal(domainForm);
    }

    @Override
    public int getJdbcTypeCode() {
        return this.jdbcType.getJdbcTypeCode();
    }

    @Override
    public CodeEnumJavaType<E> getDomainJavaType() {
        return this.enumJavaType;
    }

    public JavaType<Number> getRelationalJavaType() {
        return this.relationalJavaType;
    }

    @Override
    public String toSqlLiteral(Object value) {
        return Integer.toString(((CodeEnum)value).ordinal());
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        stream.defaultReadObject();
        this.valueExtractor = this.jdbcType.getExtractor(this.relationalJavaType);
        this.valueBinder = this.jdbcType.getBinder(this.relationalJavaType);
    }

    @Override
    public void writeValue(PreparedStatement statement, E value, int position, SharedSessionContractImplementor session) throws SQLException {
        this.valueBinder.bind(statement, (Object)this.toRelationalValue(value), position, (WrapperOptions)session);
    }
}

