/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.hibernate;

import java.util.Objects;
import java.util.UUID;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.objects.base.enumeration.CodeEnum;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptorRegistry;
import org.hibernate.type.descriptor.java.MutabilityPlan;

public class CodeEnumJavaTypeDescriptor<T extends CodeEnum>
extends AbstractTypeDescriptor<T> {
    public CodeEnumJavaTypeDescriptor(Class<T> type) {
        super(type, (MutabilityPlan)ImmutableMutabilityPlan.INSTANCE);
        JavaTypeDescriptorRegistry.INSTANCE.addDescriptor((JavaTypeDescriptor)this);
    }

    public String toString(T value) {
        return value == null ? "<null>" : value.name();
    }

    public T fromString(String string) {
        return (T)(string == null ? null : CodeFactory.enumValueOf((Class)this.getJavaType(), (String)string));
    }

    public <X> X unwrap(T value, Class<X> type, WrapperOptions options) {
        if (String.class.equals(type)) {
            return (X)this.toName(value);
        }
        if (Integer.class.isInstance(type)) {
            return (X)this.toOrdinal((CodeEnum)value);
        }
        return (X)value;
    }

    public <X> T wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (String.class.isInstance(value)) {
            return this.fromName((String)value);
        }
        if (Integer.class.isInstance(value)) {
            return (T)this.fromOrdinal((Integer)value);
        }
        return (T)((CodeEnum)value);
    }

    public <E extends CodeEnum> Integer toOrdinal(E domainForm) {
        if (domainForm == null) {
            return null;
        }
        return domainForm.ordinal();
    }

    public <E extends CodeEnum> E fromOrdinal(Integer relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        CodeEnum result = CodeFactory.enumValueOf((Class)this.getJavaType(), (int)relationalForm);
        if (Objects.isNull(result)) {
            result = CodeFactory.initializeUnknownEnumValue((Class)this.getJavaType(), (String)UUID.randomUUID().toString(), (int)relationalForm, (Object[])new Object[0]);
        }
        return (E)result;
    }

    public T fromName(String relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        CodeEnum result = CodeFactory.enumValueOf((Class)this.getJavaType(), (String)relationalForm);
        if (Objects.isNull(result)) {
            result = CodeFactory.initializeUnknownEnumValue((Class)this.getJavaType(), (String)relationalForm, (int)Integer.MIN_VALUE, (Object[])new Object[0]);
        }
        return (T)result;
    }

    public String toName(T domainForm) {
        if (domainForm == null) {
            return null;
        }
        return domainForm.name();
    }
}

