/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.hibernate;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.binis.codegen.hibernate.CodeEnumJavaTypeDescriptor;
import net.binis.codegen.hibernate.CodeEnumValueConverter;
import net.binis.codegen.objects.base.enumeration.CodeEnum;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.IntegerTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class OrdinalCodeEnumValueConverter<E extends CodeEnum>
implements CodeEnumValueConverter<E, Integer>,
Serializable {
    private final CodeEnumJavaTypeDescriptor<E> enumJavaDescriptor;
    private transient ValueExtractor<E> valueExtractor;
    private transient ValueBinder<Integer> valueBinder;

    public OrdinalCodeEnumValueConverter(CodeEnumJavaTypeDescriptor<E> enumJavaDescriptor) {
        this.enumJavaDescriptor = enumJavaDescriptor;
        this.valueExtractor = OrdinalCodeEnumValueConverter.createValueExtractor(enumJavaDescriptor);
        this.valueBinder = OrdinalCodeEnumValueConverter.createValueBinder();
    }

    public E toDomainValue(Integer relationalForm) {
        return this.enumJavaDescriptor.fromOrdinal(relationalForm);
    }

    public Integer toRelationalValue(E domainForm) {
        return this.enumJavaDescriptor.toOrdinal(domainForm);
    }

    @Override
    public int getJdbcTypeCode() {
        return 4;
    }

    @Override
    public CodeEnumJavaTypeDescriptor<E> getJavaDescriptor() {
        return this.enumJavaDescriptor;
    }

    @Override
    public E readValue(ResultSet resultSet, String name, SharedSessionContractImplementor session) throws SQLException {
        return (E)((CodeEnum)this.valueExtractor.extract(resultSet, name, (WrapperOptions)session));
    }

    @Override
    public void writeValue(PreparedStatement statement, E value, int position, SharedSessionContractImplementor session) throws SQLException {
        Integer jdbcValue = value == null ? null : this.toRelationalValue(value);
        this.valueBinder.bind(statement, (Object)jdbcValue, position, (WrapperOptions)session);
    }

    @Override
    public String toSqlLiteral(Object value) {
        return Integer.toString(((CodeEnum)value).ordinal());
    }

    private static <T extends CodeEnum> ValueExtractor<T> createValueExtractor(CodeEnumJavaTypeDescriptor<T> enumJavaDescriptor) {
        return org.hibernate.type.descriptor.sql.IntegerTypeDescriptor.INSTANCE.getExtractor(enumJavaDescriptor);
    }

    private static ValueBinder<Integer> createValueBinder() {
        return org.hibernate.type.descriptor.sql.IntegerTypeDescriptor.INSTANCE.getBinder((JavaTypeDescriptor)IntegerTypeDescriptor.INSTANCE);
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        stream.defaultReadObject();
        this.valueExtractor = OrdinalCodeEnumValueConverter.createValueExtractor(this.enumJavaDescriptor);
        this.valueBinder = OrdinalCodeEnumValueConverter.createValueBinder();
    }
}

