/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.hibernate;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.MapKeyEnumerated;
import net.binis.codegen.hibernate.CodeEnumJavaTypeDescriptor;
import net.binis.codegen.hibernate.CodeEnumValueConverter;
import net.binis.codegen.hibernate.NamedCodeEnumValueConverter;
import net.binis.codegen.hibernate.OrdinalCodeEnumValueConverter;
import net.binis.codegen.objects.base.enumeration.CodeEnum;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.metamodel.model.convert.internal.OrdinalEnumValueConverter;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.type.spi.TypeConfigurationAware;
import org.hibernate.usertype.DynamicParameterizedType;
import org.hibernate.usertype.EnhancedUserType;
import org.hibernate.usertype.LoggableUserType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeEnumType<T extends CodeEnum>
implements EnhancedUserType,
DynamicParameterizedType,
LoggableUserType,
TypeConfigurationAware,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(CodeEnumType.class);
    public static final String ENUM = "enumClass";
    public static final String NAMED = "useNamed";
    public static final String TYPE = "type";
    private Class enumClass;
    private CodeEnumValueConverter enumValueConverter;
    private TypeConfiguration typeConfiguration;

    public void setParameterValues(Properties parameters) {
        DynamicParameterizedType.ParameterType reader = (DynamicParameterizedType.ParameterType)parameters.get("org.hibernate.type.ParameterType");
        if (reader != null) {
            boolean isOrdinal;
            this.enumClass = reader.getReturnedClass().asSubclass(CodeEnum.class);
            EnumType enumType = this.getEnumType(reader);
            if (enumType == null) {
                isOrdinal = true;
            } else if (EnumType.ORDINAL.equals((Object)enumType)) {
                isOrdinal = true;
            } else if (EnumType.STRING.equals((Object)enumType)) {
                isOrdinal = false;
            } else {
                throw new AssertionFailure("Unknown EnumType: " + enumType);
            }
            Object descriptor = this.typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(this.enumClass);
            if (!(descriptor instanceof CodeEnumJavaTypeDescriptor)) {
                descriptor = new CodeEnumJavaTypeDescriptor(this.enumClass);
            }
            CodeEnumJavaTypeDescriptor enumJavaDescriptor = (CodeEnumJavaTypeDescriptor)((Object)descriptor);
            this.enumValueConverter = isOrdinal ? new OrdinalCodeEnumValueConverter(enumJavaDescriptor) : new NamedCodeEnumValueConverter(enumJavaDescriptor);
        } else {
            String enumClassName = (String)parameters.get(ENUM);
            try {
                this.enumClass = ReflectHelper.classForName((String)enumClassName, this.getClass()).asSubclass(Enum.class);
            }
            catch (ClassNotFoundException exception) {
                throw new HibernateException("Enum class not found: " + enumClassName, (Throwable)exception);
            }
            this.enumValueConverter = this.interpretParameters(parameters);
        }
        log.debug("Using {}-based conversion for CodeEnum {}", (Object)(this.isOrdinal() ? "ORDINAL" : "NAMED"), (Object)this.enumClass.getName());
    }

    private EnumType getEnumType(DynamicParameterizedType.ParameterType reader) {
        EnumType enumType = null;
        if (reader.isPrimaryKey()) {
            MapKeyEnumerated enumAnn = this.getAnnotation(reader.getAnnotationsMethod(), MapKeyEnumerated.class);
            if (enumAnn != null) {
                enumType = enumAnn.value();
            }
        } else {
            Enumerated enumAnn = this.getAnnotation(reader.getAnnotationsMethod(), Enumerated.class);
            if (enumAnn != null) {
                enumType = enumAnn.value();
            }
        }
        return enumType;
    }

    private <A extends Annotation> A getAnnotation(Annotation[] annotations, Class<A> anClass) {
        for (Annotation annotation : annotations) {
            if (!anClass.isInstance(annotation)) continue;
            return (A)annotation;
        }
        return null;
    }

    private CodeEnumValueConverter interpretParameters(Properties parameters) {
        CodeEnumJavaTypeDescriptor javaTypeDescriptor = (CodeEnumJavaTypeDescriptor)this.typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(this.enumClass);
        if (parameters.containsKey(NAMED)) {
            boolean useNamed = ConfigurationHelper.getBoolean((String)NAMED, (Map)parameters);
            if (useNamed) {
                return new NamedCodeEnumValueConverter(javaTypeDescriptor);
            }
            return new OrdinalCodeEnumValueConverter(javaTypeDescriptor);
        }
        if (parameters.containsKey(TYPE)) {
            int type = Integer.decode((String)parameters.get(TYPE));
            if (this.isNumericType(type)) {
                return new OrdinalCodeEnumValueConverter(javaTypeDescriptor);
            }
            if (this.isCharacterType(type)) {
                return new NamedCodeEnumValueConverter(javaTypeDescriptor);
            }
            throw new HibernateException(String.format(Locale.ENGLISH, "Passed JDBC type code [%s] not recognized as numeric nor character", type));
        }
        return new OrdinalCodeEnumValueConverter(javaTypeDescriptor);
    }

    private boolean isCharacterType(int jdbcTypeCode) {
        switch (jdbcTypeCode) {
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private boolean isNumericType(int jdbcTypeCode) {
        switch (jdbcTypeCode) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public int[] sqlTypes() {
        this.verifyConfigured();
        return new int[]{this.enumValueConverter.getJdbcTypeCode()};
    }

    public Class<? extends CodeEnum> returnedClass() {
        return this.enumClass;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y;
    }

    public int hashCode(Object x) throws HibernateException {
        return x == null ? 0 : x.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws SQLException {
        this.verifyConfigured();
        return this.enumValueConverter.readValue(rs, names[0], session);
    }

    private void verifyConfigured() {
        if (this.enumValueConverter == null) {
            throw new AssertionFailure("EnumType (" + this.enumClass.getName() + ") not properly, fully configured");
        }
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        this.verifyConfigured();
        this.enumValueConverter.writeValue(st, (CodeEnum)value, index, session);
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    public void setTypeConfiguration(TypeConfiguration typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
    }

    public String objectToSQLString(Object value) {
        this.verifyConfigured();
        return this.enumValueConverter.toSqlLiteral(value);
    }

    public String toXMLString(Object value) {
        this.verifyConfigured();
        return this.enumValueConverter.getJavaDescriptor().unwrap((CodeEnum)value, String.class, null);
    }

    public Object fromXMLString(String xmlValue) {
        this.verifyConfigured();
        return this.enumValueConverter.getJavaDescriptor().wrap(xmlValue, (WrapperOptions)null);
    }

    public String toLoggableString(Object value, SessionFactoryImplementor factory) {
        this.verifyConfigured();
        return this.enumValueConverter.getJavaDescriptor().toString((CodeEnum)value);
    }

    public boolean isOrdinal() {
        this.verifyConfigured();
        return this.enumValueConverter instanceof OrdinalEnumValueConverter;
    }
}

