/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.hibernate;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import net.binis.codegen.hibernate.CodeEnumJavaTypeDescriptor;
import net.binis.codegen.hibernate.CodeEnumValueConverter;
import net.binis.codegen.objects.base.enumeration.CodeEnum;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.StringTypeDescriptor;
import org.hibernate.type.descriptor.sql.VarcharTypeDescriptor;

public class NamedCodeEnumValueConverter<E extends CodeEnum>
implements CodeEnumValueConverter<E, String>,
Serializable {
    private final CodeEnumJavaTypeDescriptor<E> enumJavaDescriptor;
    private transient ValueExtractor<E> valueExtractor;
    private transient ValueBinder<String> valueBinder;

    public NamedCodeEnumValueConverter(CodeEnumJavaTypeDescriptor<E> enumJavaDescriptor) {
        this.enumJavaDescriptor = enumJavaDescriptor;
        this.valueExtractor = NamedCodeEnumValueConverter.createValueExtractor(enumJavaDescriptor);
        this.valueBinder = NamedCodeEnumValueConverter.createValueBinder();
    }

    public E toDomainValue(String relationalForm) {
        return this.enumJavaDescriptor.fromName(relationalForm);
    }

    public String toRelationalValue(E domainForm) {
        return this.enumJavaDescriptor.toName(domainForm);
    }

    @Override
    public int getJdbcTypeCode() {
        return 12;
    }

    @Override
    public CodeEnumJavaTypeDescriptor<E> getJavaDescriptor() {
        return this.enumJavaDescriptor;
    }

    @Override
    public E readValue(ResultSet resultSet, String name, SharedSessionContractImplementor session) throws SQLException {
        return (E)((CodeEnum)this.valueExtractor.extract(resultSet, name, (WrapperOptions)session));
    }

    @Override
    public void writeValue(PreparedStatement statement, E value, int position, SharedSessionContractImplementor session) throws SQLException {
        String jdbcValue = value == null ? null : this.toRelationalValue(value);
        this.valueBinder.bind(statement, (Object)jdbcValue, position, (WrapperOptions)session);
    }

    @Override
    public String toSqlLiteral(Object value) {
        return String.format(Locale.ROOT, "'%s'", ((CodeEnum)value).name());
    }

    private static <T extends CodeEnum> ValueExtractor<T> createValueExtractor(CodeEnumJavaTypeDescriptor<T> enumJavaDescriptor) {
        return VarcharTypeDescriptor.INSTANCE.getExtractor(enumJavaDescriptor);
    }

    private static ValueBinder<String> createValueBinder() {
        return VarcharTypeDescriptor.INSTANCE.getBinder((JavaTypeDescriptor)StringTypeDescriptor.INSTANCE);
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        stream.defaultReadObject();
        this.valueExtractor = NamedCodeEnumValueConverter.createValueExtractor(this.enumJavaDescriptor);
        this.valueBinder = NamedCodeEnumValueConverter.createValueBinder();
    }
}

