/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.async.executor;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.binis.codegen.async.executor.impl.CodeGenThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Executors {
    private static final Logger log = LoggerFactory.getLogger(Executors.class);
    private static final RejectedExecutionHandler defaultHandler = new ThreadPoolExecutor.AbortPolicy();

    public static Executor wrappedExecutor(String flow, Executor task) {
        LinkedTransferQueue<Runnable> queue = new LinkedTransferQueue<Runnable>(){

            @Override
            public boolean offer(Runnable e) {
                return this.tryTransfer(e);
            }
        };
        CodeGenThreadPoolExecutor executor = new CodeGenThreadPoolExecutor(1, Runtime.getRuntime().availableProcessors(), 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)queue, new DefaultThreadFactory(flow), defaultHandler, task);
        executor.setRejectedExecutionHandler((r, ex) -> {
            try {
                ex.getQueue().put(r);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
        return executor;
    }

    public static Executor defaultExecutor(String flow) {
        return Executors.wrappedExecutor(flow, Executors.defaultTask(flow));
    }

    public static Executor fixedThreadPool(String flow, int nThreads) {
        return new CodeGenThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new DefaultThreadFactory(flow), defaultHandler, Executors.defaultTask(flow));
    }

    public static Executor fixedThreadPool(String flow, int nThreads, int queueSize) {
        return new CodeGenThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new DefaultThreadFactory(flow), defaultHandler, Executors.defaultTask(flow));
    }

    public static Executor singleThreadedExecutor(String flow) {
        return Executors.fixedThreadPool(flow, 1);
    }

    public static Executor singleThreadedExecutor(String flow, int queueSize) {
        return Executors.fixedThreadPool(flow, 1, queueSize);
    }

    public static Executor silentExecutor(String flow) {
        return Executors.wrappedExecutor(flow, task -> {
            try {
                task.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public static Executor syncExecutor() {
        return Runnable::run;
    }

    public static Executor syncSilentExecutor() {
        return task -> {
            try {
                task.run();
            }
            catch (Exception e) {
                log.warn("Failed to execute task!", (Throwable)e);
            }
        };
    }

    private static Executor defaultTask(String flow) {
        return task -> {
            try {
                task.run();
            }
            catch (Exception e) {
                log.warn("Failed to execute task for flow ({})!", (Object)flow, (Object)e);
            }
        };
    }

    protected static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        DefaultThreadFactory(String flow) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = flow + "-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

