/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.tools;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class Holder<T> {
    private T object;
    private Supplier<T> supplier;

    public <R> Holder() {
        new Holder<Object>(null);
    }

    public Holder(T object) {
        this.object = object;
    }

    public T get() {
        if (Objects.nonNull(this.supplier)) {
            this.object = this.supplier.get();
            this.supplier = null;
        }
        return this.object;
    }

    public void set(T object) {
        this.object = object;
    }

    public T update(T object) {
        this.object = object;
        return object;
    }

    public boolean isEmpty() {
        return Objects.isNull(this.object);
    }

    public boolean isPresent() {
        return Objects.nonNull(this.object);
    }

    public void ifPresent(Consumer<? super T> action) {
        if (this.object != null) {
            action.accept(this.object);
        }
    }

    public static <T> Holder<T> of(T object) {
        return new Holder<T>(object);
    }

    public static <T> Holder<T> blank() {
        return new Holder<Object>(null);
    }

    public static <T> Holder<T> lazy(Supplier<T> supplier) {
        Holder<Object> result = new Holder<Object>(null);
        result.supplier = supplier;
        return result;
    }

    public String toString() {
        return Objects.isNull(this.object) ? "null" : this.object.toString();
    }

    public Holder<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (this.isEmpty()) {
            return this;
        }
        return predicate.test(this.object) ? this : Holder.blank();
    }

    public <U> Holder<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isEmpty()) {
            return Holder.blank();
        }
        return Holder.of(mapper.apply(this.object));
    }

    public <U> Holder<U> flatMap(Function<? super T, ? extends Holder<? extends U>> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isEmpty()) {
            return Holder.blank();
        }
        return Objects.requireNonNull(mapper.apply(this.object));
    }

    public Stream<T> stream() {
        if (this.isEmpty()) {
            return Stream.empty();
        }
        return Stream.of(this.object);
    }
}

