/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.binis.codegen.annotation.CodeConfiguration;
import net.binis.codegen.exception.MapperException;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.map.Mapper;
import net.binis.codegen.objects.base.enumeration.CodeEnum;
import net.binis.codegen.tools.Reflection;
import net.binis.codegen.tools.TypeUtils;

@CodeConfiguration
public abstract class DefaultMappings {
    protected static Map<Class, Function<Object, Map>> objectToMapCache = new ConcurrentHashMap<Class, Function<Object, Map>>();

    public static void initialize() {
        CodeFactory.registerType(Integer.TYPE, () -> 0);
        CodeFactory.registerType(Long.TYPE, () -> 0L);
        CodeFactory.registerType(Byte.TYPE, () -> (byte)0);
        CodeFactory.registerType(Short.TYPE, () -> (short)0);
        CodeFactory.registerType(Boolean.TYPE, () -> false);
        CodeFactory.registerType(Character.TYPE, () -> Character.valueOf('\u0000'));
        CodeFactory.registerType(Float.TYPE, () -> Float.valueOf(0.0f));
        CodeFactory.registerType(Double.TYPE, () -> 0.0);
        CodeFactory.registerType(Integer.class, () -> 0);
        CodeFactory.registerType(Long.class, () -> 0L);
        CodeFactory.registerType(Byte.class, () -> (byte)0);
        CodeFactory.registerType(Short.class, () -> (short)0);
        CodeFactory.registerType(Boolean.class, () -> false);
        CodeFactory.registerType(Character.class, () -> Character.valueOf('\u0000'));
        CodeFactory.registerType(Float.class, () -> Float.valueOf(0.0f));
        CodeFactory.registerType(Double.class, () -> 0.0);
        CodeFactory.registerType(String.class, () -> "");
        CodeFactory.registerType(Map.class, () -> new HashMap());
        CodeFactory.registerType(Set.class, () -> new HashSet());
        CodeFactory.registerType(List.class, () -> new ArrayList());
        Mapper.registerProducerMapper(Number.class, Integer.TYPE, (s, d) -> s.intValue());
        Mapper.registerProducerMapper(Number.class, Integer.class, (s, d) -> s.intValue());
        Mapper.registerProducerMapper(Number.class, Long.TYPE, (s, d) -> s.longValue());
        Mapper.registerProducerMapper(Number.class, Long.class, (s, d) -> s.longValue());
        Mapper.registerProducerMapper(Number.class, Byte.TYPE, (s, d) -> s.byteValue());
        Mapper.registerProducerMapper(Number.class, Byte.class, (s, d) -> s.byteValue());
        Mapper.registerProducerMapper(Number.class, Short.TYPE, (s, d) -> s.shortValue());
        Mapper.registerProducerMapper(Number.class, Short.class, (s, d) -> s.shortValue());
        Mapper.registerProducerMapper(Number.class, Boolean.TYPE, (s, d) -> s.intValue() != 0);
        Mapper.registerProducerMapper(Number.class, Boolean.class, (s, d) -> s.intValue() != 0);
        Mapper.registerProducerMapper(Number.class, Character.TYPE, (s, d) -> Character.valueOf((char)s.intValue()));
        Mapper.registerProducerMapper(Number.class, Character.class, (s, d) -> Character.valueOf((char)s.intValue()));
        Mapper.registerProducerMapper(Number.class, Float.TYPE, (s, d) -> Float.valueOf(s.floatValue()));
        Mapper.registerProducerMapper(Number.class, Float.class, (s, d) -> Float.valueOf(s.floatValue()));
        Mapper.registerProducerMapper(Number.class, Double.TYPE, (s, d) -> s.doubleValue());
        Mapper.registerProducerMapper(Number.class, Double.class, (s, d) -> s.doubleValue());
        Mapper.registerProducerMapper(Object.class, String.class, (s, d) -> s.toString());
        Mapper.registerMapperClass(String.class, Enum.class, (s, d) -> Enum.valueOf(d, s));
        Mapper.registerMapperClass(String.class, CodeEnum.class, (s, d) -> CodeFactory.enumValueOf(d, s));
        Mapper.registerMapperClass(Number.class, CodeEnum.class, (s, d) -> CodeFactory.enumValueOf(d, s.intValue()));
        Mapper.registerProducerMapperClass(byte[].class, Serializable.class, (s, d) -> {
            Serializable serializable;
            ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream((byte[])s));
            try {
                serializable = (Serializable)is.readObject();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new MapperException(e);
                }
            }
            is.close();
            return serializable;
        });
        Mapper.registerProducerMapperClass(Serializable.class, byte[].class, (s, d) -> {
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                byte[] byArray;
                try (ObjectOutputStream os = new ObjectOutputStream(bos);){
                    os.writeObject(s);
                    byArray = bos.toByteArray();
                }
                return byArray;
            }
            catch (Exception e) {
                throw new MapperException(e);
            }
        });
        Mapper.registerProducerMapperClass(Object.class, Map.class, DefaultMappings.ObjectToMap());
    }

    protected static BiFunction<Object, Class<Map>, Map> ObjectToMap() {
        return (s, d) -> {
            if (s instanceof Map) {
                Map map = (Map)s;
                return map;
            }
            return (Map)objectToMapCache.computeIfAbsent(s.getClass(), k -> {
                HashMap methods = Reflection.findMethods(s.getClass(), m -> !"getClass".equals(m.getName()) && m.getParameterCount() == 0 && !Void.TYPE.equals(m.getReturnType()) && (m.getModifiers() & 1) != 0 && (m.getModifiers() & 8) == 0 && (m.getName().startsWith("get") || m.getName().startsWith("is"))).stream().collect(HashMap::new, (m, v) -> {
                    Object name = v.getName().substring(v.getName().startsWith("i") ? 2 : 3);
                    if (!((String)name).isEmpty() && Character.isUpperCase(((String)name).charAt(0))) {
                        name = Character.toLowerCase(((String)name).charAt(0)) + ((String)name).substring(1);
                        m.put(name, DefaultMappings.mapValue(v));
                    }
                }, HashMap::putAll);
                return object -> methods.entrySet().stream().collect(HashMap::new, (m, v) -> m.put(v.getKey(), ((Function)v.getValue()).apply(object)), HashMap::putAll);
            }).apply(s);
        };
    }

    protected static Function<Object, Object> mapValue(Method method) {
        Class<?> cls = method.getReturnType();
        if (cls.isPrimitive() || TypeUtils.isWrapperType(cls) || String.class.equals(cls) || Enum.class.isAssignableFrom(cls)) {
            return object -> Reflection.invoke(method, object, new Object[0]);
        }
        return object -> {
            Object value = Reflection.invoke(method, object, new Object[0]);
            if (Objects.nonNull(value)) {
                return Mapper.map(value, Map.class);
            }
            return null;
        };
    }

    private DefaultMappings() {
    }
}

