/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> List<T> copyList(Collection<T> collection) {
        return new ArrayList<T>(collection);
    }

    public static boolean isEmpty(Collection collection) {
        return Objects.isNull(collection) || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection collection) {
        return Objects.nonNull(collection) && !collection.isEmpty();
    }

    public static boolean isEmpty(Map map) {
        return Objects.isNull(map) || map.isEmpty();
    }

    public static boolean isNotEmpty(Map map) {
        return Objects.nonNull(map) && !map.isEmpty();
    }

    public static String printInfo(Object object, boolean full) {
        if (Objects.isNull(object)) {
            return "null";
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            if (full) {
                return collection.getClass().getSimpleName() + "[" + collection.stream().map(o -> Objects.isNull(o) ? "null" : o.toString()).collect(Collectors.joining(", ")) + "]";
            }
            return collection.getClass().getSimpleName() + "[" + collection.size() + "]";
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (full) {
                return map.getClass().getSimpleName() + "[" + map.entrySet().stream().map(e -> "{" + e.getKey().toString() + ": " + CollectionUtils.printInfo(e.getValue(), true) + "}").collect(Collectors.joining(", ")) + "]";
            }
            return map.getClass().getSimpleName() + "[" + map.size() + "]";
        }
        return object.toString();
    }
}

