/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.map.executor;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.map.MapperFactory;
import net.binis.codegen.map.Mapping;
import net.binis.codegen.map.MappingStrategy;
import net.binis.codegen.map.executor.MapperExecutor;

public class DefaultMapperExecutor
implements MapperFactory {
    protected static final String DESTINATION_CANNOT_BE_NULL = "Destination cannot be null";
    protected final Map<String, Map<Object, Mapping>> mappers = new ConcurrentHashMap<String, Map<Object, Mapping>>();

    @Override
    public <T> T map(Object source, Class<T> destination) {
        return this.mapClass(source, destination, MappingStrategy.GETTERS_SETTERS, DEFAULT);
    }

    @Override
    public <T> T map(Object source, T destination) {
        return this.map(source, destination, MappingStrategy.GETTERS_SETTERS);
    }

    @Override
    public <T, K> T map(Object source, Class<T> destination, K key) {
        return this.mapClass(source, destination, MappingStrategy.GETTERS_SETTERS, key);
    }

    @Override
    public <T, K> T map(Object source, T destination, K key) {
        Objects.requireNonNull(destination, DESTINATION_CANNOT_BE_NULL);
        return this.map(source, destination, destination.getClass(), MappingStrategy.GETTERS_SETTERS, key);
    }

    @Override
    public <T> T map(Object source, Class<T> destination, MappingStrategy strategy) {
        return this.mapClass(source, destination, strategy, DEFAULT);
    }

    @Override
    public <T> T map(Object source, T destination, MappingStrategy strategy) {
        Objects.requireNonNull(destination, DESTINATION_CANNOT_BE_NULL);
        return this.map(source, destination, destination.getClass(), strategy, DEFAULT);
    }

    protected <T, K> T map(Object source, T destination, Class<T> cls, MappingStrategy strategy, K key) {
        if (Objects.isNull(source)) {
            return this.handleNullSource(destination, cls);
        }
        MapperExecutor mapper = this.getMapper(source.getClass(), cls, key);
        if (Objects.isNull(mapper)) {
            mapper = this.buildMapper(source, destination, false, strategy, key);
        }
        return (T)mapper.map((Object)source, destination);
    }

    protected <T, K> T mapClass(Object source, Class<T> cls, MappingStrategy strategy, K key) {
        Objects.requireNonNull(cls, DESTINATION_CANNOT_BE_NULL);
        if (Objects.isNull(source)) {
            return this.handleNullSource(null, cls);
        }
        MapperExecutor mapper = this.getMapper(source.getClass(), cls, key);
        if (Objects.isNull(mapper)) {
            mapper = this.buildMapperClass(source.getClass(), cls, false, true, strategy, key);
        }
        return mapper.map((Object)source, null);
    }

    @Override
    public Mapping mapping(Class source, Class destination) {
        return this.buildMapperClass(source, destination, false, false, MappingStrategy.GETTERS_SETTERS, DEFAULT);
    }

    @Override
    public Mapping mapping(Class source, Class destination, MappingStrategy strategy) {
        return this.buildMapperClass(source, destination, false, false, strategy, DEFAULT);
    }

    @Override
    public <T> T convert(Object source, Class<T> destination) {
        return (T)this.convert(source, (T)destination, MappingStrategy.GETTERS_SETTERS);
    }

    @Override
    public <T, K> T convert(Object source, Class<T> destination, K key) {
        return (T)this.convert(source, (T)destination, MappingStrategy.GETTERS_SETTERS, key);
    }

    @Override
    public <T> T convert(Object source, Class<T> destination, Object ... params) {
        return this.convert(source, CodeFactory.create(destination, params), destination, MappingStrategy.GETTERS_SETTERS, DEFAULT);
    }

    @Override
    public <T> T convert(Object source, T destination) {
        return this.convert(source, destination, MappingStrategy.GETTERS_SETTERS);
    }

    @Override
    public <T, K> T convert(Object source, T destination, K key) {
        return this.convert(source, destination, MappingStrategy.GETTERS_SETTERS, key);
    }

    @Override
    public <T> T convert(Object source, Class<T> destination, MappingStrategy strategy) {
        if (Objects.isNull(source)) {
            return this.handleNullSource(null, destination);
        }
        return this.convert(source, CodeFactory.create(destination, new Object[0]), destination, strategy, DEFAULT);
    }

    @Override
    public <T, K> T convert(Object source, Class<T> destination, MappingStrategy strategy, K key) {
        return this.convert(source, CodeFactory.create(destination, new Object[0]), strategy, key);
    }

    @Override
    public <T> T convert(Object source, Class<T> destination, MappingStrategy strategy, Object ... params) {
        return this.convert(source, CodeFactory.create(destination, params), destination, strategy, DEFAULT);
    }

    @Override
    public <T> T convert(Object source, T destination, MappingStrategy strategy) {
        return this.convert(source, destination, strategy, DEFAULT);
    }

    @Override
    public <T, K> T convert(Object source, T destination, MappingStrategy strategy, K key) {
        Objects.requireNonNull(destination, DESTINATION_CANNOT_BE_NULL);
        if (Objects.isNull(source)) {
            return this.handleNullSource(destination, null);
        }
        MapperExecutor mapper = this.getMapper(source.getClass(), destination.getClass(), key);
        if (Objects.isNull(mapper)) {
            mapper = this.buildMapper(source, destination, true, strategy, key);
        }
        return (T)mapper.map((Object)source, destination);
    }

    protected <T, K> T convert(Object source, T destination, Class<T> cls, MappingStrategy strategy, K key) {
        if (Objects.isNull(source)) {
            return this.handleNullSource(destination, cls);
        }
        MapperExecutor mapper = this.getMapper(source.getClass(), cls, key);
        if (Objects.isNull(mapper)) {
            mapper = this.buildMapperClass(source.getClass(), cls, true, true, strategy, key);
        }
        return (T)mapper.map((Object)source, destination);
    }

    protected <T> T handleNullSource(T destination, Class<T> cls) {
        if (Objects.nonNull(destination)) {
            return destination;
        }
        if (Objects.nonNull(cls) && cls.isPrimitive()) {
            return CodeFactory.create(cls, new Object[0]);
        }
        return null;
    }

    @Override
    public boolean canMap(Class<?> source, Class<?> destination) {
        return Objects.nonNull(this.getMap(source, destination));
    }

    @Override
    public boolean canMapExactly(Class<?> source, Class<?> destination) {
        return Objects.nonNull(this.getExactMap(source, destination));
    }

    @Override
    public <S, D> Mapping<S, D> getMap(Class<S> source, Class<D> destination) {
        return this.findMapper(source, destination);
    }

    @Override
    public <S, D> Mapping<S, D> getExactMap(Class<S> source, Class<D> destination) {
        return this.getMapper(source, destination, DEFAULT);
    }

    @Override
    public <S, D, K> Mapping<S, D> getExactMap(Class<S> source, Class<D> destination, K key) {
        return this.getMapper(source, destination, key);
    }

    @Override
    public void registerMapper(Mapping<?, ?> mapping) {
        this.registerMapper(mapping, DEFAULT);
    }

    @Override
    public synchronized <K> void registerMapper(Mapping<?, ?> mapping, K key) {
        String name = this.calcMapperName(mapping.getSource(), mapping.getDestination());
        Map<Object, Mapping> existing = this.mappers.get(name);
        if (Objects.isNull(existing)) {
            existing = new ConcurrentHashMap<Object, Mapping>();
        }
        existing.put(key, mapping);
        this.mappers.put(name, existing);
    }

    @Override
    public <S, D> List<Mapping<S, D>> findMappings(Class<S> source, Class<D> destination) {
        return this.findMappings(source, destination, DEFAULT);
    }

    @Override
    public <S, D, K> List<Mapping<S, D>> findMappings(Class<S> source, Class<D> destination, K key) {
        LinkedHashMap<Class, Mapping> result = new LinkedHashMap<Class, Mapping>();
        this.findMappings(result, source, destination, key);
        if (result.isEmpty()) {
            this.findReverseMappings(result, source, destination, key);
        }
        if (result.isEmpty()) {
            this.findJoinMappings(result, source, destination, key);
        }
        return result.values().stream().toList();
    }

    @Override
    public <S, D> Mapping<S, D> clearMapping(Class<S> source, Class<D> destination) {
        Map<Object, Mapping> map = this.mappers.remove(this.calcMapperName(source, destination));
        if (Objects.nonNull(map)) {
            return map.get(DEFAULT);
        }
        return null;
    }

    @Override
    public void clearAllMappings() {
        this.mappers.clear();
    }

    protected void findMappings(Map<Class, Mapping> map, Class source, Class destination, Object key) {
        Mapping mapping;
        Map<Object, Mapping> m = this.mappers.get(this.calcMapperName(source, destination));
        Mapping mapping2 = mapping = Objects.nonNull(m) ? m.get(key) : null;
        if (Objects.nonNull(mapping)) {
            map.putIfAbsent(source, mapping);
        } else {
            for (Class<?> intf : source.getInterfaces()) {
                this.findMappings(map, intf, destination, key);
            }
            Class superClass = this.getSuperClass(source);
            if (Objects.nonNull(superClass)) {
                this.findMappings(map, superClass, destination, key);
            }
        }
    }

    protected <S> void findReverseMappings(Map<Class<S>, Mapping<S, ?>> map, Class<S> source, Class<?> destination, Object key) {
        Mapping mapping;
        Map<Object, Mapping> m = this.mappers.get(this.calcMapperName(source, destination));
        Mapping mapping2 = mapping = Objects.nonNull(m) ? m.get(key) : null;
        if (Objects.nonNull(mapping)) {
            map.putIfAbsent(source, mapping);
        } else {
            for (Class<?> intf : destination.getInterfaces()) {
                this.findReverseMappings(map, source, intf, key);
            }
            Class superClass = this.getSuperClass(destination);
            if (Objects.nonNull(superClass)) {
                this.findReverseMappings(map, source, superClass, key);
            }
        }
    }

    protected <S> void findJoinMappings(Map<Class, Mapping> map, Class<S> source, Class<?> destination, Object key) {
        Mapping mapping;
        Map<Object, Mapping> m = this.mappers.get(this.calcMapperName(source, destination));
        Mapping mapping2 = mapping = Objects.nonNull(m) ? m.get(key) : null;
        if (Objects.nonNull(mapping)) {
            map.putIfAbsent(source, mapping);
        } else {
            for (Class<?> intf : destination.getInterfaces()) {
                for (Class<?> dIntf : destination.getInterfaces()) {
                    this.findMappings(map, intf, dIntf, key);
                    this.findReverseMappings(map, intf, dIntf, key);
                }
            }
            Class superClass = this.getSuperClass(source);
            while (Objects.nonNull(superClass)) {
                Class dSuperClass = this.getSuperClass(destination);
                while (Objects.nonNull(dSuperClass)) {
                    this.findJoinMappings(map, superClass, dSuperClass, key);
                    dSuperClass = this.getSuperClass(dSuperClass);
                }
                superClass = this.getSuperClass(superClass);
            }
        }
    }

    protected <T> MapperExecutor buildMapper(Object source, T destination, boolean convert, MappingStrategy strategy, Object key) {
        return this.buildMapperClass(source.getClass(), destination.getClass(), convert, true, strategy, key);
    }

    protected <T> MapperExecutor buildMapperClass(Class source, Class destination, boolean convert, boolean register, MappingStrategy strategy, Object key) {
        MapperExecutor result = new MapperExecutor(source, destination, convert, false, strategy, key);
        if (register) {
            String name = this.calcMapperName(source, destination);
            Map<Object, Mapping> existing = this.mappers.get(name);
            if (Objects.isNull(existing)) {
                existing = new ConcurrentHashMap<Object, Mapping>();
            }
            existing.put(key, result);
            this.mappers.put(name, existing);
        }
        return result;
    }

    protected String calcMapperName(Class source, Class destination) {
        return source.getCanonicalName() + "->" + destination.getCanonicalName();
    }

    protected <S, D> Mapping<S, D> findMapper(Class<S> source, Class<D> destination) {
        return this.getMapper(source, destination, DEFAULT);
    }

    protected Class getSuperClass(Class<?> cls) {
        Class<Object> result = cls.getSuperclass();
        if (Objects.isNull(result) && cls.isInterface()) {
            result = Object.class;
        }
        return result;
    }

    protected <K> Mapping<Object, Object> getMapper(Class<?> source, Class<?> destination, K key) {
        Map<Object, Mapping> map = this.mappers.get(this.calcMapperName(source, destination));
        if (Objects.nonNull(map)) {
            return map.get(key);
        }
        return null;
    }
}

