/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.collection;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.binis.codegen.collection.CodeList;

public class CodeListImpl<T, R>
implements CodeList<T, R> {
    protected final R parent;
    protected final List<T> list;
    protected final Consumer<T> validator;

    public CodeListImpl(R parent, List<T> list) {
        this.parent = parent;
        this.list = list;
        this.validator = null;
    }

    public CodeListImpl(R parent, List<T> list, Consumer<T> validator) {
        this.parent = parent;
        this.list = list;
        this.validator = validator;
    }

    @Override
    public CodeList<T, R> add(T value) {
        this.validate(value);
        this.list.add(value);
        return this;
    }

    @Override
    public CodeList<T, R> add(int index, T value) {
        this.validate(value);
        this.list.add(index, value);
        return this;
    }

    @Override
    public CodeList<T, R> addAll(Collection<? extends T> collection) {
        collection.forEach(this::validate);
        this.list.addAll(collection);
        return this;
    }

    @Override
    public CodeList<T, R> addAll(int index, Collection<? extends T> collection) {
        collection.forEach(this::validate);
        this.list.addAll(index, collection);
        return this;
    }

    @Override
    public CodeList<T, R> remove(T value) {
        this.list.remove(value);
        return this;
    }

    @Override
    public CodeList<T, R> remove(int index) {
        this.list.remove(index);
        return this;
    }

    @Override
    public CodeList<T, R> removeAll(Collection<?> collection) {
        this.list.removeAll(collection);
        return this;
    }

    @Override
    public CodeList<T, R> retainAll(Collection<?> collection) {
        this.list.retainAll(collection);
        return this;
    }

    @Override
    public CodeList<T, R> replaceAll(UnaryOperator<T> operator) {
        this.list.replaceAll(o -> {
            Object value = operator.apply(o);
            this.validate(value);
            return value;
        });
        return this;
    }

    @Override
    public CodeList<T, R> sort(Comparator<? super T> c) {
        this.list.sort(c);
        return this;
    }

    @Override
    public CodeList<T, R> clear() {
        this.list.clear();
        return this;
    }

    @Override
    public CodeList<T, R> set(int index, T value) {
        this.validate(value);
        this.list.set(index, value);
        return this;
    }

    @Override
    public CodeList<T, R> addFirst(T value) {
        this.validate(value);
        this.list.add(0, value);
        return this;
    }

    @Override
    public CodeList<T, R> removeFirst() {
        this.list.remove(0);
        return this;
    }

    @Override
    public CodeList<T, R> removeLast() {
        this.list.remove(this.list.size() - 1);
        return this;
    }

    @Override
    public R done() {
        return this.parent;
    }

    @Override
    public CodeList<T, R> _if(boolean condition, Consumer<CodeList<T, R>> consumer) {
        if (condition) {
            consumer.accept(this);
        }
        return this;
    }

    @Override
    public CodeList<T, R> _if(boolean condition, BiConsumer<CodeList<T, R>, R> consumer) {
        if (condition) {
            consumer.accept(this, this.parent);
        }
        return this;
    }

    @Override
    public CodeList<T, R> _if(boolean condition, Consumer<CodeList<T, R>> consumer, Consumer<CodeList<T, R>> elseConsumer) {
        if (condition) {
            consumer.accept(this);
        } else {
            elseConsumer.accept(this);
        }
        return this;
    }

    @Override
    public CodeList<T, R> _if(boolean condition, BiConsumer<CodeList<T, R>, R> consumer, BiConsumer<CodeList<T, R>, R> elseConsumer) {
        if (condition) {
            consumer.accept(this, this.parent);
        } else {
            elseConsumer.accept(this, this.parent);
        }
        return this;
    }

    @Override
    public CodeList<T, R> _self(BiConsumer<CodeList<T, R>, R> consumer) {
        consumer.accept(this, this.parent);
        return this;
    }

    @Override
    public CodeList<T, R> _map(Object source) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    protected void validate(T value) {
        if (Objects.nonNull(this.validator)) {
            this.validator.accept(value);
        }
    }
}

