/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.collection;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.binis.codegen.collection.CodeSet;

public class CodeSetImpl<T, R>
implements CodeSet<T, R> {
    private final R parent;
    private final Set<T> set;
    private final Consumer<T> validator;

    public CodeSetImpl(R parent, Set<T> set) {
        this.parent = parent;
        this.set = set;
        this.validator = null;
    }

    public CodeSetImpl(R parent, Set<T> set, Consumer<T> validator) {
        this.parent = parent;
        this.set = set;
        this.validator = validator;
    }

    @Override
    public CodeSet<T, R> add(T value) {
        this.validate(value);
        this.set.add(value);
        return this;
    }

    @Override
    public CodeSet<T, R> remove(Object o) {
        this.set.remove(o);
        return this;
    }

    @Override
    public CodeSet<T, R> addAll(Collection<? extends T> c) {
        c.forEach(this::validate);
        this.set.addAll(c);
        return this;
    }

    @Override
    public CodeSet<T, R> retainAll(Collection<?> c) {
        this.set.retainAll(c);
        return this;
    }

    @Override
    public CodeSet<T, R> removeAll(Collection<?> c) {
        this.set.removeAll(c);
        return this;
    }

    @Override
    public CodeSet<T, R> clear() {
        this.set.clear();
        return this;
    }

    @Override
    public R done() {
        return this.parent;
    }

    protected void validate(T value) {
        if (Objects.nonNull(this.validator)) {
            this.validator.accept(value);
        }
    }

    @Override
    public CodeSet<T, R> _if(boolean condition, Consumer<CodeSet<T, R>> consumer) {
        if (condition) {
            consumer.accept(this);
        }
        return this;
    }

    @Override
    public CodeSet<T, R> _if(boolean condition, BiConsumer<CodeSet<T, R>, R> consumer) {
        if (condition) {
            consumer.accept(this, this.parent);
        }
        return this;
    }

    @Override
    public CodeSet<T, R> _if(boolean condition, Consumer<CodeSet<T, R>> consumer, Consumer<CodeSet<T, R>> elseConsumer) {
        if (condition) {
            consumer.accept(this);
        } else {
            elseConsumer.accept(this);
        }
        return this;
    }

    @Override
    public CodeSet<T, R> _if(boolean condition, BiConsumer<CodeSet<T, R>, R> consumer, BiConsumer<CodeSet<T, R>, R> elseConsumer) {
        if (condition) {
            consumer.accept(this, this.parent);
        } else {
            elseConsumer.accept(this, this.parent);
        }
        return this;
    }

    @Override
    public CodeSet<T, R> _self(BiConsumer<CodeSet<T, R>, R> consumer) {
        consumer.accept(this, this.parent);
        return this;
    }

    @Override
    public CodeSet<T, R> _map(Object source) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }
}

