/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.collection;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.binis.codegen.collection.CodeMap;

public class CodeMapImpl<K, V, R>
implements CodeMap<K, V, R> {
    protected final R parent;
    protected final Map<K, V> map;
    protected final Consumer<K> keyValidator;
    protected final Consumer<V> valueValidator;

    public CodeMapImpl(R parent, Map<K, V> map) {
        this.parent = parent;
        this.map = map;
        this.keyValidator = null;
        this.valueValidator = null;
    }

    public CodeMapImpl(R parent, Map<K, V> map, Consumer<K> keyValidator, Consumer<V> valueValidator) {
        this.parent = parent;
        this.map = map;
        this.keyValidator = keyValidator;
        this.valueValidator = valueValidator;
    }

    @Override
    public CodeMap<K, V, R> put(K key, V value) {
        this.validate(key, value);
        this.map.put(key, value);
        return this;
    }

    @Override
    public CodeMap<K, V, R> putAll(Map<? extends K, ? extends V> map) {
        map.forEach(this::put);
        return this;
    }

    @Override
    public CodeMap<K, V, R> remove(Object key) {
        this.map.remove(key);
        return this;
    }

    @Override
    public CodeMap<K, V, R> clear() {
        this.map.clear();
        return this;
    }

    @Override
    public CodeMap<K, V, R> replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.map.replaceAll((k, v) -> {
            this.validate(k, v);
            return function.apply((K)k, (V)v);
        });
        return this;
    }

    @Override
    public CodeMap<K, V, R> putIfAbsent(K key, V value) {
        this.validate(key, value);
        this.map.putIfAbsent(key, value);
        return this;
    }

    @Override
    public CodeMap<K, V, R> remove(Object key, Object value) {
        this.map.remove(key, value);
        return this;
    }

    @Override
    public CodeMap<K, V, R> replace(K key, V oldValue, V newValue) {
        this.validate(key, newValue);
        this.map.replace(key, oldValue, newValue);
        return this;
    }

    @Override
    public CodeMap<K, V, R> replace(K key, V value) {
        this.validate(key, value);
        this.map.replace(key, value);
        return this;
    }

    @Override
    public CodeMap<K, V, R> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        this.validateKey(key);
        this.map.computeIfAbsent(key, k -> {
            Object value = mappingFunction.apply((K)k);
            this.validateValue(value);
            return value;
        });
        return this;
    }

    @Override
    public CodeMap<K, V, R> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.validateKey(key);
        this.map.computeIfPresent(key, (k, v) -> {
            Object value = remappingFunction.apply((K)k, (V)v);
            this.validateValue(value);
            return value;
        });
        return this;
    }

    @Override
    public CodeMap<K, V, R> compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.validateKey(key);
        this.map.compute(key, (k, v) -> {
            Object value = remappingFunction.apply((K)k, (V)v);
            this.validateValue(value);
            return value;
        });
        return this;
    }

    @Override
    public CodeMap<K, V, R> merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        this.validateKey(key);
        this.map.merge(key, value, (old, v) -> {
            Object val = remappingFunction.apply((V)old, (V)v);
            this.validateValue(val);
            return val;
        });
        return this;
    }

    @Override
    public R done() {
        return this.parent;
    }

    protected void validate(K key, V value) {
        this.validateKey(key);
        this.validateValue(value);
    }

    protected void validateKey(K key) {
        if (Objects.nonNull(this.keyValidator)) {
            this.keyValidator.accept(key);
        }
    }

    protected void validateValue(V value) {
        if (Objects.nonNull(this.valueValidator)) {
            this.valueValidator.accept(value);
        }
    }

    @Override
    public CodeMap<K, V, R> _if(boolean condition, Consumer<CodeMap<K, V, R>> consumer) {
        if (condition) {
            consumer.accept(this);
        }
        return this;
    }

    @Override
    public CodeMap<K, V, R> _if(boolean condition, BiConsumer<CodeMap<K, V, R>, R> consumer) {
        if (condition) {
            consumer.accept(this, this.parent);
        }
        return this;
    }

    @Override
    public CodeMap<K, V, R> _if(boolean condition, Consumer<CodeMap<K, V, R>> consumer, Consumer<CodeMap<K, V, R>> elseConsumer) {
        if (condition) {
            consumer.accept(this);
        } else {
            elseConsumer.accept(this);
        }
        return this;
    }

    @Override
    public CodeMap<K, V, R> _if(boolean condition, BiConsumer<CodeMap<K, V, R>, R> consumer, BiConsumer<CodeMap<K, V, R>, R> elseConsumer) {
        if (condition) {
            consumer.accept(this, this.parent);
        } else {
            elseConsumer.accept(this, this.parent);
        }
        return this;
    }

    @Override
    public CodeMap<K, V, R> _self(BiConsumer<CodeMap<K, V, R>, R> consumer) {
        consumer.accept(this, this.parent);
        return this;
    }

    @Override
    public CodeMap<K, V, R> _map(Object source) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }
}

