/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.collection;

import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.binis.codegen.collection.CodeMap;

public class CodeMapImpl<K, V, R>
implements CodeMap<K, V, R> {
    private final R parent;
    private final Map<K, V> map;
    private final Consumer<K> keyValidator;
    private final Consumer<V> valueValidator;

    public CodeMapImpl(R parent, Map<K, V> map) {
        this.parent = parent;
        this.map = map;
        this.keyValidator = null;
        this.valueValidator = null;
    }

    public CodeMapImpl(R parent, Map<K, V> map, Consumer<K> keyValidator, Consumer<V> valueValidator) {
        this.parent = parent;
        this.map = map;
        this.keyValidator = keyValidator;
        this.valueValidator = valueValidator;
    }

    @Override
    public CodeMap<K, V, R> put(K key, V value) {
        this.validate(key, value);
        this.map.put(key, value);
        return this;
    }

    @Override
    public R and() {
        return this.parent;
    }

    protected void validate(K key, V value) {
        if (Objects.nonNull(this.keyValidator)) {
            this.keyValidator.accept(key);
        }
        if (Objects.nonNull(this.valueValidator)) {
            this.valueValidator.accept(value);
        }
    }
}

