/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.async.executor;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import net.binis.codegen.async.AsyncDispatcher;
import net.binis.codegen.async.executor.Executors;
import net.binis.codegen.async.monitoring.DispatcherMonitor;
import net.binis.codegen.factory.CodeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeExecutor {
    private static final Logger log = LoggerFactory.getLogger(CodeExecutor.class);
    public static final String DEFAULT = "default";
    private static final Dispatcher dispatcher = new Dispatcher();

    public static void registerDefaultExecutor(Executor executor) {
        CodeExecutor.registerExecutor(DEFAULT, executor);
    }

    public static void registerExecutor(String flow, Executor executor) {
        dispatcher.register(flow, executor);
    }

    public static AsyncDispatcher defaultDispatcher() {
        return dispatcher;
    }

    static {
        CodeFactory.registerType(AsyncDispatcher.class, CodeFactory.singleton(CodeExecutor.defaultDispatcher()), null);
        CodeExecutor.registerDefaultExecutor(Executors.defaultExecutor(DEFAULT));
    }

    private static final class Dispatcher
    implements AsyncDispatcher,
    DispatcherMonitor {
        private final Map<String, Executor> flows = new ConcurrentHashMap<String, Executor>();

        private Dispatcher() {
        }

        @Override
        public Executor flow(String flow) {
            return this.flows.computeIfAbsent(flow, Executors::defaultExecutor);
        }

        @Override
        public Executor _default() {
            return this.flow(CodeExecutor.DEFAULT);
        }

        private void register(String flow, Executor executor) {
            this.flows.put(flow, executor);
        }

        @Override
        public Executor getExecutor(String flow) {
            return this.flows.get(flow);
        }

        @Override
        public Executor getDefaultExecutor() {
            return this.flows.get(CodeExecutor.DEFAULT);
        }

        @Override
        public Set<String> flows() {
            return this.flows.keySet();
        }
    }
}

