/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.binis.codegen.annotation.Default;
import net.binis.codegen.factory.CodeFactory;

public class Functional {
    public static <R> FunctionalDoWhile<R> _do() {
        return CodeFactory.create(FunctionalDoWhile.class, new Object[0]);
    }

    public static <R> FunctionalDoWhile<R> _do(Supplier<R> supplier) {
        return Functional._do()._with(supplier);
    }

    public static <T, R> FunctionalRecursive<T, R> _recursive(T start) {
        return CodeFactory.create(FunctionalRecursive.class, start);
    }

    public static <I, R> FunctionalFor<I, R> _for(Iterable<I> iterable) {
        return CodeFactory.create(FunctionalFor.class, iterable);
    }

    public static <I, R> FunctionalFor<I, R> _for(Iterable<I> iterable, R initial) {
        return CodeFactory.create(FunctionalFor.class, iterable, initial);
    }

    protected Functional() {
    }

    @Default(value="net.binis.codegen.tools.Functional$FunctionalDoWhileImpl")
    public static interface FunctionalDoWhile<R> {
        public FunctionalDoWhile<R> _run(Runnable var1);

        public FunctionalDoWhile<R> _with(Supplier<R> var1);

        public FunctionalEnd<R> _while(Predicate<R> var1);

        public FunctionalEnd<R> _while(BooleanSupplier var1);
    }

    @Default(value="net.binis.codegen.tools.Functional$FunctionalRecursiveImpl")
    public static interface FunctionalRecursive<T, R> {
        public FunctionalRecursive<T, R> _on(UnaryOperator<T> var1);

        public <Q> FunctionalRecursive<T, Q> _init(Supplier<Q> var1);

        public <Q> FunctionalRecursive<T, Q> _init(Q var1);

        public void _perform(Consumer<T> var1);

        public FunctionalEnd<T> _do(UnaryOperator<T> var1);

        public FunctionalEnd<R> _do(BiFunction<T, R, R> var1);

        public FunctionalEnd<R> _perform(BiConsumer<T, R> var1);
    }

    @Default(value="net.binis.codegen.tools.Functional$FunctionalForImpl")
    public static interface FunctionalFor<I, R> {
        public R _do(BiFunction<I, R, R> var1);

        public R _do(Consumer<I> var1);
    }

    protected static class FunctionalForImpl<I, R>
    implements FunctionalFor<I, R> {
        protected final Iterable<I> iterable;
        protected R result;

        protected FunctionalForImpl(Iterable<I> iterable, R start) {
            CodeFactory.registerType(FunctionalFor.class, p -> new FunctionalForImpl((Iterable)p[0], (p.length == 2 ? p[1] : null)), null);
            this.iterable = iterable;
            this.result = start;
        }

        @Override
        public R _do(BiFunction<I, R, R> function) {
            for (I i : this.iterable) {
                this.result = function.apply(i, this.result);
            }
            return this.result;
        }

        @Override
        public R _do(Consumer<I> consumer) {
            for (I i : this.iterable) {
                consumer.accept(i);
            }
            return this.result;
        }
    }

    protected static class FunctionalRecursiveImpl<T, R>
    extends FunctionalEndImpl<R>
    implements FunctionalRecursive<T, R> {
        protected UnaryOperator<T> on = null;
        protected T object;
        protected Supplier<R> init;

        protected FunctionalRecursiveImpl(T start) {
            CodeFactory.registerType(FunctionalRecursive.class, p -> new FunctionalRecursiveImpl(p[0]), null);
            this.object = start;
        }

        @Override
        public FunctionalRecursive<T, R> _on(UnaryOperator<T> on) {
            this.on = on;
            return this;
        }

        @Override
        public FunctionalRecursive _init(Supplier init) {
            this.init = init;
            return this;
        }

        @Override
        public FunctionalRecursive _init(Object init) {
            this.init = () -> init;
            return this;
        }

        @Override
        public void _perform(Consumer<T> doConsumer) {
            assert (Objects.nonNull(this.on)) : "_on() operator is not specified!";
            Object obj = this.object;
            while (Objects.nonNull(obj)) {
                obj = this.on.apply(obj);
            }
        }

        @Override
        public FunctionalEnd<T> _do(UnaryOperator<T> doOperator) {
            Object obj = this.object;
            while (Objects.nonNull(obj)) {
                obj = doOperator.apply(obj);
            }
            this.result = obj;
            return this;
        }

        @Override
        public FunctionalEnd<R> _do(BiFunction<T, R, R> doFunction) {
            Object res;
            assert (Objects.nonNull(this.on)) : "_on() operator is not specified!";
            Object obj = this.object;
            Object u = res = Objects.nonNull(this.init) ? (Object)this.init.get() : null;
            while (Objects.nonNull(obj)) {
                res = doFunction.apply(obj, res);
                obj = this.on.apply(obj);
            }
            this.result = res;
            return this;
        }

        @Override
        public FunctionalEnd<R> _perform(BiConsumer<T, R> perform) {
            return this._do((T t, R r) -> {
                perform.accept(t, r);
                return r;
            });
        }
    }

    protected static class FunctionalDoWhileImpl<R>
    extends FunctionalEndImpl<R>
    implements FunctionalDoWhile<R> {
        protected Supplier<R> supplier = () -> null;

        protected FunctionalDoWhileImpl() {
            CodeFactory.registerType(FunctionalDoWhile.class, FunctionalDoWhileImpl::new, null);
        }

        @Override
        public FunctionalDoWhile<R> _run(Runnable runnable) {
            this.supplier = () -> {
                runnable.run();
                return null;
            };
            return this;
        }

        @Override
        public FunctionalDoWhile<R> _with(Supplier<R> supplier) {
            this.supplier = supplier;
            return this;
        }

        @Override
        public FunctionalEnd _while(Predicate predicate) {
            do {
                this.result = this.supplier.get();
            } while (predicate.test(this.result));
            return this;
        }

        @Override
        public FunctionalEnd<R> _while(BooleanSupplier supplier) {
            return this._while((T r) -> supplier.getAsBoolean());
        }
    }

    protected static class FunctionalEndImpl<R>
    implements FunctionalEnd<R> {
        protected Object result = null;

        protected FunctionalEndImpl() {
        }

        @Override
        public void _done() {
        }

        @Override
        public Optional _get() {
            return Optional.ofNullable(this.result);
        }

        @Override
        public FunctionalEnd _map(Function mapper) {
            this.result = mapper.apply(this.result);
            return this;
        }

        @Override
        public FunctionalEnd _then(Consumer consumer) {
            if (Objects.nonNull(this.result)) {
                consumer.accept(this.result);
            }
            return this;
        }
    }

    public static interface FunctionalEnd<R> {
        public void _done();

        public Optional<R> _get();

        public <T> FunctionalEnd<T> _map(Function<R, T> var1);

        public FunctionalEnd<R> _then(Consumer<R> var1);
    }

    public static class Initializer {
        public static <T> Supplier<List<T>> listOf(Class<T> cls) {
            return ArrayList::new;
        }

        public static <K, V> Supplier<Map<K, V>> mapOf(Class<K> keyClass, Class<V> valueClass) {
            return HashMap::new;
        }

        protected Initializer() {
        }
    }
}

