/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.map.executor;

import java.util.Objects;
import java.util.function.BiFunction;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.map.Mapping;
import net.binis.codegen.map.executor.ClassMapping;

public class LambdaMapperExecutor
implements Mapping,
ClassMapping {
    private final Class<?> source;
    private final Class<?> destination;
    private final BiFunction lambda;
    private final boolean cls;
    private final boolean producer;

    public LambdaMapperExecutor(Class<?> source, Class<?> destination, boolean isClass, boolean producer, BiFunction lambda) {
        this.source = source;
        this.destination = destination;
        this.lambda = lambda;
        this.cls = isClass;
        this.producer = producer;
    }

    public Class getSource() {
        return this.source;
    }

    public Class getDestination() {
        return this.destination;
    }

    @Override
    public boolean isClass() {
        return this.cls;
    }

    public Object map(Object source, Object destination) {
        if (!this.producer && Objects.isNull(destination)) {
            destination = CodeFactory.create(this.destination, new Object[0]);
        }
        return this.lambda.apply(source, destination);
    }
}

