/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.discovery;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.binis.codegen.annotation.CodeConfiguration;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.tools.Reflection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Discoverer {
    private static final Logger log = LoggerFactory.getLogger(Discoverer.class);
    public static final String TEMPLATE = "template";
    public static final String CONFIG = "config";
    public static final String INIT = "init";
    protected static final String RESOURCE_PATH = "binis/annotations";

    protected static List<InputStream> loadResources(String name, ClassLoader classLoader) throws IOException {
        ArrayList<InputStream> list = new ArrayList<InputStream>();
        Enumeration<URL> systemResources = (classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader).getResources(name);
        while (systemResources.hasMoreElements()) {
            list.add(systemResources.nextElement().openStream());
        }
        return list;
    }

    public static List<DiscoveredService> findAnnotations(String text) {
        ArrayList<DiscoveredService> result = new ArrayList<DiscoveredService>();
        Discoverer.processResource(text, result);
        return result;
    }

    public static List<DiscoveredService> findAnnotations() {
        ArrayList<DiscoveredService> result = new ArrayList<DiscoveredService>();
        try {
            Discoverer.loadResources(RESOURCE_PATH, Discoverer.class.getClassLoader()).forEach(s -> Discoverer.processResource(s, (List<DiscoveredService>)result));
        }
        catch (Exception e) {
            log.error("Unable to discover services!", (Throwable)e);
        }
        return result;
    }

    protected static void processResource(String text, List<DiscoveredService> services) {
        Discoverer.processResource(new BufferedReader(new StringReader(text)), services, false, false);
    }

    protected static void processResource(InputStream stream, List<DiscoveredService> services) {
        Discoverer.processResource(new BufferedReader(new InputStreamReader(stream)), services, true, !(stream instanceof BufferedInputStream));
    }

    protected static void processResource(BufferedReader reader, List<DiscoveredService> services, boolean tryLoad, boolean showWarning) {
        try {
            String line;
            while (reader.ready() && !Objects.isNull(line = reader.readLine())) {
                String[] parts = line.split(":");
                if (parts.length == 2) {
                    Class<?> cls;
                    if (TEMPLATE.equals(parts[0])) {
                        if (tryLoad) {
                            cls = Reflection.loadClass(parts[1]);
                            if (Objects.nonNull(cls)) {
                                if (!Annotation.class.isAssignableFrom(cls)) continue;
                                services.add(DiscoveredService.builder().type(parts[0]).name(parts[1]).cls(cls).build());
                                continue;
                            }
                            if (!showWarning) continue;
                            log.warn("Can't load class: {}!", (Object)parts[1]);
                            continue;
                        }
                        services.add(DiscoveredService.builder().type(parts[0]).name(parts[1]).cls(null).build());
                        continue;
                    }
                    if (CONFIG.equals(parts[0])) {
                        if (tryLoad) {
                            cls = Reflection.loadClass(parts[1]);
                            if (Objects.nonNull(cls)) {
                                if (!cls.isAnnotationPresent(CodeConfiguration.class)) continue;
                                services.add(DiscoveredService.builder().type(parts[0]).name(parts[1]).cls(cls).build());
                                continue;
                            }
                            log.warn("Can't load class: {}!", (Object)parts[1]);
                            continue;
                        }
                        services.add(DiscoveredService.builder().type(parts[0]).name(parts[1]).cls(null).build());
                        continue;
                    }
                    if (INIT.equals(parts[0])) {
                        if (tryLoad) {
                            cls = Reflection.loadClass(parts[1]);
                            if (Objects.nonNull(cls)) {
                                CodeFactory.create(cls, new Object[0]);
                                services.add(DiscoveredService.builder().type(parts[0]).name(parts[1]).cls(cls).build());
                                continue;
                            }
                            log.warn("Can't load class: {}!", (Object)parts[1]);
                            continue;
                        }
                        services.add(DiscoveredService.builder().type(parts[0]).name(parts[1]).cls(null).build());
                        continue;
                    }
                    cls = null;
                    if (tryLoad) {
                        cls = Reflection.loadClass(parts[1]);
                    }
                    services.add(DiscoveredService.builder().type(parts[0]).name(parts[1]).cls(cls).build());
                    continue;
                }
                log.warn("Invalid descriptor line: {}!", (Object)line);
            }
        }
        catch (IOException e) {
            log.warn("Failed to process stream!", (Throwable)e);
        }
    }

    protected static Set<String> readServiceFile(InputStream input) throws IOException {
        HashSet<String> serviceClasses = new HashSet<String>();
        try (BufferedReader r = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            String line;
            while ((line = r.readLine()) != null) {
                int commentStart = line.indexOf(35);
                if (commentStart >= 0) {
                    line = line.substring(0, commentStart);
                }
                if ((line = line.trim()).isEmpty()) continue;
                serviceClasses.add(line);
            }
            HashSet<String> hashSet = serviceClasses;
            return hashSet;
        }
    }

    public static class DiscoveredService {
        protected String type;
        protected String name;
        protected Class<?> cls;

        public boolean isConfig() {
            return Discoverer.CONFIG.equals(this.type);
        }

        public boolean isTemplate() {
            return Discoverer.TEMPLATE.equals(this.type);
        }

        DiscoveredService(String type, String name, Class<?> cls) {
            this.type = type;
            this.name = name;
            this.cls = cls;
        }

        public static DiscoveredServiceBuilder builder() {
            return new DiscoveredServiceBuilder();
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getCls() {
            return this.cls;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setCls(Class<?> cls) {
            this.cls = cls;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DiscoveredService)) {
                return false;
            }
            DiscoveredService other = (DiscoveredService)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Class<?> this$cls = this.getCls();
            Class<?> other$cls = other.getCls();
            return !(this$cls == null ? other$cls != null : !this$cls.equals(other$cls));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DiscoveredService;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Class<?> $cls = this.getCls();
            result = result * 59 + ($cls == null ? 43 : $cls.hashCode());
            return result;
        }

        public String toString() {
            return "Discoverer.DiscoveredService(type=" + this.getType() + ", name=" + this.getName() + ", cls=" + this.getCls() + ")";
        }

        public static class DiscoveredServiceBuilder {
            private String type;
            private String name;
            private Class<?> cls;

            DiscoveredServiceBuilder() {
            }

            public DiscoveredServiceBuilder type(String type) {
                this.type = type;
                return this;
            }

            public DiscoveredServiceBuilder name(String name) {
                this.name = name;
                return this;
            }

            public DiscoveredServiceBuilder cls(Class<?> cls) {
                this.cls = cls;
                return this;
            }

            public DiscoveredService build() {
                return new DiscoveredService(this.type, this.name, this.cls);
            }

            public String toString() {
                return "Discoverer.DiscoveredService.DiscoveredServiceBuilder(type=" + this.type + ", name=" + this.name + ", cls=" + this.cls + ")";
            }
        }
    }
}

