/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.tools;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.binis.codegen.tools.TypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;

public abstract class Reflection {
    private static final Logger log = LoggerFactory.getLogger(Reflection.class);
    protected static ClassLoader loader;
    protected static final Unsafe unsafe;
    protected static final Method declaredFields;
    protected static final Long offset;

    protected Reflection() {
    }

    public static Class<?> loadClass(String className) {
        try {
            return Objects.nonNull(loader) ? loader.loadClass(className) : Class.forName(className);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static Class<?> loadClass(String className, ClassLoader loader) {
        try {
            return loader.loadClass(className);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static <T> T instantiate(Class<T> cls, Object ... params) {
        return Reflection.findConstructor(cls, params).newInstance(params);
    }

    public static Constructor findConstructor(Class<?> cls, Object ... params) {
        for (Constructor<?> constructor : cls.getDeclaredConstructors()) {
            if (constructor.getParameterCount() != params.length) continue;
            Class<?>[] types = constructor.getParameterTypes();
            boolean match = true;
            for (int i = 0; i < params.length; ++i) {
                if ((!Objects.isNull(params[i]) || !types[i].isPrimitive()) && Reflection.compatible(types[i], params[i])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            if (!Modifier.isPublic(constructor.getModifiers()) && !constructor.trySetAccessible()) {
                Reflection.setAccessible(constructor);
            }
            return constructor;
        }
        throw new UnsupportedOperationException("Unable to find proper constructor for class " + cls.getCanonicalName());
    }

    public static boolean compatible(Class<?> type, Object obj) {
        if (Objects.nonNull(obj)) {
            Class<?> aClass;
            boolean bl;
            if (obj instanceof Class) {
                Class c = (Class)obj;
                bl = true;
            } else {
                bl = false;
            }
            boolean isClass = bl;
            Class<?> clazz = aClass = isClass ? (Class<?>)obj : obj.getClass();
            if (type.isPrimitive()) {
                return type.equals(TypeUtils.getPrimitiveType(aClass));
            }
            return isClass && type.isInstance(aClass) || type.isAssignableFrom(aClass);
        }
        return !type.isPrimitive();
    }

    public static Class<?> initialize(String cls, Object ... params) {
        return Reflection.instantiate(Reflection.loadClass(cls), params).getClass();
    }

    public static Field findField(Class<?> cls, String name) {
        try {
            return cls.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            try {
                return cls.getField(name);
            }
            catch (NoSuchFieldException ex) {
                Field[] fields;
                for (Field field : fields = (Field[])Reflection.invoke(declaredFields, cls, false)) {
                    if (!field.getName().equals(name)) continue;
                    return field;
                }
                if (Objects.nonNull(cls.getSuperclass())) {
                    return Reflection.findField(cls.getSuperclass(), name);
                }
                return null;
            }
        }
    }

    public static <T> T getFieldValueUnsafe(Object obj, String name) {
        try {
            Field field = Reflection.findField(obj.getClass(), name);
            return (T)unsafe.getObject(obj, unsafe.objectFieldOffset(field));
        }
        catch (Exception e) {
            log.error("Unable to get value for field {} of {}", new Object[]{name, obj.getClass().getName(), e});
            return null;
        }
    }

    public static <T> T getFieldValue(Object obj, String name) {
        return Reflection.getFieldValue(obj.getClass(), obj, name);
    }

    public static void setFieldValue(Class cls, Object obj, String name, Object value) {
        try {
            Field field = Reflection.findField(cls, name);
            if (!field.trySetAccessible()) {
                Reflection.setAccessible(field);
            }
            field.set(obj, value);
        }
        catch (Exception e) {
            log.error("Unable to set value for field {} of {}", new Object[]{name, obj.getClass().getName(), e});
        }
    }

    public static void setFieldValue(Object obj, String name, Object value) {
        Reflection.setFieldValue(obj.getClass(), obj, name, value);
    }

    public static <T> T getFieldValue(Class cls, Object obj, String name) {
        return Reflection.getFieldValue(Reflection.findField(cls, name), obj, name);
    }

    protected static <T> T getFieldValue(Field field, Object obj, String name) {
        try {
            if (!field.trySetAccessible()) {
                Reflection.setAccessible(field);
            }
            return (T)field.get(obj);
        }
        catch (Exception e) {
            log.error("Unable to get value for field {} of {}", new Object[]{name, obj.getClass().getName(), e});
            return null;
        }
    }

    public static <T> T getFieldValue(Field field, Object obj) {
        return Reflection.getFieldValue(field, obj, field.getName());
    }

    public static <T> T getStaticFieldValue(Class cls, String name) {
        try {
            Field field = Reflection.findField(cls, name);
            if (!field.trySetAccessible()) {
                Reflection.setAccessible(field);
            }
            return (T)field.get(null);
        }
        catch (Exception e) {
            log.error("Unable to get value for field {} of {}", new Object[]{name, cls.getName(), e});
            return null;
        }
    }

    public static void withLoader(ClassLoader loader, Runnable task) {
        try {
            Reflection.loader = loader;
            task.run();
        }
        finally {
            Reflection.loader = null;
        }
    }

    public static boolean isGetter(Method method) {
        String name = method.getName();
        return !method.getReturnType().equals(Void.TYPE) && method.getParameterCount() == 0 && (name.startsWith("get") && name.length() > 3 && Character.isUpperCase(name.charAt(3)) || name.startsWith("is") && name.length() > 2 && Character.isUpperCase(name.charAt(2)));
    }

    public static boolean isSetter(Method method) {
        String name = method.getName();
        return method.getReturnType().equals(Void.TYPE) && method.getParameterCount() == 1 && name.startsWith("set") && name.length() > 3 && Character.isUpperCase(name.charAt(3));
    }

    public static Method findMethod(String name, Class cls, Class ... params) {
        Method result = null;
        try {
            result = cls.getDeclaredMethod(name, params);
        }
        catch (Exception e) {
            try {
                result = cls.getMethod(name, params);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static <T> T invoke(Method m, Object instance, Object ... args) {
        try {
            if (!m.trySetAccessible()) {
                Reflection.setAccessible(m);
            }
            return (T)m.invoke(instance, args);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T invoke(String name, Object instance, Object ... args) {
        try {
            Method m = Reflection.findMethod(name, instance.getClass(), (Class[])Arrays.stream(args).map(Object::getClass).toArray(Class[]::new));
            if (Objects.nonNull(m)) {
                return Reflection.invoke(m, instance, args);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static <T> T invokeStatic(Method m, Object ... args) {
        try {
            return (T)m.invoke(null, args);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T invokeStaticWithException(Method m, Object ... args) {
        try {
            return (T)m.invoke(null, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (Exception e) {
            throw e;
        }
    }

    public static <T> T invokeStatic(String name, Class cls, Object ... args) {
        try {
            return (T)Reflection.findMethod(name, cls, (Class[])Arrays.stream(args).map(Object::getClass).toArray(Class[]::new)).invoke(null, args);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<Method> findMethods(Class cls, Predicate<? super Method> filter) {
        return Arrays.stream(cls.getMethods()).filter(filter).toList();
    }

    public static Unsafe getUnsafe() {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.trySetAccessible();
            return (Unsafe)theUnsafe.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setAccessible(Member m) {
        try {
            unsafe.putBooleanVolatile(m, offset, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static long getFirstFieldOffset() {
        try {
            return unsafe.objectFieldOffset(Parent.class.getDeclaredField("first"));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        unsafe = Reflection.getUnsafe();
        declaredFields = Reflection.findMethod("getDeclaredFields0", Class.class, Boolean.TYPE);
        offset = Reflection.getFirstFieldOffset();
    }

    static class Parent {
        boolean first;

        private Parent() {
        }
    }
}

