/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.tools;

import java.util.HashMap;
import java.util.Map;

public class TypeUtils {
    protected static final Map<Class<?>, Class<?>> primitiveWrapperMap = new HashMap();
    protected static final Map<Class<?>, Class<?>> wrapperPrimitiveMap;

    public static boolean isWrapperType(Class<?> type) {
        return wrapperPrimitiveMap.containsKey(type);
    }

    public static Class<?> getPrimitiveType(Class<?> type) {
        if (type.isPrimitive()) {
            return type;
        }
        return wrapperPrimitiveMap.get(type);
    }

    static {
        primitiveWrapperMap.put(Boolean.TYPE, Boolean.class);
        primitiveWrapperMap.put(Byte.TYPE, Byte.class);
        primitiveWrapperMap.put(Character.TYPE, Character.class);
        primitiveWrapperMap.put(Short.TYPE, Short.class);
        primitiveWrapperMap.put(Integer.TYPE, Integer.class);
        primitiveWrapperMap.put(Long.TYPE, Long.class);
        primitiveWrapperMap.put(Double.TYPE, Double.class);
        primitiveWrapperMap.put(Float.TYPE, Float.class);
        primitiveWrapperMap.put(Void.TYPE, Void.TYPE);
        wrapperPrimitiveMap = new HashMap();
        for (Map.Entry<Class<?>, Class<?>> entry : primitiveWrapperMap.entrySet()) {
            Class<?> wrapperClass;
            Class<?> primitiveClass = entry.getKey();
            if (primitiveClass.equals(wrapperClass = entry.getValue())) continue;
            wrapperPrimitiveMap.put(wrapperClass, primitiveClass);
        }
    }
}

