/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.tools;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.binis.codegen.objects.Pair;

public abstract class BaseStringInterpolator<T> {
    protected static final String INVALID_EXPRESSION = "Invalid expression!";
    protected Character identifier;
    protected List<Pair<SegmentType, String>> segments = new ArrayList<Pair<SegmentType, String>>();

    public List<Pair<SegmentType, String>> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    protected T buildExpression(String exp) {
        ArrayList<T> list = new ArrayList<T>();
        boolean flag = true;
        int start = 0;
        for (int i = 0; i < exp.length(); ++i) {
            if (Objects.isNull(this.identifier) && '{' == exp.charAt(i) || Objects.nonNull(this.identifier) && this.identifier.charValue() == exp.charAt(i) && i + 1 < exp.length() && '{' == exp.charAt(i + 1)) {
                String constant;
                if (!flag) {
                    throw new InvalidParameterException(INVALID_EXPRESSION + exp);
                }
                if (start < i && !(constant = exp.substring(start, i)).isEmpty()) {
                    list.add(this.internalBuildConstantExpression(constant));
                }
                start = i + 1;
                if (Objects.nonNull(this.identifier)) {
                    ++start;
                }
                flag = false;
                continue;
            }
            if ('}' != exp.charAt(i) || flag && Objects.nonNull(this.identifier)) continue;
            if (flag) {
                throw new InvalidParameterException(INVALID_EXPRESSION + exp);
            }
            if (start < i) {
                String e = exp.substring(start, i);
                list.add(this.internalBuildParamExpression(e));
            }
            start = i + 1;
            flag = true;
        }
        if (!flag) {
            throw new InvalidParameterException(INVALID_EXPRESSION + exp);
        }
        if (start < exp.length()) {
            list.add(this.internalBuildConstantExpression(exp.substring(start)));
        }
        return (T)this.complexExpression(list);
    }

    protected abstract T buildConstantExpression(String var1);

    protected abstract T buildComplexExpression(List<T> var1);

    protected T complexExpression(List<T> list) {
        if (list.size() == 1) {
            return list.get(0);
        }
        return this.buildComplexExpression(list);
    }

    protected abstract T buildParamExpression(String var1);

    protected T internalBuildConstantExpression(String exp) {
        this.segments.add(Pair.of(SegmentType.CONSTANT, exp));
        return this.buildConstantExpression(exp);
    }

    protected T internalBuildParamExpression(String exp) {
        this.segments.add(Pair.of(SegmentType.PARAM, exp));
        return this.buildParamExpression(exp);
    }

    public static enum SegmentType {
        CONSTANT,
        PARAM;

    }
}

