/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.collection;

import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.binis.codegen.collection.CodeList;

public class CodeListImpl<T, R>
implements CodeList<T, R> {
    private final R parent;
    private final List<T> list;
    private final Consumer<T> validator;

    public CodeListImpl(R parent, List<T> list) {
        this.parent = parent;
        this.list = list;
        this.validator = null;
    }

    public CodeListImpl(R parent, List<T> list, Consumer<T> validator) {
        this.parent = parent;
        this.list = list;
        this.validator = validator;
    }

    @Override
    public CodeList<T, R> add(T value) {
        this.validate(value);
        this.list.add(value);
        return this;
    }

    @Override
    public R done() {
        return this.parent;
    }

    @Override
    public CodeList<T, R> _if(boolean condition, Consumer<CodeList<T, R>> consumer) {
        if (condition) {
            consumer.accept(this);
        }
        return this;
    }

    @Override
    public CodeList<T, R> _if(boolean condition, BiConsumer<CodeList<T, R>, R> consumer) {
        if (condition) {
            consumer.accept(this, this.parent);
        }
        return this;
    }

    @Override
    public CodeList<T, R> _if(boolean condition, Consumer<CodeList<T, R>> consumer, Consumer<CodeList<T, R>> elseConsumer) {
        if (condition) {
            consumer.accept(this);
        } else {
            elseConsumer.accept(this);
        }
        return this;
    }

    @Override
    public CodeList<T, R> _if(boolean condition, BiConsumer<CodeList<T, R>, R> consumer, BiConsumer<CodeList<T, R>, R> elseConsumer) {
        if (condition) {
            consumer.accept(this, this.parent);
        } else {
            elseConsumer.accept(this, this.parent);
        }
        return this;
    }

    @Override
    public CodeList<T, R> _self(BiConsumer<CodeList<T, R>, R> consumer) {
        consumer.accept(this, this.parent);
        return this;
    }

    @Override
    public CodeList<T, R> _map(Object source) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    protected void validate(T value) {
        if (Objects.nonNull(this.validator)) {
            this.validator.accept(value);
        }
    }
}

